/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config;

import java.util.Locale;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.osgi.bundle.BundleFactoryBean;
import org.springframework.osgi.config.internal.util.AttributeCallback;
import org.springframework.osgi.config.internal.util.ParserUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class BundleBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ACTION = "action";
    private static final String DESTROY_ACTION = "destroy-action";
    private static final String ACTION_PROP = "action";
    private static final String DESTROY_ACTION_PROP = "destroyAction";
    private static final String BUNDLE_PROP = "bundle";

    BundleBeanDefinitionParser() {
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        BundleActionCallback callback = new BundleActionCallback();
        ParserUtils.parseCustomAttributes(element, builder, new AttributeCallback[]{callback});
        if (element.hasChildNodes()) {
            NodeList nodes = element.getChildNodes();
            boolean foundElement = false;
            for (int i = 0; i < nodes.getLength() && !foundElement; ++i) {
                Node nd = nodes.item(i);
                if (!(nd instanceof Element)) continue;
                foundElement = true;
                Object obj = parserContext.getDelegate().parsePropertySubElement((Element)nd, (BeanDefinition)builder.getBeanDefinition());
                builder.addPropertyValue(BUNDLE_PROP, obj);
            }
        }
        builder.setRole(2);
    }

    protected Class getBeanClass(Element element) {
        return BundleFactoryBean.class;
    }

    static class BundleActionCallback
    implements AttributeCallback {
        BundleActionCallback() {
        }

        public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder builder) {
            String name = attribute.getLocalName();
            if ("action".equals(name)) {
                builder.addPropertyValue("action", this.parseAction(parent, attribute));
                return false;
            }
            if (BundleBeanDefinitionParser.DESTROY_ACTION.equals(name)) {
                builder.addPropertyValue(BundleBeanDefinitionParser.DESTROY_ACTION_PROP, this.parseAction(parent, attribute));
                return false;
            }
            return true;
        }

        private Object parseAction(Element parent, Attr attribute) {
            return attribute.getValue().toUpperCase(Locale.ENGLISH);
        }
    }
}

