/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.netmgt.icmp.proxy.IPRangeDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepRequestBuilder;
import org.opennms.netmgt.icmp.proxy.PingSweepRequestDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepResponseDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepResultDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepSummary;

public class PingSweepRequestBuilderImpl
implements PingSweepRequestBuilder {
    private final RpcClient<PingSweepRequestDTO, PingSweepResponseDTO> client;
    private int packetSize = 64;
    private double packetsPerSecond = 1.0;
    private String location;
    private List<IPRangeDTO> ranges = new ArrayList<IPRangeDTO>();

    public PingSweepRequestBuilderImpl(RpcClient<PingSweepRequestDTO, PingSweepResponseDTO> client) {
        this.client = Objects.requireNonNull(client);
    }

    @Override
    public PingSweepRequestBuilder withPacketSize(int packetSize) {
        this.packetSize = packetSize > 0 ? packetSize : this.packetSize;
        return this;
    }

    @Override
    public PingSweepRequestBuilder withPacketsPerSecond(double packetsPerSecond) {
        this.packetsPerSecond = packetsPerSecond;
        return this;
    }

    @Override
    public PingSweepRequestBuilder withLocation(String location) {
        this.location = location;
        return this;
    }

    @Override
    public PingSweepRequestBuilder withRange(InetAddress begin, InetAddress end) {
        return this.withRange(begin, end, 2, 800L, TimeUnit.MILLISECONDS);
    }

    @Override
    public PingSweepRequestBuilder withRange(InetAddress begin, InetAddress end, int retries, long timeout, TimeUnit timeoutUnit) {
        this.ranges.add(new IPRangeDTO(begin, end, retries, TimeUnit.MILLISECONDS.convert(timeout, timeoutUnit)));
        return this;
    }

    @Override
    public CompletableFuture<PingSweepSummary> execute() {
        PingSweepRequestDTO requestDTO = new PingSweepRequestDTO();
        requestDTO.setIpRanges(this.ranges);
        requestDTO.setLocation(this.location);
        requestDTO.setPacketSize(this.packetSize);
        requestDTO.setPacketsPerSecond(this.packetsPerSecond);
        return this.client.execute((RpcRequest)requestDTO).thenApply(responseDTO -> {
            PingSweepSummary summary = new PingSweepSummary();
            LinkedHashMap<InetAddress, Double> responses = new LinkedHashMap<InetAddress, Double>();
            for (PingSweepResultDTO result : responseDTO.getPingSweepResult()) {
                responses.put(result.getAddress(), result.getRtt());
            }
            summary.setResponses(responses);
            return summary;
        });
    }

    public RpcClient<PingSweepRequestDTO, PingSweepResponseDTO> getClient() {
        return this.client;
    }
}

