/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support.builder;

import java.util.Objects;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.collection.adapters.NodeLevelResourceAdapter;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.support.builder.AbstractResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.model.ResourcePath;

@XmlJavaTypeAdapter(value=NodeLevelResourceAdapter.class)
public class NodeLevelResource
extends AbstractResource {
    private final int m_nodeId;
    private final String m_path;

    public NodeLevelResource(int nodeId) {
        this(nodeId, null);
    }

    public NodeLevelResource(int nodeId, String path) {
        this.m_nodeId = nodeId;
        this.m_path = path;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getPath() {
        return this.m_path;
    }

    @Override
    public Resource getParent() {
        return null;
    }

    @Override
    public String getInstance() {
        return "node";
    }

    @Override
    public ResourcePath getPath(CollectionResource resource) {
        return this.m_path == null ? ResourcePath.get((String[])new String[0]) : ResourcePath.get((String[])new String[]{this.m_path});
    }

    @Override
    public String getTypeName() {
        return "node";
    }

    public String toString() {
        return String.format("NodeLevelResource[nodeId=%d, path=%s]", this.m_nodeId, this.m_path);
    }

    public int hashCode() {
        return Objects.hash(this.m_nodeId, this.m_path, this.getTimestamp());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeLevelResource)) {
            return false;
        }
        NodeLevelResource other = (NodeLevelResource)obj;
        return Objects.equals(this.m_nodeId, other.m_nodeId) && Objects.equals(this.getPath(), other.getPath()) && Objects.equals(this.getTimestamp(), other.getTimestamp());
    }
}

