/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support.builder;

import java.util.Objects;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.collection.adapters.DeferredGenericTypeResourceAdapter;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.ResourceType;
import org.opennms.netmgt.collection.api.ResourceTypeMapper;
import org.opennms.netmgt.collection.support.builder.AbstractResource;
import org.opennms.netmgt.collection.support.builder.GenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.model.ResourcePath;

@XmlJavaTypeAdapter(value=DeferredGenericTypeResourceAdapter.class)
public class DeferredGenericTypeResource
extends AbstractResource {
    private final NodeLevelResource m_node;
    private final String m_resourceTypeName;
    private final String m_fallbackResourceTypeName;
    private final String m_instance;

    public DeferredGenericTypeResource(NodeLevelResource node, String resourceTypeName, String instance) {
        this(node, resourceTypeName, null, instance);
    }

    public DeferredGenericTypeResource(NodeLevelResource node, String resourceTypeName, String fallbackResourceTypeName, String instance) {
        this.m_node = Objects.requireNonNull(node, "node argument");
        this.m_resourceTypeName = Objects.requireNonNull(resourceTypeName, "resourceTypeName argument");
        this.m_fallbackResourceTypeName = fallbackResourceTypeName;
        this.m_instance = GenericTypeResource.sanitizeInstance(Objects.requireNonNull(instance, "instance argument"));
    }

    @Override
    public NodeLevelResource getParent() {
        return this.m_node;
    }

    @Override
    public String getTypeName() {
        return this.m_resourceTypeName;
    }

    public String getFallbackTypeName() {
        return this.m_fallbackResourceTypeName;
    }

    @Override
    public String getInstance() {
        return this.m_instance;
    }

    @Override
    public ResourcePath getPath(CollectionResource resource) {
        throw new UnsupportedOperationException("DeferredGenericTypeResource must be converted to GenericTypeResources before being used to build resource paths.");
    }

    @Override
    public Resource resolve() {
        ResourceType resourceType = ResourceTypeMapper.getInstance().getResourceTypeWithFallback(this.m_resourceTypeName, this.m_fallbackResourceTypeName);
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("No resource type found with name '%s'!", this.m_resourceTypeName));
        }
        GenericTypeResource resource = new GenericTypeResource(this.m_node, resourceType, this.m_instance);
        resource.setTimestamp(this.getTimestamp());
        return resource;
    }

    public String toString() {
        return String.format("DeferredGenericTypeResource[node=%s, instance=%s, resourceTypeName=%s, fallbackResourceTypeName=%s]", this.m_node, this.m_instance, this.m_resourceTypeName, this.m_fallbackResourceTypeName);
    }

    public int hashCode() {
        return Objects.hash(this.m_node, this.m_resourceTypeName, this.m_fallbackResourceTypeName, this.m_instance, this.getTimestamp());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeferredGenericTypeResource)) {
            return false;
        }
        DeferredGenericTypeResource other = (DeferredGenericTypeResource)obj;
        return Objects.equals(this.m_node, other.m_node) && Objects.equals(this.m_resourceTypeName, other.m_resourceTypeName) && Objects.equals(this.m_fallbackResourceTypeName, other.m_fallbackResourceTypeName) && Objects.equals(this.m_instance, other.m_instance) && Objects.equals(this.getTimestamp(), other.getTimestamp());
    }
}

