/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.util.SessionProperties;
import org.sblim.wbem.util.XMLHostStr;

public class CIMNameSpace
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4090304642015551161L;
    private static final String HTTP = "http";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = null;
    private static final int DEFAULT_PORT = 5988;
    private static final String DEFAULT_NAMESPACE = "root/cimv2";
    private static final String DEFAULT_FILE = "/cimom";
    public static final char NAMESPACE_SEPARATOR = '/';
    private String iProtocol;
    private String iHost;
    private String iFile;
    private String iNameSpace;
    private int iPort;

    public CIMNameSpace() throws CIMException {
        this.iProtocol = "http";
        this.iHost = DEFAULT_HOST;
        this.iPort = 5988;
        this.iFile = DEFAULT_FILE;
        this.iNameSpace = DEFAULT_NAMESPACE;
    }

    public CIMNameSpace(String pURI) throws CIMException {
        this(pURI, null);
    }

    public CIMNameSpace(String pHost, String pNamespace) throws CIMException {
        if (pHost == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "Null hostName is not allowed!");
        }
        XMLHostStr xmlHostStr = new XMLHostStr(pHost);
        String prot = xmlHostStr.getProtocol();
        String host = xmlHostStr.getHost();
        String port = xmlHostStr.getPort();
        String file = xmlHostStr.getFile();
        this.iProtocol = prot == null ? "http" : prot;
        this.iHost = host == null ? DEFAULT_HOST : host;
        this.iPort = port == null ? 5988 : Integer.parseInt(port);
        this.iFile = file == null ? DEFAULT_FILE : file;
        this.iNameSpace = pNamespace == null ? DEFAULT_NAMESPACE : pNamespace;
    }

    public Object clone() {
        CIMNameSpace that = new CIMNameSpace();
        that.iProtocol = this.iProtocol;
        that.iHost = this.iHost;
        that.iFile = this.iFile;
        that.iNameSpace = this.iNameSpace;
        that.iPort = this.iPort;
        return that;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMNameSpace)) {
            return false;
        }
        CIMNameSpace that = (CIMNameSpace)o;
        return CIMNameSpace.equals(this.iProtocol, that.iProtocol) && CIMNameSpace.equals(this.iHost, that.iHost) && CIMNameSpace.equals(this.iFile, that.iFile) && CIMNameSpace.equals(this.iNameSpace, that.iNameSpace) && this.iPort == that.iPort;
    }

    private static final boolean equals(String pA, String pB) {
        return pA == null ? pB == null : pA.equalsIgnoreCase(pB);
    }

    public String getHost() {
        return this.iHost;
    }

    public URI getHostURI() throws CIMException {
        String path = this.iFile;
        if (path.charAt(0) != '/') {
            path = '/' + path;
        }
        try {
            return new URI(this.iProtocol, null, this.iHost, this.iPort, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", e);
        }
    }

    public URL getHostURL() throws CIMException {
        try {
            return this.getHostURI().toURL();
        }
        catch (Throwable e) {
            Logger logger = SessionProperties.getGlobalProperties().getLogger();
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "invalid URI format", e);
            }
            try {
                return new URL(this.getScheme(), this.getHost(), this.getPort(), this.getNameSpace());
            }
            catch (Throwable n) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "invalid URI format", e);
                }
                throw new CIMException("CIM_ERR_FAILED", n, "malformed URI");
            }
        }
    }

    public String getNameSpace() {
        return this.iNameSpace;
    }

    public String getScheme() {
        return this.iProtocol;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static CIMNameSpace parse(String pURI) throws CIMException {
        return new CIMNameSpace(pURI);
    }

    public void setPort(int pPort) {
        if (pPort < 0) {
            throw new IllegalArgumentException("invalid port number argument: " + pPort);
        }
        this.iPort = pPort;
    }

    public int getPort() {
        return this.iPort;
    }

    public void setHost(String pHost) {
        XMLHostStr xmlHostStr = new XMLHostStr(pHost);
        String prot = xmlHostStr.getProtocol();
        if (prot != null) {
            this.iProtocol = prot;
        }
        this.iHost = xmlHostStr.getHost();
        String port = xmlHostStr.getPort();
        if (port != null) {
            this.iPort = Integer.parseInt(port);
        }
        this.iFile = xmlHostStr.getFile();
    }

    public void setNameSpace(String pNamespace) throws CIMException {
        if (pNamespace == null) {
            throw new IllegalArgumentException("null namespace argument");
        }
        this.iNameSpace = pNamespace;
    }

    public String toString() {
        return "//" + (this.iHost == null ? "" : this.iHost) + '/' + (this.iNameSpace == null ? "" : this.iNameSpace) + "/";
    }
}

