/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.camel;

import java.util.Properties;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.rpc.camel.CamelRpcRequest;
import org.opennms.core.utils.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelRpcClientPreProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRpcClientPreProcessor.class);
    public static final String CAMEL_JMS_REQUEST_TIMEOUT_PROPERTY = "org.opennms.jms.timeout";
    public static final long CAMEL_JMS_REQUEST_TIMEOUT_DEFAULT = 20000L;
    protected final Long CAMEL_JMS_REQUEST_TIMEOUT;

    public CamelRpcClientPreProcessor() {
        long camelJmsRequestTimeout = PropertiesUtils.getProperty((Properties)System.getProperties(), (String)CAMEL_JMS_REQUEST_TIMEOUT_PROPERTY, (long)20000L);
        if (camelJmsRequestTimeout <= 0L) {
            LOG.error("Invalid value {} for property {} - must be greater than zero!", (Object)camelJmsRequestTimeout, (Object)CAMEL_JMS_REQUEST_TIMEOUT_PROPERTY);
            camelJmsRequestTimeout = 20000L;
        }
        LOG.debug("Value {} set for property {}", (Object)camelJmsRequestTimeout, (Object)CAMEL_JMS_REQUEST_TIMEOUT_PROPERTY);
        this.CAMEL_JMS_REQUEST_TIMEOUT = camelJmsRequestTimeout;
    }

    public void process(Exchange exchange) {
        CamelRpcRequest wrapper = (CamelRpcRequest)exchange.getIn().getBody(CamelRpcRequest.class);
        JmsQueueNameFactory queueNameFactory = new JmsQueueNameFactory("RPC", wrapper.getModule().getId(), wrapper.getRequest().getLocation());
        exchange.getIn().setHeader("JmsQueueName", (Object)queueNameFactory.getName());
        exchange.getIn().setHeader("CamelJmsRequestTimeout", (Object)(wrapper.getRequest().getTimeToLiveMs() != null ? wrapper.getRequest().getTimeToLiveMs() : this.CAMEL_JMS_REQUEST_TIMEOUT));
        String request = wrapper.getModule().marshalRequest(wrapper.getRequest());
        exchange.getIn().setBody((Object)request);
    }
}

