/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.surveillanceViews;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.surveillanceViews.ColumnDef;
import org.opennms.netmgt.config.surveillanceViews.RowDef;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="view")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="surveillance-views.xsd")
public class View
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final int DEFAULT_REFRESH_SECONDS = 300;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="refresh-seconds")
    private Integer m_refreshSeconds;
    @XmlElementWrapper(name="rows", required=true)
    @XmlElement(name="row-def", required=true)
    private List<RowDef> m_rows = new ArrayList<RowDef>();
    @XmlElementWrapper(name="columns", required=true)
    @XmlElement(name="column-def", required=true)
    private List<ColumnDef> m_columns = new ArrayList<ColumnDef>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Integer getRefreshSeconds() {
        return this.m_refreshSeconds != null ? this.m_refreshSeconds : 300;
    }

    public void setRefreshSeconds(Integer refreshSeconds) {
        this.m_refreshSeconds = refreshSeconds;
    }

    public List<RowDef> getRows() {
        return this.m_rows;
    }

    public void setRows(List<RowDef> rows) {
        ConfigUtils.assertMinimumSize(rows, 1L, "row-def");
        if (rows == this.m_rows) {
            return;
        }
        this.m_rows.clear();
        if (rows != null) {
            this.m_rows.addAll(rows);
        }
    }

    public void addRow(RowDef row) {
        this.m_rows.add(row);
    }

    public void addRow(String label, String ... categories) {
        this.m_rows.add(new RowDef(label, categories));
    }

    public boolean removeRow(RowDef row) {
        return this.m_rows.remove(row);
    }

    public List<ColumnDef> getColumns() {
        return this.m_columns;
    }

    public void setColumns(List<ColumnDef> columns) {
        ConfigUtils.assertMinimumSize(columns, 1L, "column-def");
        if (columns == this.m_columns) {
            return;
        }
        this.m_columns.clear();
        if (columns != null) {
            this.m_columns.addAll(columns);
        }
    }

    public void addColumn(ColumnDef column) {
        this.m_columns.add(column);
    }

    public void addColumn(String label, String ... categories) {
        this.m_columns.add(new ColumnDef(label, categories));
    }

    public boolean removeColumn(ColumnDef column) {
        return this.m_columns.remove(column);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_refreshSeconds, this.m_rows, this.m_columns);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof View) {
            View that = (View)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_refreshSeconds, that.m_refreshSeconds) && Objects.equals(this.m_rows, that.m_rows) && Objects.equals(this.m_columns, that.m_columns);
        }
        return false;
    }
}

