/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.discovery;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="include-range")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="discovery-configuration.xsd")
public class IncludeRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="location")
    private String m_location;
    @XmlAttribute(name="retries")
    private Integer m_retries;
    @XmlAttribute(name="timeout")
    private Long m_timeout;
    @XmlAttribute(name="foreign-source")
    private String m_foreignSource;
    @XmlElement(name="begin", required=true)
    private String m_begin;
    @XmlElement(name="end", required=true)
    private String m_end;

    public IncludeRange() {
    }

    public IncludeRange(String begin, String end) {
        this.setBegin(begin);
        this.setEnd(end);
    }

    public Optional<String> getLocation() {
        return Optional.ofNullable(this.m_location);
    }

    public void setLocation(String location) {
        this.m_location = ConfigUtils.normalizeString(location);
    }

    public Optional<Integer> getRetries() {
        return Optional.ofNullable(this.m_retries);
    }

    public void setRetries(Integer retries) {
        this.m_retries = retries;
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.m_timeout);
    }

    public void setTimeout(Long timeout) {
        if (timeout != null && timeout == 0L) {
            throw new IllegalArgumentException("Can't have a 0 timeout!");
        }
        this.m_timeout = timeout;
    }

    public Optional<String> getForeignSource() {
        return Optional.ofNullable(this.m_foreignSource);
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = ConfigUtils.normalizeString(foreignSource);
    }

    public String getBegin() {
        return this.m_begin;
    }

    public void setBegin(String begin) {
        this.m_begin = ConfigUtils.assertNotEmpty(begin, "begin");
    }

    public String getEnd() {
        return this.m_end;
    }

    public void setEnd(String end) {
        this.m_end = ConfigUtils.assertNotEmpty(end, "end");
    }

    public int hashCode() {
        return Objects.hash(this.m_location, this.m_retries, this.m_timeout, this.m_foreignSource, this.m_begin, this.m_end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IncludeRange) {
            IncludeRange temp = (IncludeRange)obj;
            return Objects.equals(temp.m_location, this.m_location) && Objects.equals(temp.m_retries, this.m_retries) && Objects.equals(temp.m_timeout, this.m_timeout) && Objects.equals(temp.m_foreignSource, this.m_foreignSource) && Objects.equals(temp.m_begin, this.m_begin) && Objects.equals(temp.m_end, this.m_end);
        }
        return false;
    }

    public String toString() {
        return "IncludeRange [location=" + this.m_location + ", retries=" + this.m_retries + ", timeout=" + this.m_timeout + ", foreignSource=" + this.m_foreignSource + ", begin=" + this.m_begin + ", end=" + this.m_end + "]";
    }
}

