/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.dns.client.rpc;

import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.LocationAwareDnsLookupClient;
import org.opennms.netmgt.provision.dns.client.rpc.DnsLookupClientRpcModule;
import org.opennms.netmgt.provision.dns.client.rpc.DnsLookupRequestDTO;
import org.opennms.netmgt.provision.dns.client.rpc.DnsLookupResponseDTO;
import org.opennms.netmgt.provision.dns.client.rpc.QueryType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class LocationAwareDnsLookupClientRpcImpl
implements LocationAwareDnsLookupClient,
InitializingBean {
    @Autowired
    private RpcClientFactory rpcClientFactory;
    @Autowired
    private DnsLookupClientRpcModule dnsLookupClientRpcModule;
    private RpcClient<DnsLookupRequestDTO, DnsLookupResponseDTO> delegate;

    public void afterPropertiesSet() {
        this.delegate = this.rpcClientFactory.getClient((RpcModule)this.dnsLookupClientRpcModule);
    }

    public CompletableFuture<String> lookup(String hostName, String location) {
        return this.lookupExecute(hostName, location, QueryType.LOOKUP);
    }

    public CompletableFuture<String> reverseLookup(InetAddress ipAddress, String location) {
        return this.lookupExecute(InetAddressUtils.toIpAddrString((InetAddress)ipAddress), location, QueryType.REVERSE_LOOKUP);
    }

    public RpcClient<DnsLookupRequestDTO, DnsLookupResponseDTO> getDelegate() {
        return this.delegate;
    }

    private CompletableFuture<String> lookupExecute(String request, String location, QueryType queryType) {
        DnsLookupRequestDTO dto = new DnsLookupRequestDTO();
        dto.setHostRequest(request);
        dto.setLocation(location);
        dto.setQueryType(queryType);
        CompletableFuture future = this.getDelegate().execute((RpcRequest)dto);
        return future.thenApply(response -> response.getHostResponse());
    }
}

