/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentInProgress$;
import kafka.admin.ReassignmentStatus;
import kafka.cluster.Broker;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ReassignedPartitionsContext;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReassignPartitionsCommand$
implements Logging {
    public static final ReassignPartitionsCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommand$ reassignPartitionsCommand$ = this;
        synchronized (reassignPartitionsCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = this.validateAndParseArgs(args);
        String zkConnect = (String)opts.options().valueOf(opts.zkConnectOpt());
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkConnect, 30000, 30000, JaasUtils.isZkSecurityEnabled());
        try {
            if (opts.options().has((OptionSpec)opts.verifyOpt())) {
                this.verifyAssignment(zkUtils, opts);
            } else if (opts.options().has((OptionSpec)opts.generateOpt())) {
                this.generateAssignment(zkUtils, opts);
            } else if (opts.options().has((OptionSpec)opts.executeOpt())) {
                this.executeAssignment(zkUtils, opts);
            }
            zkUtils.close();
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Partitions reassignment failed due to ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)throwable));
            }
            finally {
                zkUtils.close();
            }
        }
    }

    public void verifyAssignment(ZkUtils zkUtils, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String jsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String jsonString = Utils.readFileAsString((String)jsonFile);
        this.verifyAssignment(zkUtils, jsonString);
    }

    public void verifyAssignment(ZkUtils zkUtils, String jsonString) {
        Predef$.MODULE$.println((Object)"Status of partition reassignment: ");
        Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned = ZkUtils$.MODULE$.parsePartitionReassignmentData(jsonString);
        Map<TopicAndPartition, ReassignmentStatus> reassignedPartitionsStatus = this.checkIfReassignmentSucceeded(zkUtils, partitionsToBeReassigned);
        reassignedPartitionsStatus.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<TopicAndPartition, ReassignmentStatus> x0$1) {
                Tuple2<TopicAndPartition, ReassignmentStatus> tuple2;
                block2: {
                    ReassignmentStatus reassignmentStatus;
                    block6: {
                        block4: {
                            TopicAndPartition topicPartition;
                            block5: {
                                block3: {
                                    ReassignmentStatus status;
                                    tuple2 = x0$1;
                                    if (tuple2 == null) break block2;
                                    topicPartition = (TopicAndPartition)tuple2._1();
                                    reassignmentStatus = status = (ReassignmentStatus)tuple2._2();
                                    ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                                    ReassignmentStatus reassignmentStatus2 = reassignmentStatus;
                                    if (reassignmentCompleted$ != null ? !reassignmentCompleted$.equals(reassignmentStatus2) : reassignmentStatus2 != null) break block3;
                                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s completed successfully")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block4;
                                }
                                ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
                                ReassignmentStatus reassignmentStatus3 = reassignmentStatus;
                                if (reassignmentFailed$ != null ? !reassignmentFailed$.equals(reassignmentStatus3) : reassignmentStatus3 != null) break block5;
                                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            ReassignmentInProgress$ reassignmentInProgress$ = ReassignmentInProgress$.MODULE$;
                            ReassignmentStatus reassignmentStatus4 = reassignmentStatus;
                            if (reassignmentInProgress$ != null ? !reassignmentInProgress$.equals(reassignmentStatus4) : reassignmentStatus4 != null) break block6;
                            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s is still in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError((Object)reassignmentStatus);
                }
                throw new MatchError(tuple2);
            }
        });
        this.removeThrottle(zkUtils, partitionsToBeReassigned, reassignedPartitionsStatus);
    }

    private void removeThrottle(ZkUtils zkUtils, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicAndPartition, ReassignmentStatus> reassignedPartitionsStatus) {
        BooleanRef changed = new BooleanRef(false);
        if (reassignedPartitionsStatus.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, ReassignmentStatus> x0$2) {
                Tuple2<TopicAndPartition, ReassignmentStatus> tuple2 = x0$2;
                if (tuple2 != null) {
                    ReassignmentStatus status;
                    ReassignmentStatus reassignmentStatus = status = (ReassignmentStatus)tuple2._2();
                    ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                    boolean bl = !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })) {
            ((IterableLike)zkUtils.getAllBrokersInCluster().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Broker x$1) {
                    return x$1.id();
                }
            }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(zkUtils, changed){
                public static final long serialVersionUID = 0L;
                private final ZkUtils zkUtils$2;
                private final BooleanRef changed$1;

                public final void apply(int brokerId) {
                    this.apply$mcVI$sp(brokerId);
                }

                public void apply$mcVI$sp(int brokerId) {
                    Properties configs = AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$2, ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString());
                    if (configs.remove(DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp()) != null | configs.remove(DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp()) != null) {
                        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils$2, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId}))), configs);
                        this.changed$1.elem = true;
                    }
                }
                {
                    this.zkUtils$2 = zkUtils$2;
                    this.changed$1 = changed$1;
                }
            });
            Seq topics = (Seq)((SetLike)partitionsToBeReassigned.keySet().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(TopicAndPartition tp) {
                    return tp.topic();
                }
            }, Set$.MODULE$.canBuildFrom())).toSeq().distinct();
            topics.foreach((Function1)new Serializable(zkUtils, changed){
                public static final long serialVersionUID = 0L;
                private final ZkUtils zkUtils$2;
                private final BooleanRef changed$1;

                public final void apply(String topic) {
                    Properties configs = AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$2, ConfigType$.MODULE$.Topic(), topic);
                    if (configs.remove(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()) != null | configs.remove(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()) != null) {
                        AdminUtils$.MODULE$.changeTopicConfig(this.zkUtils$2, topic, configs);
                        this.changed$1.elem = true;
                    }
                }
                {
                    this.zkUtils$2 = zkUtils$2;
                    this.changed$1 = changed$1;
                }
            });
            if (changed.elem) {
                Predef$.MODULE$.println((Object)"Throttle was removed.");
            }
        }
    }

    public void generateAssignment(ZkUtils zkUtils, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String topicsToMoveJsonFile = (String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt());
        int[] brokerListToReassign = (int[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)opts.options().valueOf(opts.brokerListOpt()))).split(',')).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Iterable duplicateReassignments = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerListToReassign));
        if (duplicateReassignments.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Broker list contains duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignments.mkString(",")})));
        }
        String topicsToMoveJsonString = Utils.readFileAsString((String)topicsToMoveJsonFile);
        boolean disableRackAware = opts.options().has((OptionSpec)opts.disableRackAware());
        Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> tuple2 = this.generateAssignment(zkUtils, (Seq<Object>)Predef$.MODULE$.wrapIntArray(brokerListToReassign), topicsToMoveJsonString, disableRackAware);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Map proposedAssignments = (Map)tuple2._1();
            Map currentAssignments = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)proposedAssignments, (Object)currentAssignments);
            Map proposedAssignments2 = (Map)tuple23._1();
            Map currentAssignments2 = (Map)tuple23._2();
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.formatAsReassignmentJson((Map<TopicAndPartition, Seq<Object>>)currentAssignments2)})));
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.formatAsReassignmentJson((Map<TopicAndPartition, Seq<Object>>)proposedAssignments2)})));
            return;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> generateAssignment(ZkUtils zkUtils, Seq<Object> brokerListToReassign, String topicsToMoveJsonString, boolean disableRackAware) {
        Seq<String> topicsToReassign = ZkUtils$.MODULE$.parseTopicsData(topicsToMoveJsonString);
        Iterable<String> duplicateTopicsToReassign = CoreUtils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("List of topics to reassign contains duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateTopicsToReassign.mkString(",")})));
        }
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentAssignment = zkUtils.getReplicaAssignmentForTopics(topicsToReassign);
        scala.collection.immutable.Map groupedByTopic = currentAssignment.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> x0$3) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    String string = tp.topic();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        });
        Product rackAwareMode = disableRackAware ? RackAwareMode$Disabled$.MODULE$ : RackAwareMode$Enforced$.MODULE$;
        Seq<BrokerMetadata> brokerMetadatas = AdminUtils$.MODULE$.getBrokerMetadatas(zkUtils, (RackAwareMode)rackAwareMode, (Option<Seq<Object>>)new Some(brokerListToReassign));
        scala.collection.mutable.Map partitionsToBeReassigned = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        groupedByTopic.foreach((Function1)new Serializable(brokerMetadatas, partitionsToBeReassigned){
            public static final long serialVersionUID = 0L;
            private final Seq brokerMetadatas$1;
            private final scala.collection.mutable.Map partitionsToBeReassigned$2;

            public final scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> apply(Tuple2<String, scala.collection.mutable.Map<TopicAndPartition, Seq<Object>>> x0$4) {
                Tuple2<String, scala.collection.mutable.Map<TopicAndPartition, Seq<Object>>> tuple2 = x0$4;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    scala.collection.mutable.Map assignment = (scala.collection.mutable.Map)tuple2._2();
                    Tuple2 tuple22 = (Tuple2)assignment.head();
                    if (tuple22 != null) {
                        Seq replicas;
                        Seq seq;
                        Seq replicas2 = seq = (replicas = (Seq)tuple22._2());
                        Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)this.brokerMetadatas$1, assignment.size(), replicas2.size(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                        scala.collection.mutable.Map map = (scala.collection.mutable.Map)this.partitionsToBeReassigned$2.$plus$plus$eq((TraversableOnce)assignedReplicas.map((Function1)new Serializable(this, topic){
                            public static final long serialVersionUID = 0L;
                            private final String topic$1;

                            public final Tuple2<TopicAndPartition, Seq<Object>> apply(Tuple2<Object, Seq<Object>> x0$5) {
                                Tuple2<Object, Seq<Object>> tuple2 = x0$5;
                                if (tuple2 != null) {
                                    int partition = tuple2._1$mcI$sp();
                                    Seq replicas = (Seq)tuple2._2();
                                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(this.topic$1, partition)), (Object)replicas);
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.topic$1 = topic$1;
                            }
                        }, scala.collection.Map$.MODULE$.canBuildFrom()));
                        return map;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                this.brokerMetadatas$1 = brokerMetadatas$1;
                this.partitionsToBeReassigned$2 = partitionsToBeReassigned$2;
            }
        });
        return new Tuple2((Object)partitionsToBeReassigned, currentAssignment);
    }

    public void executeAssignment(ZkUtils zkUtils, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String reassignmentJsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String reassignmentJsonString = Utils.readFileAsString((String)reassignmentJsonFile);
        long throttle = opts.options().has(opts.throttleOpt()) ? BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.throttleOpt())) : -1L;
        this.executeAssignment(zkUtils, reassignmentJsonString, throttle);
    }

    public void executeAssignment(ZkUtils zkUtils, String reassignmentJsonString, long throttle) {
        Seq<Tuple2<TopicAndPartition, Seq<Object>>> partitionsToBeReassigned = this.parseAndValidate(zkUtils, reassignmentJsonString);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkUtils, (Map<TopicAndPartition, Seq<Object>>)partitionsToBeReassigned.toMap(Predef$.MODULE$.conforms()));
        if (zkUtils.pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath())) {
            Predef$.MODULE$.println((Object)"There is an existing assignment running.");
            reassignPartitionsCommand.maybeLimit(throttle);
        } else {
            this.printCurrentAssignment(zkUtils, partitionsToBeReassigned);
            if (throttle >= 0L) {
                Predef$.MODULE$.println((Object)String.format("Warning: You must run Verify periodically, until the reassignment completes, to ensure the throttle is removed. You can also alter the throttle by rerunning the Execute command passing a new value.", new Object[0]));
            }
            if (reassignPartitionsCommand.reassignPartitions(throttle)) {
                Predef$.MODULE$.println((Object)"Successfully started reassignment of partitions.");
            } else {
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Failed to reassign partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsToBeReassigned})));
            }
        }
    }

    public long executeAssignment$default$3() {
        return -1L;
    }

    public void printCurrentAssignment(ZkUtils zkUtils, Seq<Tuple2<TopicAndPartition, Seq<Object>>> partitionsToBeReassigned) {
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentPartitionReplicaAssignment = zkUtils.getReplicaAssignmentForTopics((Seq<String>)((Seq)partitionsToBeReassigned.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> x$4) {
                return ((TopicAndPartition)x$4._1()).topic();
            }
        }, Seq$.MODULE$.canBuildFrom())));
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s\n\nSave this to use as the --reassignment-json-file option during rollback")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.formatAsReassignmentJson((Map<TopicAndPartition, Seq<Object>>)currentPartitionReplicaAssignment)})));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Tuple2<TopicAndPartition, Seq<Object>>> parseAndValidate(ZkUtils zkUtils, String reassignmentJsonString) {
        void var3_3;
        Seq<Tuple2<TopicAndPartition, Seq<Object>>> partitionsToBeReassigned = ZkUtils$.MODULE$.parsePartitionReassignmentDataWithoutDedup(reassignmentJsonString);
        if (partitionsToBeReassigned.isEmpty()) {
            throw new AdminCommandFailedException("Partition reassignment data file is empty");
        }
        Iterable duplicateReassignedPartitions = CoreUtils$.MODULE$.duplicates((Traversable)partitionsToBeReassigned.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopicAndPartition apply(Tuple2<TopicAndPartition, Seq<Object>> x0$6) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$6;
                if (tuple2 != null) {
                    TopicAndPartition tp;
                    TopicAndPartition topicAndPartition = tp = (TopicAndPartition)tuple2._1();
                    return topicAndPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicateReassignedPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition reassignment contains duplicate topic partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignedPartitions.mkString(",")})));
        }
        Seq duplicateEntries = (Seq)((TraversableLike)partitionsToBeReassigned.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicAndPartition, Iterable<Object>> apply(Tuple2<TopicAndPartition, Seq<Object>> x0$7) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$7;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)tp, CoreUtils$.MODULE$.duplicates(replicas));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Iterable<Object>> x0$8) {
                Tuple2<TopicAndPartition, Iterable<Object>> tuple2 = x0$8;
                if (tuple2 != null) {
                    Iterable duplicatedReplicas = (Iterable)tuple2._2();
                    boolean bl = duplicatedReplicas.nonEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        if (duplicateEntries.nonEmpty()) {
            String duplicatesMsg = ((TraversableOnce)duplicateEntries.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<TopicAndPartition, Iterable<Object>> x0$9) {
                    Tuple2<TopicAndPartition, Iterable<Object>> tuple2 = x0$9;
                    if (tuple2 != null) {
                        TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                        Iterable duplicateReplicas = (Iterable)tuple2._2();
                        String string = new StringOps(Predef$.MODULE$.augmentString("%s contains multiple entries for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, duplicateReplicas.mkString(",")}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(". ");
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition replica lists may not contain duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatesMsg})));
        }
        Seq proposedTopics = (Seq)((SeqLike)partitionsToBeReassigned.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> x0$10) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$10;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    String string = tp.topic();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> existingAssignment = zkUtils.getReplicaAssignmentForTopics((Seq<String>)proposedTopics);
        Seq nonExistentPartitions = (Seq)((TraversableLike)partitionsToBeReassigned.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopicAndPartition apply(Tuple2<TopicAndPartition, Seq<Object>> x0$11) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$11;
                if (tuple2 != null) {
                    TopicAndPartition tp;
                    TopicAndPartition topicAndPartition = tp = (TopicAndPartition)tuple2._1();
                    return topicAndPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(existingAssignment){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map existingAssignment$1;

            public final boolean apply(TopicAndPartition key) {
                return this.existingAssignment$1.contains((Object)key);
            }
            {
                this.existingAssignment$1 = existingAssignment$1;
            }
        });
        if (nonExistentPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder().append((Object)"The proposed assignment contains non-existent partitions: ").append((Object)nonExistentPartitions).toString());
        }
        return var3_3;
    }

    private Map<TopicAndPartition, ReassignmentStatus> checkIfReassignmentSucceeded(ZkUtils zkUtils, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        Map partitionsBeingReassigned = zkUtils.getPartitionsBeingReassigned().mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReassignedPartitionsContext x$5) {
                return x$5.newReplicas();
            }
        });
        return ((TraversableOnce)partitionsToBeReassigned.keys().map((Function1)new Serializable(zkUtils, partitionsToBeReassigned, partitionsBeingReassigned){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;
            private final Map partitionsToBeReassigned$1;
            private final Map partitionsBeingReassigned$1;

            public final Tuple2<TopicAndPartition, ReassignmentStatus> apply(TopicAndPartition topicAndPartition) {
                return new Tuple2((Object)topicAndPartition, (Object)ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkUtils$1, topicAndPartition, (Map<TopicAndPartition, Seq<Object>>)this.partitionsToBeReassigned$1, (Map<TopicAndPartition, Seq<Object>>)this.partitionsBeingReassigned$1));
            }
            {
                this.zkUtils$1 = zkUtils$1;
                this.partitionsToBeReassigned$1 = partitionsToBeReassigned$1;
                this.partitionsBeingReassigned$1 = partitionsBeingReassigned$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public ReassignmentStatus checkIfPartitionReassignmentSucceeded(ZkUtils zkUtils, TopicAndPartition topicAndPartition, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicAndPartition, Seq<Object>> partitionsBeingReassigned) {
        Option option;
        block7: {
            Product product;
            block6: {
                Product product2;
                Seq<Object> assignedReplicas;
                Seq newReplicas;
                block5: {
                    newReplicas = (Seq)partitionsToBeReassigned.apply((Object)topicAndPartition);
                    option = partitionsBeingReassigned.get((Object)topicAndPartition);
                    if (!(option instanceof Some)) break block5;
                    product = ReassignmentInProgress$.MODULE$;
                    break block6;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                Seq<Object> seq = assignedReplicas = zkUtils.getReplicasForPartition(topicAndPartition.topic(), topicAndPartition.partition());
                Seq seq2 = newReplicas;
                if (!(seq != null ? !seq.equals((Object)seq2) : seq2 != null)) {
                    product2 = ReassignmentCompleted$.MODULE$;
                } else {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("ERROR: Assigned replicas (%s) don't match the list of replicas for reassignment (%s) for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assignedReplicas.mkString(","), newReplicas.mkString(","), topicAndPartition})));
                    product2 = ReassignmentFailed$.MODULE$;
                }
                product = product2;
            }
            return product;
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReassignPartitionsCommand.ReassignPartitionsCommandOptions validateAndParseArgs(String[] args) {
        void var2_2;
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "This command moves topic partitions between replicas.");
        }
        int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.generateOpt(), opts.executeOpt(), opts.verifyOpt()}))).count((Function1)new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1;

            public final boolean apply(OptionSpec<?> x$1) {
                return this.opts$1.options().has(x$1);
            }
            {
                this.opts$1 = opts$1;
            }
        });
        if (actions != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --generate, --execute or --verify");
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.zkConnectOpt()}));
        if (opts.options().has((OptionSpec)opts.verifyOpt())) {
            if (!opts.options().has(opts.reassignmentJsonFileOpt())) throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --verify option is used, command must include --reassignment-json-file that was used during the --execute option");
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.verifyOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.throttleOpt(), opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()}))));
            return var2_2;
        } else if (opts.options().has((OptionSpec)opts.generateOpt())) {
            if (!opts.options().has(opts.topicsToMoveJsonFileOpt()) || !opts.options().has(opts.brokerListOpt())) throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options");
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.generateOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.throttleOpt(), opts.reassignmentJsonFileOpt()}))));
            return var2_2;
        } else {
            if (!opts.options().has((OptionSpec)opts.executeOpt())) return var2_2;
            if (!opts.options().has(opts.reassignmentJsonFileOpt())) throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --execute option is used, command must include --reassignment-json-file that was output during the --generate option");
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.executeOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()}))));
        }
        return var2_2;
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

