/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.syslogd.GrokParserStageSequenceBuilder;
import org.opennms.netmgt.syslogd.ParserStage;
import org.opennms.netmgt.syslogd.RadixTreeParser;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadixTreeSyslogParser
extends SyslogParser {
    private static final Logger LOG;
    private static final Pattern STRUCTURED_DATA;
    private static RadixTreeParser radixParser;

    private static final void teachDefaultPatterns() {
        new BufferedReader(new InputStreamReader(RadixTreeSyslogParser.class.getClassLoader().getResourceAsStream("org/opennms/netmgt/syslogd/grok-patterns.txt"))).lines().forEach(pattern -> {
            if (pattern == null || pattern.trim().length() == 0 || pattern.trim().startsWith("#")) {
                return;
            }
            radixParser.teach(GrokParserStageSequenceBuilder.parseGrok(pattern).toArray(new ParserStage[0]));
        });
    }

    public RadixTreeSyslogParser(SyslogdConfig config, ByteBuffer syslogString) {
        super(config, syslogString);
    }

    @Override
    public boolean find() {
        return true;
    }

    @Override
    public SyslogMessage parse() {
        Matcher matcher;
        String message;
        SyslogMessage retval = radixParser.parse(this.getText()).join();
        if (retval != null && (message = retval.getMessage()) != null && message.startsWith("[") && (matcher = STRUCTURED_DATA.matcher(message)).find()) {
            String newMessage = matcher.group(1);
            retval.setMessage(newMessage == null ? null : newMessage);
        }
        return retval;
    }

    static {
        block18: {
            LOG = LoggerFactory.getLogger(RadixTreeSyslogParser.class);
            STRUCTURED_DATA = Pattern.compile("^(?:\\[.*?\\])*(?: \ufeff?(.*?))?$");
            radixParser = new RadixTreeParser();
            try {
                File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SYSLOGD_GROK_PATTERNS_FILE_NAME);
                if (configFile.exists() && configFile.isFile()) {
                    try (FileReader reader = new FileReader(configFile);){
                        new BufferedReader(reader).lines().forEach(pattern -> {
                            if (pattern == null || pattern.trim().length() == 0 || pattern.trim().startsWith("#")) {
                                return;
                            }
                            radixParser.teach(GrokParserStageSequenceBuilder.parseGrok(pattern).toArray(new ParserStage[0]));
                        });
                    }
                    if (radixParser.size() == 0) {
                        LOG.warn("{} has no grok patterns, check the content of {}, using default grok pattern set", (Object)RadixTreeSyslogParser.class.getSimpleName(), (Object)ConfigFileConstants.getFileName((int)ConfigFileConstants.SYSLOGD_GROK_PATTERNS_FILE_NAME));
                        RadixTreeSyslogParser.teachDefaultPatterns();
                    }
                    break block18;
                }
                RadixTreeSyslogParser.teachDefaultPatterns();
            }
            catch (FileNotFoundException e) {
                RadixTreeSyslogParser.teachDefaultPatterns();
            }
            catch (IOException e) {
                LOG.warn("Unexpeceted exception while reading {}, using default grok pattern set", (Object)ConfigFileConstants.getFileName((int)ConfigFileConstants.SYSLOGD_GROK_PATTERNS_FILE_NAME), (Object)e);
                RadixTreeSyslogParser.teachDefaultPatterns();
            }
        }
        radixParser.performEdgeCompression();
    }
}

