/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.dao.api.BridgeBridgeLinkDao;
import org.opennms.netmgt.dao.api.BridgeMacLinkDao;
import org.opennms.netmgt.dao.api.BridgeTopologyDao;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.SharedSegment;

public class BridgeTopologyDaoInMemory
implements BridgeTopologyDao {
    volatile Set<BroadcastDomain> m_domains = new HashSet<BroadcastDomain>();

    public synchronized void save(BroadcastDomain domain) {
        this.m_domains.add(domain);
    }

    public synchronized void load(BridgeBridgeLinkDao bridgeBridgeLinkDao, BridgeMacLinkDao bridgeMacLinkDao) {
        this.m_domains = this.getAllPersisted(bridgeBridgeLinkDao, bridgeMacLinkDao);
    }

    public List<SharedSegment> getBridgeNodeSharedSegments(BridgeBridgeLinkDao bridgeBridgeLinkDao, BridgeMacLinkDao bridgeMacLinkDao, int nodeid) {
        Object segment;
        ArrayList<SharedSegment> segments = new ArrayList<SharedSegment>();
        HashSet<Integer> designated = new HashSet<Integer>();
        block0: for (BridgeBridgeLink link : bridgeBridgeLinkDao.findByNodeId(Integer.valueOf(nodeid))) {
            for (SharedSegment segment2 : segments) {
                if (!segment2.containsPort(link.getNode().getId(), link.getBridgePort()) && !segment2.containsPort(link.getDesignatedNode().getId(), link.getDesignatedPort())) continue;
                segment2.add(link);
                designated.add(link.getDesignatedNode().getId());
                continue block0;
            }
            segment = new SharedSegment();
            segment.add(link);
            segment.setDesignatedBridge(link.getDesignatedNode().getId());
            segments.add((SharedSegment)segment);
        }
        designated.add(nodeid);
        for (Integer curNodeId : designated) {
            block3: for (BridgeBridgeLink link : bridgeBridgeLinkDao.findByDesignatedNodeId(curNodeId)) {
                for (SharedSegment segment3 : segments) {
                    if (!segment3.containsPort(link.getNode().getId(), link.getBridgePort()) && !segment3.containsPort(link.getDesignatedNode().getId(), link.getDesignatedPort())) continue;
                    segment3.add(link);
                    continue block3;
                }
                SharedSegment segment4 = new SharedSegment();
                segment4.add(link);
                segment4.setDesignatedBridge(link.getDesignatedNode().getId());
                segments.add(segment4);
            }
        }
        block5: for (BridgeBridgeLink link : bridgeMacLinkDao.findByNodeId(Integer.valueOf(nodeid))) {
            link.setBridgeDot1qTpFdbStatus(BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
            for (SharedSegment segment2 : segments) {
                if (!segment2.containsMac(link.getMacAddress()) && !segment2.containsPort(link.getNode().getId(), link.getBridgePort())) continue;
                segment2.add((BridgeMacLink)link);
                continue block5;
            }
            segment = new SharedSegment();
            segment.add((BridgeMacLink)link);
            segment.setDesignatedBridge(link.getNode().getId());
            segments.add((SharedSegment)segment);
        }
        return segments;
    }

    public SharedSegment getHostNodeSharedSegment(BridgeBridgeLinkDao bridgeBridgeLinkDao, BridgeMacLinkDao bridgeMacLinkDao, String mac) {
        List links = bridgeMacLinkDao.findByMacAddress(mac);
        if (links.size() == 0) {
            return new SharedSegment();
        }
        BridgeMacLink link = (BridgeMacLink)links.get(0);
        for (SharedSegment segment : this.getBridgeNodeSharedSegments(bridgeBridgeLinkDao, bridgeMacLinkDao, link.getNode().getId())) {
            if (!segment.containsPort(link.getNode().getId(), link.getBridgePort())) continue;
            return segment;
        }
        return new SharedSegment();
    }

    public Set<BroadcastDomain> getAllPersisted(BridgeBridgeLinkDao bridgeBridgeLinkDao, BridgeMacLinkDao bridgeMacLinkDao) {
        BroadcastDomain domain;
        ArrayList<SharedSegment> segments = new ArrayList<SharedSegment>();
        block0: for (Object link : bridgeBridgeLinkDao.findAll()) {
            for (SharedSegment sharedSegment : segments) {
                if (!sharedSegment.containsPort(link.getNode().getId(), link.getBridgePort()) && !sharedSegment.containsPort(link.getDesignatedNode().getId(), link.getDesignatedPort())) continue;
                sharedSegment.add((BridgeBridgeLink)link);
                continue block0;
            }
            SharedSegment sharedSegment = new SharedSegment();
            sharedSegment.add((BridgeBridgeLink)link);
            sharedSegment.setDesignatedBridge(link.getDesignatedNode().getId());
            segments.add(sharedSegment);
        }
        block2: for (Object link : bridgeMacLinkDao.findAll()) {
            link.setBridgeDot1qTpFdbStatus(BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
            for (SharedSegment sharedSegment : segments) {
                if (!sharedSegment.containsMac(link.getMacAddress()) && !sharedSegment.containsPort(link.getNode().getId(), link.getBridgePort())) continue;
                sharedSegment.add((BridgeMacLink)link);
                continue block2;
            }
            SharedSegment sharedSegment = new SharedSegment();
            sharedSegment.add((BridgeMacLink)link);
            sharedSegment.setDesignatedBridge(link.getNode().getId());
            segments.add(sharedSegment);
        }
        HashSet<Set<Integer>> nodelinked = new HashSet<Set<Integer>>();
        block4: for (SharedSegment sharedSegment : segments) {
            HashSet<Integer> hashSet = new HashSet<Integer>(sharedSegment.getBridgeIdsOnSegment());
            for (Set set : nodelinked) {
                for (Integer nodeid : hashSet) {
                    if (!set.contains(nodeid)) continue;
                    continue block4;
                }
            }
            nodelinked.add(this.getNodesOnDomainSet(segments, sharedSegment, new HashSet<SharedSegment>(), hashSet));
        }
        HashSet<BroadcastDomain> domains = new HashSet<BroadcastDomain>();
        for (Set set : nodelinked) {
            domain = new BroadcastDomain();
            for (Integer nodeid : set) {
                domain.addBridge(new Bridge(nodeid));
            }
            domains.add(domain);
        }
        for (SharedSegment sharedSegment : segments) {
            domain = null;
            for (BroadcastDomain cdomain : domains) {
                if (!cdomain.containsAtleastOne(sharedSegment.getBridgeIdsOnSegment())) continue;
                domain = cdomain;
                break;
            }
            if (domain == null) {
                domain = new BroadcastDomain();
                domains.add(domain);
            }
            domain.loadTopologyEntry(sharedSegment);
        }
        return domains;
    }

    private Set<Integer> getNodesOnDomainSet(List<SharedSegment> segments, SharedSegment segment, Set<SharedSegment> parsed, Set<Integer> nodesOnDomain) {
        parsed.add(segment);
        block0: for (SharedSegment parsing : segments) {
            if (parsed.contains(parsing)) continue;
            Set nodesOnSegment = parsing.getBridgeIdsOnSegment();
            for (Integer nodeid : nodesOnSegment) {
                if (!nodesOnDomain.contains(nodeid)) continue;
                nodesOnDomain.addAll(nodesOnSegment);
                this.getNodesOnDomainSet(segments, parsing, parsed, nodesOnDomain);
                break block0;
            }
        }
        return nodesOnDomain;
    }

    public synchronized void delete(BroadcastDomain domain) {
        this.m_domains.remove(domain);
    }

    public synchronized BroadcastDomain get(int nodeid) {
        for (BroadcastDomain domain : this.m_domains) {
            if (!domain.containBridgeId(nodeid)) continue;
            return domain;
        }
        return null;
    }

    public synchronized Set<BroadcastDomain> getAll() {
        return this.m_domains;
    }

    public synchronized void clean() {
        HashSet<BroadcastDomain> empties = new HashSet<BroadcastDomain>();
        for (BroadcastDomain domain : this.m_domains) {
            if (!domain.isEmpty()) continue;
            empties.add(domain);
        }
        this.m_domains.removeAll(empties);
    }
}

