/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.kafka;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.common.AbstractMessageConsumerManager;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.SystemInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class KafkaMessageConsumerManager
extends AbstractMessageConsumerManager
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaMessageConsumerManager.class);
    private final Map<SinkModule<?, Message>, List<KafkaConsumerRunner>> consumerRunnersByModule = new ConcurrentHashMap();
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("kafka-consumer-%d").build();
    private final ExecutorService executor = Executors.newCachedThreadPool(this.threadFactory);
    private final Properties kafkaConfig = new Properties();

    public void startConsumingForModule(SinkModule<?, Message> module) throws Exception {
        if (!this.consumerRunnersByModule.containsKey(module)) {
            LOG.info("Starting consumers for module: {}", module);
            int numConsumerThreads = KafkaMessageConsumerManager.getNumConsumerThreads(module);
            ArrayList<KafkaConsumerRunner> consumerRunners = new ArrayList<KafkaConsumerRunner>(numConsumerThreads);
            for (int i = 0; i < numConsumerThreads; ++i) {
                KafkaConsumerRunner consumerRunner = new KafkaConsumerRunner(module);
                this.executor.execute(consumerRunner);
                consumerRunners.add(new KafkaConsumerRunner(module));
            }
            this.consumerRunnersByModule.put(module, consumerRunners);
        }
    }

    public void stopConsumingForModule(SinkModule<?, Message> module) throws Exception {
        if (this.consumerRunnersByModule.containsKey(module)) {
            LOG.info("Stopping consumers for module: {}", module);
            List<KafkaConsumerRunner> consumerRunners = this.consumerRunnersByModule.get(module);
            for (KafkaConsumerRunner consumerRunner : consumerRunners) {
                consumerRunner.shutdown();
            }
            this.consumerRunnersByModule.remove(module);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.kafkaConfig.clear();
        this.kafkaConfig.put("group.id", SystemInfoUtils.getInstanceId());
        this.kafkaConfig.put("enable.auto.commit", "true");
        this.kafkaConfig.put("key.deserializer", StringDeserializer.class.getCanonicalName());
        this.kafkaConfig.put("value.deserializer", StringDeserializer.class.getCanonicalName());
        this.kafkaConfig.put("auto.commit.interval.ms", "1000");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key;
            Object keyAsObject = entry.getKey();
            if (keyAsObject == null || !(keyAsObject instanceof String) || (key = (String)keyAsObject).length() <= "org.opennms.core.ipc.sink.kafka.".length() || !key.startsWith("org.opennms.core.ipc.sink.kafka.")) continue;
            String kafkaConfigKey = key.substring("org.opennms.core.ipc.sink.kafka.".length());
            this.kafkaConfig.put(kafkaConfigKey, entry.getValue());
        }
        LOG.info("KafkaMessageConsumerManager: consuming from Kafka using: {}", (Object)this.kafkaConfig);
    }

    private class KafkaConsumerRunner
    implements Runnable {
        private final SinkModule<?, Message> module;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final KafkaConsumer<String, String> consumer;
        private final String topic;

        public KafkaConsumerRunner(SinkModule<?, Message> module) {
            this.module = module;
            JmsQueueNameFactory topicNameFactory = new JmsQueueNameFactory("Sink", module.getId());
            this.topic = topicNameFactory.getName();
            this.consumer = new KafkaConsumer(KafkaMessageConsumerManager.this.kafkaConfig);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logging.putPrefix((String)"ipc");
            try {
                this.consumer.subscribe(Arrays.asList(this.topic));
                while (!this.closed.get()) {
                    ConsumerRecords records = this.consumer.poll(100L);
                    for (ConsumerRecord record : records) {
                        try {
                            KafkaMessageConsumerManager.this.dispatch(this.module, this.module.unmarshal((String)record.value()));
                        }
                        catch (RuntimeException e) {
                            LOG.warn("Unexpected exception while dispatching message", (Throwable)e);
                        }
                    }
                }
            }
            catch (WakeupException e) {
                if (!this.closed.get()) {
                    throw e;
                }
            }
            finally {
                this.consumer.close();
            }
        }

        public void shutdown() {
            this.closed.set(true);
            this.consumer.wakeup();
        }
    }
}

