/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.processor.binding.RestBindingProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.IntrospectionSupport;

@XmlRootElement(name="restBinding")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestBindingDefinition
extends NoOutputDefinition<RestBindingDefinition> {
    @XmlAttribute
    private String consumes;
    @XmlAttribute
    private String produces;
    @XmlAttribute
    private RestBindingMode bindingMode;
    @XmlAttribute
    private String type;
    @XmlAttribute
    private String outType;
    @XmlAttribute
    private Boolean skipBindingOnErrorCode;
    @XmlAttribute
    private Boolean enableCORS;

    public String toString() {
        return "RestBinding";
    }

    @Override
    public String getShortName() {
        return "restBinding";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        CamelContext context = routeContext.getCamelContext();
        String mode = context.getRestConfiguration().getBindingMode().name();
        if (this.bindingMode != null) {
            mode = this.bindingMode.name();
        }
        boolean cors = context.getRestConfiguration().isEnableCORS();
        if (this.enableCORS != null) {
            cors = this.enableCORS;
        }
        boolean skip = context.getRestConfiguration().isSkipBindingOnErrorCode();
        if (this.skipBindingOnErrorCode != null) {
            skip = this.skipBindingOnErrorCode;
        }
        Map<String, String> corsHeaders = context.getRestConfiguration().getCorsHeaders();
        if (mode == null || "off".equals(mode)) {
            return new RestBindingProcessor(null, null, null, null, this.consumes, this.produces, mode, skip, cors, corsHeaders);
        }
        String name = context.getRestConfiguration().getJsonDataFormat();
        if (name != null) {
            Object instance = context.getRegistry().lookupByName(name);
            if (instance != null) {
                throw new IllegalArgumentException("JsonDataFormat name: " + name + " must not be an existing bean instance from the registry");
            }
        } else {
            name = "json-jackson";
        }
        DataFormat json = context.resolveDataFormat(name);
        DataFormat outJson = context.resolveDataFormat(name);
        if (mode.contains("json") && json == null) {
            throw new IllegalArgumentException("JSon DataFormat " + name + " not found.");
        }
        if (json != null) {
            Class<?> clazz = null;
            if (this.type != null) {
                String typeName = this.type.endsWith("[]") ? this.type.substring(0, this.type.length() - 2) : this.type;
                clazz = context.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (clazz != null) {
                IntrospectionSupport.setProperty(context.getTypeConverter(), json, "unmarshalType", clazz);
                IntrospectionSupport.setProperty(context.getTypeConverter(), json, "useList", (Object)this.type.endsWith("[]"));
            }
            this.setAdditionalConfiguration(context, json, "json.in.");
            context.addService(json);
            Class<?> outClazz = null;
            if (this.outType != null) {
                String typeName = this.outType.endsWith("[]") ? this.outType.substring(0, this.outType.length() - 2) : this.outType;
                outClazz = context.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (outClazz != null) {
                IntrospectionSupport.setProperty(context.getTypeConverter(), outJson, "unmarshalType", outClazz);
                IntrospectionSupport.setProperty(context.getTypeConverter(), outJson, "useList", (Object)this.outType.endsWith("[]"));
            }
            this.setAdditionalConfiguration(context, outJson, "json.out.");
            context.addService(outJson);
        }
        if ((name = context.getRestConfiguration().getXmlDataFormat()) != null) {
            Object instance = context.getRegistry().lookupByName(name);
            if (instance != null) {
                throw new IllegalArgumentException("XmlDataFormat name: " + name + " must not be an existing bean instance from the registry");
            }
        } else {
            name = "jaxb";
        }
        DataFormat jaxb = context.resolveDataFormat(name);
        DataFormat outJaxb = context.resolveDataFormat(name);
        if (mode.contains("xml") && jaxb == null) {
            throw new IllegalArgumentException("XML DataFormat " + name + " not found.");
        }
        if (jaxb != null) {
            JAXBContext jc;
            Class<?> clazz = null;
            if (this.type != null) {
                String typeName = this.type.endsWith("[]") ? this.type.substring(0, this.type.length() - 2) : this.type;
                clazz = context.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (clazz != null) {
                JAXBContext jc2 = JAXBContext.newInstance((Class[])new Class[]{clazz});
                IntrospectionSupport.setProperty(context.getTypeConverter(), jaxb, "context", jc2);
            }
            this.setAdditionalConfiguration(context, jaxb, "xml.in.");
            context.addService(jaxb);
            Class<?> outClazz = null;
            if (this.outType != null) {
                String typeName = this.outType.endsWith("[]") ? this.outType.substring(0, this.outType.length() - 2) : this.outType;
                outClazz = context.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (outClazz != null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{outClazz});
                IntrospectionSupport.setProperty(context.getTypeConverter(), outJaxb, "context", jc);
            } else if (clazz != null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
                IntrospectionSupport.setProperty(context.getTypeConverter(), outJaxb, "context", jc);
            }
            this.setAdditionalConfiguration(context, outJaxb, "xml.out.");
            context.addService(outJaxb);
        }
        return new RestBindingProcessor(json, jaxb, outJson, outJaxb, this.consumes, this.produces, mode, skip, cors, corsHeaders);
    }

    private void setAdditionalConfiguration(CamelContext context, DataFormat dataFormat, String prefix) throws Exception {
        if (context.getRestConfiguration().getDataFormatProperties() != null && !context.getRestConfiguration().getDataFormatProperties().isEmpty()) {
            HashMap<String, Object> copy = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : context.getRestConfiguration().getDataFormatProperties().entrySet()) {
                String key = entry.getKey();
                boolean known = this.isKeyKnownPrefix(key);
                String copyKey = known ? key.substring(prefix.length()) : key;
                if (known && !key.startsWith(prefix)) continue;
                copy.put(copyKey, entry.getValue());
            }
            IntrospectionSupport.setProperties(context.getTypeConverter(), dataFormat, copy);
        }
    }

    private boolean isKeyKnownPrefix(String key) {
        return key.startsWith("json.in.") || key.startsWith("json.out.") || key.startsWith("xml.in.") || key.startsWith("xml.out.");
    }

    public String getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public RestBindingMode getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(RestBindingMode bindingMode) {
        this.bindingMode = bindingMode;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOutType() {
        return this.outType;
    }

    public void setOutType(String outType) {
        this.outType = outType;
    }

    public Boolean getSkipBindingOnErrorCode() {
        return this.skipBindingOnErrorCode;
    }

    public void setSkipBindingOnErrorCode(Boolean skipBindingOnErrorCode) {
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
    }

    public Boolean getEnableCORS() {
        return this.enableCORS;
    }

    public void setEnableCORS(Boolean enableCORS) {
        this.enableCORS = enableCORS;
    }
}

