/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.wmi.agent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.wmi.agent.Definition;

@XmlRootElement(name="wmi-config")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WmiConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="timeout")
    private Integer timeout;
    @XmlAttribute(name="retry")
    private Integer retry;
    @XmlAttribute(name="username")
    private String username;
    @XmlAttribute(name="domain")
    private String domain;
    @XmlAttribute(name="password")
    private String password;
    @XmlElement(name="definition")
    private List<Definition> definitionList = new ArrayList<Definition>();

    public void addDefinition(Definition vDefinition) throws IndexOutOfBoundsException {
        this.definitionList.add(vDefinition);
    }

    public void addDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        this.definitionList.add(index, vDefinition);
    }

    public void deleteRetry() {
        this.retry = null;
    }

    public void deleteTimeout() {
        this.timeout = null;
    }

    public Enumeration<Definition> enumerateDefinition() {
        return Collections.enumeration(this.definitionList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof WmiConfig) {
            WmiConfig temp = (WmiConfig)obj;
            boolean equals = Objects.equals(temp.timeout, this.timeout) && Objects.equals(temp.retry, this.retry) && Objects.equals(temp.username, this.username) && Objects.equals(temp.domain, this.domain) && Objects.equals(temp.password, this.password) && Objects.equals(temp.definitionList, this.definitionList);
            return equals;
        }
        return false;
    }

    public Definition getDefinition(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.definitionList.size()) {
            throw new IndexOutOfBoundsException("getDefinition: Index value '" + index + "' not in range [0.." + (this.definitionList.size() - 1) + "]");
        }
        return this.definitionList.get(index);
    }

    public Definition[] getDefinition() {
        Definition[] array = new Definition[]{};
        return this.definitionList.toArray(array);
    }

    public List<Definition> getDefinitionCollection() {
        return this.definitionList;
    }

    public int getDefinitionCount() {
        return this.definitionList.size();
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getRetry() {
        return this.retry;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean hasRetry() {
        return this.retry != null;
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.timeout, this.retry, this.username, this.domain, this.password, this.definitionList);
        return hash;
    }

    public Iterator<Definition> iterateDefinition() {
        return this.definitionList.iterator();
    }

    public void removeAllDefinition() {
        this.definitionList.clear();
    }

    public boolean removeDefinition(Definition vDefinition) {
        boolean removed = this.definitionList.remove(vDefinition);
        return removed;
    }

    public Definition removeDefinitionAt(int index) {
        Definition obj = this.definitionList.remove(index);
        return obj;
    }

    public void setDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.definitionList.size()) {
            throw new IndexOutOfBoundsException("setDefinition: Index value '" + index + "' not in range [0.." + (this.definitionList.size() - 1) + "]");
        }
        this.definitionList.set(index, vDefinition);
    }

    public void setDefinition(Definition[] vDefinitionArray) {
        this.definitionList.clear();
        for (int i = 0; i < vDefinitionArray.length; ++i) {
            this.definitionList.add(vDefinitionArray[i]);
        }
    }

    public void setDefinition(List<Definition> vDefinitionList) {
        this.definitionList.clear();
        this.definitionList.addAll(vDefinitionList);
    }

    public void setDefinitionCollection(List<Definition> definitionList) {
        this.definitionList = definitionList;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRetry(Integer retry) {
        this.retry = retry;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

