/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.reportd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.reportd.Parameter;

@XmlRootElement(name="report")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Report
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_REPORT_FORMAT = "pdf";
    private static final String DEFAULT_REPORT_ENGINE = "opennms";
    @XmlAttribute(name="report-template", required=true)
    private String reportTemplate;
    @XmlAttribute(name="report-name", required=true)
    private String reportName;
    @XmlAttribute(name="report-format")
    private String reportFormat;
    @XmlAttribute(name="report-engine")
    private String reportEngine;
    @XmlElement(name="cron-schedule", required=true)
    private String cronSchedule;
    @XmlElement(name="recipient")
    private List<String> recipientList = new ArrayList<String>();
    @XmlElement(name="mailer")
    private String mailer;
    @XmlElement(name="parameter")
    private List<Parameter> parameterList = new ArrayList<Parameter>();

    public void addParameter(Parameter vParameter) throws IndexOutOfBoundsException {
        this.parameterList.add(vParameter);
    }

    public void addParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        this.parameterList.add(index, vParameter);
    }

    public void addRecipient(String vRecipient) throws IndexOutOfBoundsException {
        this.recipientList.add(vRecipient);
    }

    public void addRecipient(int index, String vRecipient) throws IndexOutOfBoundsException {
        this.recipientList.add(index, vRecipient);
    }

    public Enumeration<Parameter> enumerateParameter() {
        return Collections.enumeration(this.parameterList);
    }

    public Enumeration<String> enumerateRecipient() {
        return Collections.enumeration(this.recipientList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Report) {
            Report temp = (Report)obj;
            boolean equals = Objects.equals(temp.reportTemplate, this.reportTemplate) && Objects.equals(temp.reportName, this.reportName) && Objects.equals(temp.reportFormat, this.reportFormat) && Objects.equals(temp.reportEngine, this.reportEngine) && Objects.equals(temp.cronSchedule, this.cronSchedule) && Objects.equals(temp.recipientList, this.recipientList) && Objects.equals(temp.mailer, this.mailer) && Objects.equals(temp.parameterList, this.parameterList);
            return equals;
        }
        return false;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    public String getMailer() {
        return this.mailer;
    }

    public Parameter getParameter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.parameterList.size()) {
            throw new IndexOutOfBoundsException("getParameter: Index value '" + index + "' not in range [0.." + (this.parameterList.size() - 1) + "]");
        }
        return this.parameterList.get(index);
    }

    public Parameter[] getParameter() {
        Parameter[] array = new Parameter[]{};
        return this.parameterList.toArray(array);
    }

    public List<Parameter> getParameterCollection() {
        return this.parameterList;
    }

    public int getParameterCount() {
        return this.parameterList.size();
    }

    public String getRecipient(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.recipientList.size()) {
            throw new IndexOutOfBoundsException("getRecipient: Index value '" + index + "' not in range [0.." + (this.recipientList.size() - 1) + "]");
        }
        return this.recipientList.get(index);
    }

    public String[] getRecipient() {
        String[] array = new String[]{};
        return this.recipientList.toArray(array);
    }

    public List<String> getRecipientCollection() {
        return this.recipientList;
    }

    public int getRecipientCount() {
        return this.recipientList.size();
    }

    public String getReportEngine() {
        return this.reportEngine != null ? this.reportEngine : DEFAULT_REPORT_ENGINE;
    }

    public String getReportFormat() {
        return this.reportFormat != null ? this.reportFormat : DEFAULT_REPORT_FORMAT;
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getReportTemplate() {
        return this.reportTemplate;
    }

    public int hashCode() {
        int hash = Objects.hash(this.reportTemplate, this.reportName, this.reportFormat, this.reportEngine, this.cronSchedule, this.recipientList, this.mailer, this.parameterList);
        return hash;
    }

    public Iterator<Parameter> iterateParameter() {
        return this.parameterList.iterator();
    }

    public Iterator<String> iterateRecipient() {
        return this.recipientList.iterator();
    }

    public void removeAllParameter() {
        this.parameterList.clear();
    }

    public void removeAllRecipient() {
        this.recipientList.clear();
    }

    public boolean removeParameter(Parameter vParameter) {
        boolean removed = this.parameterList.remove(vParameter);
        return removed;
    }

    public Parameter removeParameterAt(int index) {
        Parameter obj = this.parameterList.remove(index);
        return obj;
    }

    public boolean removeRecipient(String vRecipient) {
        boolean removed = this.recipientList.remove(vRecipient);
        return removed;
    }

    public String removeRecipientAt(int index) {
        String obj = this.recipientList.remove(index);
        return obj;
    }

    public void setCronSchedule(String cronSchedule) {
        this.cronSchedule = cronSchedule;
    }

    public void setMailer(String mailer) {
        this.mailer = mailer;
    }

    public void setParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.parameterList.size()) {
            throw new IndexOutOfBoundsException("setParameter: Index value '" + index + "' not in range [0.." + (this.parameterList.size() - 1) + "]");
        }
        this.parameterList.set(index, vParameter);
    }

    public void setParameter(Parameter[] vParameterArray) {
        this.parameterList.clear();
        for (int i = 0; i < vParameterArray.length; ++i) {
            this.parameterList.add(vParameterArray[i]);
        }
    }

    public void setParameter(List<Parameter> vParameterList) {
        this.parameterList.clear();
        this.parameterList.addAll(vParameterList);
    }

    public void setParameterCollection(List<Parameter> parameterList) {
        this.parameterList = parameterList;
    }

    public void setRecipient(int index, String vRecipient) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.recipientList.size()) {
            throw new IndexOutOfBoundsException("setRecipient: Index value '" + index + "' not in range [0.." + (this.recipientList.size() - 1) + "]");
        }
        this.recipientList.set(index, vRecipient);
    }

    public void setRecipient(String[] vRecipientArray) {
        this.recipientList.clear();
        for (int i = 0; i < vRecipientArray.length; ++i) {
            this.recipientList.add(vRecipientArray[i]);
        }
    }

    public void setRecipient(List<String> vRecipientList) {
        this.recipientList.clear();
        this.recipientList.addAll(vRecipientList);
    }

    public void setRecipientCollection(List<String> recipientList) {
        this.recipientList = recipientList;
    }

    public void setReportEngine(String reportEngine) {
        this.reportEngine = reportEngine;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public void setReportTemplate(String reportTemplate) {
        this.reportTemplate = reportTemplate;
    }
}

