/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.rancid.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.rancid.adapter.Mapping;
import org.opennms.netmgt.config.rancid.adapter.Policies;

@XmlRootElement(name="rancid-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RancidConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_DEFAULT_TYPE = "cisco";
    @XmlAttribute(name="delay", required=true)
    private Long delay;
    @XmlAttribute(name="retries", required=true)
    private Integer retries;
    @XmlAttribute(name="useCategories")
    private Boolean useCategories;
    @XmlAttribute(name="default-type")
    private String defaultType;
    @XmlElement(name="policies")
    private Policies policies;
    @XmlElement(name="mapping")
    private List<Mapping> mappingList = new ArrayList<Mapping>();

    public void addMapping(Mapping vMapping) throws IndexOutOfBoundsException {
        this.mappingList.add(vMapping);
    }

    public void addMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        this.mappingList.add(index, vMapping);
    }

    public void deleteDelay() {
        this.delay = null;
    }

    public void deleteRetries() {
        this.retries = null;
    }

    public void deleteUseCategories() {
        this.useCategories = null;
    }

    public Enumeration<Mapping> enumerateMapping() {
        return Collections.enumeration(this.mappingList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RancidConfiguration) {
            RancidConfiguration temp = (RancidConfiguration)obj;
            boolean equals = Objects.equals(temp.delay, this.delay) && Objects.equals(temp.retries, this.retries) && Objects.equals(temp.useCategories, this.useCategories) && Objects.equals(temp.defaultType, this.defaultType) && Objects.equals(temp.policies, this.policies) && Objects.equals(temp.mappingList, this.mappingList);
            return equals;
        }
        return false;
    }

    public String getDefaultType() {
        return this.defaultType != null ? this.defaultType : DEFAULT_DEFAULT_TYPE;
    }

    public Long getDelay() {
        return this.delay;
    }

    public Mapping getMapping(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.mappingList.size()) {
            throw new IndexOutOfBoundsException("getMapping: Index value '" + index + "' not in range [0.." + (this.mappingList.size() - 1) + "]");
        }
        return this.mappingList.get(index);
    }

    public Mapping[] getMapping() {
        Mapping[] array = new Mapping[]{};
        return this.mappingList.toArray(array);
    }

    public List<Mapping> getMappingCollection() {
        return this.mappingList;
    }

    public int getMappingCount() {
        return this.mappingList.size();
    }

    public Policies getPolicies() {
        return this.policies;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public Boolean getUseCategories() {
        return this.useCategories != null ? this.useCategories : Boolean.valueOf("false");
    }

    public boolean hasDelay() {
        return this.delay != null;
    }

    public boolean hasRetries() {
        return this.retries != null;
    }

    public boolean hasUseCategories() {
        return this.useCategories != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.delay, this.retries, this.useCategories, this.defaultType, this.policies, this.mappingList);
        return hash;
    }

    public Boolean isUseCategories() {
        return this.useCategories != null ? this.useCategories : Boolean.valueOf("false");
    }

    public Iterator<Mapping> iterateMapping() {
        return this.mappingList.iterator();
    }

    public void removeAllMapping() {
        this.mappingList.clear();
    }

    public boolean removeMapping(Mapping vMapping) {
        boolean removed = this.mappingList.remove(vMapping);
        return removed;
    }

    public Mapping removeMappingAt(int index) {
        Mapping obj = this.mappingList.remove(index);
        return obj;
    }

    public void setDefaultType(String defaultType) {
        this.defaultType = defaultType;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    public void setMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.mappingList.size()) {
            throw new IndexOutOfBoundsException("setMapping: Index value '" + index + "' not in range [0.." + (this.mappingList.size() - 1) + "]");
        }
        this.mappingList.set(index, vMapping);
    }

    public void setMapping(Mapping[] vMappingArray) {
        this.mappingList.clear();
        for (int i = 0; i < vMappingArray.length; ++i) {
            this.mappingList.add(vMappingArray[i]);
        }
    }

    public void setMapping(List<Mapping> vMappingList) {
        this.mappingList.clear();
        this.mappingList.addAll(vMappingList);
    }

    public void setMappingCollection(List<Mapping> mappingList) {
        this.mappingList = mappingList;
    }

    public void setPolicies(Policies policies) {
        this.policies = policies;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public void setUseCategories(Boolean useCategories) {
        this.useCategories = useCategories;
    }
}

