/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notificationCommands;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.notificationCommands.Command;
import org.opennms.netmgt.config.notificationCommands.Header;

@XmlRootElement(name="notification-commands")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NotificationCommands
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="header", required=true)
    private Header header;
    @XmlElement(name="command", required=true)
    private List<Command> commandList = new ArrayList<Command>();

    public void addCommand(Command vCommand) throws IndexOutOfBoundsException {
        this.commandList.add(vCommand);
    }

    public void addCommand(int index, Command vCommand) throws IndexOutOfBoundsException {
        this.commandList.add(index, vCommand);
    }

    public Enumeration<Command> enumerateCommand() {
        return Collections.enumeration(this.commandList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NotificationCommands) {
            NotificationCommands temp = (NotificationCommands)obj;
            boolean equals = Objects.equals(temp.header, this.header) && Objects.equals(temp.commandList, this.commandList);
            return equals;
        }
        return false;
    }

    public Command getCommand(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.commandList.size()) {
            throw new IndexOutOfBoundsException("getCommand: Index value '" + index + "' not in range [0.." + (this.commandList.size() - 1) + "]");
        }
        return this.commandList.get(index);
    }

    public Command[] getCommand() {
        Command[] array = new Command[]{};
        return this.commandList.toArray(array);
    }

    public List<Command> getCommandCollection() {
        return this.commandList;
    }

    public int getCommandCount() {
        return this.commandList.size();
    }

    public Header getHeader() {
        return this.header;
    }

    public int hashCode() {
        int hash = Objects.hash(this.header, this.commandList);
        return hash;
    }

    public Iterator<Command> iterateCommand() {
        return this.commandList.iterator();
    }

    public void removeAllCommand() {
        this.commandList.clear();
    }

    public boolean removeCommand(Command vCommand) {
        boolean removed = this.commandList.remove(vCommand);
        return removed;
    }

    public Command removeCommandAt(int index) {
        Command obj = this.commandList.remove(index);
        return obj;
    }

    public void setCommand(int index, Command vCommand) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.commandList.size()) {
            throw new IndexOutOfBoundsException("setCommand: Index value '" + index + "' not in range [0.." + (this.commandList.size() - 1) + "]");
        }
        this.commandList.set(index, vCommand);
    }

    public void setCommand(Command[] vCommandArray) {
        this.commandList.clear();
        for (int i = 0; i < vCommandArray.length; ++i) {
            this.commandList.add(vCommandArray[i]);
        }
    }

    public void setCommand(List<Command> vCommandList) {
        this.commandList.clear();
        this.commandList.addAll(vCommandList);
    }

    public void setCommandCollection(List<Command> commandList) {
        this.commandList = commandList;
    }

    public void setHeader(Header header) {
        this.header = header;
    }
}

