/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.filter.Table;

@XmlRootElement(name="database-schema")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DatabaseSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="table")
    private List<Table> tableList = new ArrayList<Table>();

    public void addTable(Table vTable) throws IndexOutOfBoundsException {
        this.tableList.add(vTable);
    }

    public void addTable(int index, Table vTable) throws IndexOutOfBoundsException {
        this.tableList.add(index, vTable);
    }

    public Enumeration<Table> enumerateTable() {
        return Collections.enumeration(this.tableList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DatabaseSchema) {
            DatabaseSchema temp = (DatabaseSchema)obj;
            boolean equals = Objects.equals(temp.tableList, this.tableList);
            return equals;
        }
        return false;
    }

    public Table getTable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.tableList.size()) {
            throw new IndexOutOfBoundsException("getTable: Index value '" + index + "' not in range [0.." + (this.tableList.size() - 1) + "]");
        }
        return this.tableList.get(index);
    }

    public Table[] getTable() {
        Table[] array = new Table[]{};
        return this.tableList.toArray(array);
    }

    public List<Table> getTableCollection() {
        return this.tableList;
    }

    public int getTableCount() {
        return this.tableList.size();
    }

    public int hashCode() {
        int hash = Objects.hash(this.tableList);
        return hash;
    }

    public Iterator<Table> iterateTable() {
        return this.tableList.iterator();
    }

    public void removeAllTable() {
        this.tableList.clear();
    }

    public boolean removeTable(Table vTable) {
        boolean removed = this.tableList.remove(vTable);
        return removed;
    }

    public Table removeTableAt(int index) {
        Table obj = this.tableList.remove(index);
        return obj;
    }

    public void setTable(int index, Table vTable) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.tableList.size()) {
            throw new IndexOutOfBoundsException("setTable: Index value '" + index + "' not in range [0.." + (this.tableList.size() - 1) + "]");
        }
        this.tableList.set(index, vTable);
    }

    public void setTable(Table[] vTableArray) {
        this.tableList.clear();
        for (int i = 0; i < vTableArray.length; ++i) {
            this.tableList.add(vTableArray[i]);
        }
    }

    public void setTable(List<Table> vTableList) {
        this.tableList.clear();
        this.tableList.addAll(vTableList);
    }

    public void setTableCollection(List<Table> tableList) {
        this.tableList = tableList;
    }
}

