/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.categories;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.categories.CategoryGroup;
import org.opennms.netmgt.config.categories.Header;

@XmlRootElement(name="catinfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="categories.xsd")
public class Catinfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="header", required=true)
    private Header m_header;
    @XmlElement(name="categorygroup", required=true)
    private List<CategoryGroup> m_categoryGroup = new ArrayList<CategoryGroup>();

    public Catinfo() {
    }

    public Catinfo(String rev, String created, String mstation) {
        this.m_header = new Header(rev, created, mstation);
    }

    public Header getHeader() {
        return this.m_header;
    }

    public void setHeader(Header header) {
        this.m_header = header;
    }

    public List<CategoryGroup> getCategoryGroups() {
        return this.m_categoryGroup;
    }

    public void setCategoryGroups(List<CategoryGroup> groups) {
        this.m_categoryGroup.clear();
        this.m_categoryGroup.addAll(groups);
    }

    public void addCategoryGroup(CategoryGroup group) throws IndexOutOfBoundsException {
        this.m_categoryGroup.add(group);
    }

    public boolean removeCategoryGroup(CategoryGroup vCategorygroup) {
        return this.m_categoryGroup.remove(vCategorygroup);
    }

    public boolean removeCategoryGroup(String groupname) {
        return this.m_categoryGroup.removeIf(cg -> cg.getName().equals(groupname));
    }

    public void clearCategoryGroups() {
        this.m_categoryGroup.clear();
    }

    public void replaceCategoryInGroup(String groupname, Category cat) {
        this.m_categoryGroup.forEach(cg -> {
            if (cg.getName().equals(groupname)) {
                cg.getCategories().replaceAll(c -> {
                    if (c.getLabel().equals(cat.getLabel())) {
                        return cat;
                    }
                    return c;
                });
            }
        });
    }

    public int hashCode() {
        return Objects.hash(this.m_header, this.m_categoryGroup);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Catinfo) {
            Catinfo temp = (Catinfo)obj;
            return Objects.equals(temp.m_header, this.m_header) && Objects.equals(temp.m_categoryGroup, this.m_categoryGroup);
        }
        return false;
    }

    public String toString() {
        return "Catinfo [header=" + this.m_header + ", categoryGroup=" + this.m_categoryGroup + "]";
    }
}

