/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.vmware;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.vmware.VmwareConfig;
import org.opennms.netmgt.config.vmware.VmwareServer;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.vmware.VmwareRequisitionUrlConnection;

public abstract class VmwareRequisitionTool {
    public static void main(String[] args) throws Exception {
        File cfg;
        String urlString;
        URL url;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        CommandLine cmd = parser.parse(options, args);
        List arguments = cmd.getArgList();
        if (arguments.size() < 1) {
            VmwareRequisitionTool.usage(options, cmd);
            System.exit(1);
        }
        if (!(url = new URL(urlString = ((String)arguments.remove(0)).replaceFirst("vmware", "http"))).getQuery().contains("username") && url.getUserInfo() == null && (cfg = new File(ConfigFileConstants.getFilePathString(), "vmware-config.xml")).exists()) {
            String username = null;
            String password = null;
            VmwareConfig config = (VmwareConfig)JaxbUtils.unmarshal(VmwareConfig.class, (File)cfg);
            for (VmwareServer srv : config.getVmwareServerCollection()) {
                if (!srv.getHostname().equals(url.getHost())) continue;
                username = srv.getUsername();
                password = srv.getPassword();
            }
            if (username == null || password == null) {
                throw new IllegalArgumentException("Can't retrieve credentials for " + url.getHost() + " from " + cfg);
            }
            urlString = urlString + ";username=" + username + ";password=" + password;
            url = new URL(urlString);
        }
        VmwareRequisitionUrlConnection c = new VmwareRequisitionUrlConnection(url){

            @Override
            protected Requisition getExistingRequisition() {
                File req = new File(ConfigFileConstants.getFilePathString(), "imports" + File.separator + this.m_foreignSource + ".xml");
                if (req.exists()) {
                    return (Requisition)JaxbUtils.unmarshal(Requisition.class, (File)req);
                }
                return null;
            }
        };
        c.connect();
        InputStream is = c.getInputStream();
        if (is == null) {
            System.err.println("Couldn't generate requisition from " + urlString);
            System.exit(1);
        } else {
            System.out.println(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
        }
    }

    private static void usage(Options options, CommandLine cmd, String error, Exception e) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(System.out);
        if (error != null) {
            pw.println("An error occurred: " + error + "\n");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Usage: VmwareRequisitionTool vmware://username:password@host[/foreign-source]?keyA=valueA;keyB=valueB;...\n");
        sb.append(" Note: in case the credentials are not specified, they should exist on vmware.config.xml\n");
        formatter.printHelp(sb.toString(), options);
        if (e != null) {
            pw.println(e.getMessage());
            e.printStackTrace(pw);
        }
        pw.close();
    }

    private static void usage(Options options, CommandLine cmd) {
        VmwareRequisitionTool.usage(options, cmd, null, null);
    }
}

