/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.util.Collections;
import java.util.List;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.netmgt.config.reporting.DateParm;
import org.opennms.netmgt.config.reporting.IntParm;
import org.opennms.netmgt.config.reporting.OpennmsReports;
import org.opennms.netmgt.config.reporting.Parameters;
import org.opennms.netmgt.config.reporting.Report;
import org.opennms.netmgt.config.reporting.StringParm;
import org.opennms.netmgt.dao.api.OnmsReportConfigDao;

public class DefaultOnmsReportConfigDao
extends AbstractJaxbConfigDao<OpennmsReports, List<Report>>
implements OnmsReportConfigDao {
    public DefaultOnmsReportConfigDao() {
        super(OpennmsReports.class, "OpenNMS Report Configuration");
    }

    public String getHtmlStylesheetLocation(String id) {
        Report report = this.getReport(id);
        if (report != null) {
            return report.getHtmlTemplate();
        }
        return null;
    }

    public String getPdfStylesheetLocation(String id) {
        Report report = this.getReport(id);
        if (report != null) {
            return report.getPdfTemplate();
        }
        return null;
    }

    public String getSvgStylesheetLocation(String id) {
        Report report = this.getReport(id);
        if (report != null) {
            return report.getSvgTemplate();
        }
        return null;
    }

    public String getLogo(String id) {
        Report report = this.getReport(id);
        if (report != null) {
            return report.getLogo();
        }
        return null;
    }

    public String getType(String id) {
        Report report = this.getReport(id);
        if (report != null) {
            return report.getType();
        }
        return null;
    }

    private Report getReport(String id) {
        for (Report report : (List)this.getContainer().getObject()) {
            if (!id.equals(report.getId())) continue;
            return report;
        }
        return null;
    }

    public Parameters getParameters(String id) {
        Parameters parameters = null;
        Report report = this.getReport(id);
        if (report != null) {
            parameters = report.getParameters();
        }
        return parameters;
    }

    public DateParm[] getDateParms(String id) {
        DateParm[] dateParms = null;
        Report report = this.getReport(id);
        if (report != null) {
            dateParms = report.getParameters().getDateParm();
        }
        return dateParms;
    }

    public StringParm[] getStringParms(String id) {
        StringParm[] stringParms = null;
        Report report = this.getReport(id);
        if (report != null) {
            stringParms = report.getParameters().getStringParm();
        }
        return stringParms;
    }

    public IntParm[] getIntParms(String id) {
        IntParm[] intParms = null;
        Report report = this.getReport(id);
        if (report != null) {
            intParms = report.getParameters().getIntParm();
        }
        return intParms;
    }

    public List<Report> translateConfig(OpennmsReports config) {
        return Collections.unmodifiableList(config.getReportCollection());
    }
}

