/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.cf;

import com.vmware.vim25.NotAuthenticated;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.UpdateSet;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.PropertyCollector;
import com.vmware.vim25.mo.PropertyFilter;
import java.rmi.RemoteException;
import java.util.Observable;
import java.util.Vector;
import org.apache.log4j.Logger;

class ManagedObjectWatcher
extends Observable
implements Runnable {
    private PropertyCollector pc;
    private Vector<PropertyFilter> filters = new Vector();
    private String version = "";
    private static Logger log = Logger.getLogger(ManagedObjectWatcher.class);

    public ManagedObjectWatcher(PropertyCollector pc) {
        this.pc = pc;
    }

    public void watch(ManagedObject[] mos, String[] propNames) {
        PropertyFilterSpec pfs = new PropertyFilterSpec();
        ObjectSpec[] oss = new ObjectSpec[mos.length];
        for (int i = 0; i < oss.length; ++i) {
            oss[i] = new ObjectSpec();
            oss[i].setObj(mos[i].getMOR());
        }
        pfs.setObjectSet(oss);
        PropertySpec ps = new PropertySpec();
        ps.setType(mos[0].getMOR().getType());
        ps.setPathSet(propNames);
        pfs.setPropSet(new PropertySpec[]{ps});
        this.watch(pfs);
    }

    public void watch(PropertyFilterSpec pfs) {
        try {
            PropertyFilter pf = this.pc.createFilter(pfs, true);
            this.filters.add(pf);
        }
        catch (RemoteException re) {
            log.error((Object)"RemoteException caught trying to watch on a PropertyFilterSpec", (Throwable)re);
            throw new RuntimeException(re);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    UpdateSet update = this.pc.waitForUpdates(this.version);
                    PropertyFilterUpdate[] pfu = update.getFilterSet();
                    this.setChanged();
                    this.notifyObservers(pfu);
                    this.version = update.getVersion();
                }
            }
            catch (NotAuthenticated na) {
                log.error((Object)"NotAuthenticated Exception caught.", (Throwable)na);
            }
            catch (Exception e) {
                log.error((Object)"Generic Exception caught in run block of ManagedObjectWatcher.", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void cleanUp() {
        for (PropertyFilter filter : this.filters) {
            try {
                filter.destroyPropertyFilter();
            }
            catch (RemoteException e) {
                log.error((Object)"RemoteException caught in cleanUp", (Throwable)e);
            }
        }
    }
}

