/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.spifly;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.aries.spifly.BaseActivator;
import org.apache.aries.spifly.ProviderServiceFactory;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class ProviderBundleTrackerCustomizer
implements BundleTrackerCustomizer {
    private static final String METAINF_SERVICES = "META-INF/services";
    final BaseActivator activator;
    final Bundle spiBundle;

    public ProviderBundleTrackerCustomizer(BaseActivator activator, Bundle spiBundle) {
        this.activator = activator;
        this.spiBundle = spiBundle;
    }

    /*
     * WARNING - void declaration
     */
    public List<ServiceRegistration> addingBundle(Bundle bundle, BundleEvent event) {
        Object bcp;
        this.log(3, "Bundle Considered for SPI providers: " + bundle.getSymbolicName());
        if (bundle.equals(this.spiBundle)) {
            return null;
        }
        List<String> providedServices = null;
        HashMap<String, Object> customAttributes = new HashMap<String, Object>();
        if (bundle.getHeaders().get("Require-Capability") != null) {
            try {
                providedServices = this.readServiceLoaderMediatorCapabilityMetadata(bundle.getHeaders(), customAttributes);
            }
            catch (InvalidSyntaxException e) {
                this.log(1, "Unable to read capabilities from bundle " + bundle, e);
            }
        }
        boolean fromSPIProviderHeader = false;
        if (providedServices == null && bundle.getHeaders().get("SPI-Provider") != null) {
            String header = ((String)bundle.getHeaders().get("SPI-Provider")).toString().trim();
            providedServices = "*".equals(header) ? new ArrayList<String>() : Arrays.asList(header.split(","));
            fromSPIProviderHeader = true;
        }
        if (providedServices == null) {
            this.log(3, "No 'SPI-Provider' Manifest header. Skipping bundle: " + bundle.getSymbolicName());
            return null;
        }
        this.log(3, "Examining bundle for SPI provider: " + bundle.getSymbolicName());
        for (String svc : providedServices) {
            this.activator.registerProviderBundle(svc, bundle, customAttributes);
        }
        URL servicesDir = bundle.getResource("/META-INF/services");
        if (servicesDir == null) {
            return null;
        }
        ArrayList<Object> serviceFileURLs = new ArrayList<Object>();
        Enumeration entries = bundle.findEntries(METAINF_SERVICES, "*", false);
        if (entries != null) {
            serviceFileURLs.addAll(Collections.list(entries));
        }
        if ((bcp = bundle.getHeaders().get("Bundle-ClassPath")) instanceof String) {
            void var12_15;
            String[] arr$ = ((String)bcp).split(",");
            int len$ = arr$.length;
            boolean bl = false;
            while (var12_15 < len$) {
                URL url;
                String entry = arr$[var12_15];
                if (!(entry = entry.trim()).equals(".") && (url = bundle.getResource(entry)) != null) {
                    serviceFileURLs.addAll(this.getMetaInfServiceURLsFromJar(url));
                }
                ++var12_15;
            }
        }
        ArrayList<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();
        for (URL uRL : serviceFileURLs) {
            this.log(3, "Found SPI resource: " + uRL);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                String className = null;
                while ((className = reader.readLine()) != null) {
                    try {
                        if ((className = className.trim()).length() == 0 || className.startsWith("#")) continue;
                        String serviceFile = uRL.toExternalForm();
                        int idx = serviceFile.lastIndexOf(47);
                        String registrationClassName = className;
                        if (serviceFile.length() > idx) {
                            registrationClassName = serviceFile.substring(idx + 1);
                        }
                        if (providedServices.size() > 0 && !providedServices.contains(registrationClassName)) continue;
                        Class cls = bundle.loadClass(className);
                        this.log(3, "Loaded SPI provider: " + cls);
                        Hashtable<Object, Object> properties = fromSPIProviderHeader ? new Hashtable() : this.findServiceRegistrationProperties(bundle.getHeaders(), registrationClassName, className);
                        if (properties != null) {
                            properties.put("serviceloader.mediator", this.spiBundle.getBundleId());
                            properties.put(".org.apache.aries.spifly.provider.implclass", cls.getName());
                            ServiceRegistration reg = null;
                            SecurityManager sm = System.getSecurityManager();
                            if (sm != null) {
                                if (bundle.hasPermission((Object)new ServicePermission(registrationClassName, "register"))) {
                                    reg = bundle.getBundleContext().registerService(registrationClassName, (Object)new ProviderServiceFactory(cls), properties);
                                } else {
                                    this.log(3, "Bundle " + bundle + " does not have the permission to register services of type: " + registrationClassName);
                                }
                            } else {
                                reg = bundle.getBundleContext().registerService(registrationClassName, (Object)new ProviderServiceFactory(cls), properties);
                            }
                            if (reg != null) {
                                registrations.add(reg);
                                this.log(3, "Registered service: " + reg);
                            }
                        }
                        this.activator.registerProviderBundle(registrationClassName, bundle, customAttributes);
                        this.log(3, "Registered provider: " + registrationClassName + " in bundle " + bundle.getSymbolicName());
                    }
                    catch (Exception e) {
                        this.log(2, "Could not load SPI implementation referred from " + uRL, e);
                    }
                }
            }
            catch (IOException e) {
                this.log(2, "Could not read SPI metadata from " + uRL, e);
            }
        }
        return registrations;
    }

    private List<String> readServiceLoaderMediatorCapabilityMetadata(Dictionary<?, ?> headers, Map<String, Object> customAttributes) throws InvalidSyntaxException {
        Object requirementHeader = headers.get("Require-Capability");
        if (requirementHeader == null) {
            return null;
        }
        List requirements = ManifestHeaderProcessor.parseRequirementString((String)requirementHeader.toString());
        ManifestHeaderProcessor.GenericMetadata extenderRequirement = ProviderBundleTrackerCustomizer.findRequirement(requirements, "osgi.extender", "osgi.serviceloader.registrar");
        if (extenderRequirement == null) {
            return null;
        }
        Object capabilityHeader = headers.get("Provide-Capability");
        List capabilities = capabilityHeader == null ? Collections.emptyList() : ManifestHeaderProcessor.parseCapabilityString((String)capabilityHeader.toString());
        ArrayList<String> serviceNames = new ArrayList<String>();
        for (ManifestHeaderProcessor.GenericMetadata serviceLoaderCapability : ProviderBundleTrackerCustomizer.findAllMetadata(capabilities, "osgi.serviceloader")) {
            for (Map.Entry entry : serviceLoaderCapability.getAttributes().entrySet()) {
                if ("osgi.serviceloader".equals(entry.getKey())) {
                    serviceNames.add(entry.getValue().toString());
                    continue;
                }
                customAttributes.put((String)entry.getKey(), entry.getValue());
            }
        }
        return serviceNames;
    }

    private Hashtable<String, Object> findServiceRegistrationProperties(Dictionary<?, ?> headers, String spiName, String implName) {
        String registerDirective;
        Object capabilityHeader = headers.get("Provide-Capability");
        if (capabilityHeader == null) {
            return null;
        }
        List capabilities = ManifestHeaderProcessor.parseCapabilityString((String)capabilityHeader.toString());
        ManifestHeaderProcessor.GenericMetadata cap = this.findCapability(capabilities, "osgi.serviceloader", spiName);
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (cap != null) {
            for (Map.Entry entry : cap.getAttributes().entrySet()) {
                if ("osgi.serviceloader".equals(entry.getKey()) || ((String)entry.getKey()).startsWith(".")) continue;
                properties.put((String)entry.getKey(), entry.getValue());
            }
        }
        if ((registerDirective = (String)cap.getDirectives().get("register")) == null) {
            return properties;
        }
        if ("".equals(registerDirective.trim())) {
            return null;
        }
        if (implName.equals(registerDirective.trim())) {
            return properties;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URL> getMetaInfServiceURLsFromJar(URL url) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            JarInputStream jis = null;
            try {
                jis = new JarInputStream(url.openStream());
                JarEntry je = null;
                while ((je = jis.getNextJarEntry()) != null) {
                    if (!je.getName().startsWith(METAINF_SERVICES) || je.getName().length() <= METAINF_SERVICES.length() + 1) continue;
                    urls.add(new URL("jar:" + url + "!/" + je.getName()));
                }
            }
            finally {
                if (jis != null) {
                    jis.close();
                }
            }
        }
        catch (IOException e) {
            this.log(1, "Problem opening embedded jar file: " + url, e);
        }
        return urls;
    }

    private ManifestHeaderProcessor.GenericMetadata findCapability(List<ManifestHeaderProcessor.GenericMetadata> capabilities, String namespace, String spiName) {
        for (ManifestHeaderProcessor.GenericMetadata cap : capabilities) {
            if (!namespace.equals(cap.getNamespace()) || !spiName.equals(cap.getAttributes().get(namespace))) continue;
            return cap;
        }
        return null;
    }

    private static Collection<ManifestHeaderProcessor.GenericMetadata> findAllMetadata(List<ManifestHeaderProcessor.GenericMetadata> requirementsOrCapabilities, String namespace) {
        ArrayList<ManifestHeaderProcessor.GenericMetadata> reqsCaps = new ArrayList<ManifestHeaderProcessor.GenericMetadata>();
        for (ManifestHeaderProcessor.GenericMetadata reqCap : requirementsOrCapabilities) {
            if (!namespace.equals(reqCap.getNamespace())) continue;
            reqsCaps.add(reqCap);
        }
        return reqsCaps;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object registrations) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object registrations) {
        this.activator.unregisterProviderBundle(bundle);
        if (registrations == null) {
            return;
        }
        for (ServiceRegistration reg : (List)registrations) {
            reg.unregister();
            this.log(3, "Unregistered: " + reg);
        }
    }

    private void log(int level, String message) {
        this.activator.log(level, message);
    }

    private void log(int level, String message, Throwable th) {
        this.activator.log(level, message, th);
    }

    private static ManifestHeaderProcessor.GenericMetadata findRequirement(List<ManifestHeaderProcessor.GenericMetadata> requirements, String namespace, String type) throws InvalidSyntaxException {
        Hashtable<String, String> nsAttr = new Hashtable<String, String>();
        ((Dictionary)nsAttr).put(namespace, type);
        for (ManifestHeaderProcessor.GenericMetadata req : requirements) {
            Filter filter;
            String filterString;
            if (!namespace.equals(req.getNamespace()) || (filterString = (String)req.getDirectives().get("filter")) == null || !(filter = FrameworkUtil.createFilter((String)filterString)).match(nsAttr)) continue;
            return req;
        }
        return null;
    }
}

