/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.ami.AmiAgentConfig;
import org.opennms.netmgt.config.ami.AmiConfig;
import org.opennms.netmgt.config.ami.Definition;
import org.opennms.netmgt.config.ami.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmiPeerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AmiPeerFactory.class);
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private static AmiPeerFactory m_singleton = null;
    private static AmiConfig m_config;
    private static boolean m_loaded;

    private AmiPeerFactory(String configFile) throws IOException {
        m_config = (AmiConfig)JaxbUtils.unmarshal(AmiConfig.class, (File)new File(configFile));
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.AMI_CONFIG_FILE_NAME);
        LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
        m_singleton = new AmiPeerFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException {
        m_singleton = null;
        m_loaded = false;
        AmiPeerFactory.init();
    }

    public static synchronized AmiPeerFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The AmiPeerFactory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(AmiPeerFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    public static synchronized void setAmiConfig(AmiConfig m_config) {
        AmiPeerFactory.m_config = m_config;
    }

    public void saveCurrent() throws Exception {
        this.getWriteLock().lock();
        try {
            this.optimize();
            StringWriter stringWriter = new StringWriter();
            JaxbUtils.marshal((Object)m_config, (Writer)stringWriter);
            if (stringWriter.toString() != null) {
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.AMI_CONFIG_FILE_NAME)), StandardCharsets.UTF_8);
                fileWriter.write(stringWriter.toString());
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
            }
            AmiPeerFactory.reload();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void optimize() throws UnknownHostException {
        this.getWriteLock().lock();
        try {
            Iterator definitionsIterator = m_config.getDefinitionCollection().iterator();
            while (definitionsIterator.hasNext()) {
                Definition definition = (Definition)definitionsIterator.next();
                if (definition.getSpecificCount() != 0 || definition.getRangeCount() != 0) continue;
                LOG.debug("optimize: Removing empty definition element");
                definitionsIterator.remove();
            }
            for (Definition definition : m_config.getDefinitionCollection()) {
                Iterator rangesIterator = definition.getRangeCollection().iterator();
                while (rangesIterator.hasNext()) {
                    Range range = (Range)rangesIterator.next();
                    if (!range.getBegin().equals(range.getEnd())) continue;
                    definition.addSpecific(range.getBegin());
                    rangesIterator.remove();
                }
            }
            for (Definition definition : m_config.getDefinitionCollection()) {
                Object specific2;
                TreeMap<InetAddress, String> specificsMap = new TreeMap<InetAddress, String>((Comparator<InetAddress>)new InetAddressComparator());
                for (Object specific2 : definition.getSpecificCollection()) {
                    specificsMap.put(InetAddressUtils.getInetAddress((String)specific2), ((String)specific2).trim());
                }
                TreeMap<InetAddress, Range> rangesMap = new TreeMap<InetAddress, Range>((Comparator<InetAddress>)new InetAddressComparator());
                specific2 = definition.getRangeCollection().iterator();
                while (specific2.hasNext()) {
                    Range range = (Range)specific2.next();
                    rangesMap.put(InetAddressUtils.getInetAddress((String)range.getBegin()), range);
                }
                InetAddress priorSpecific = null;
                Range addedRange = null;
                for (InetAddress specific3 : specificsMap.keySet()) {
                    if (priorSpecific == null) {
                        priorSpecific = specific3;
                        continue;
                    }
                    if (BigInteger.ONE.equals(InetAddressUtils.difference((InetAddress)specific3, (InetAddress)priorSpecific)) && InetAddressUtils.inSameScope((InetAddress)specific3, (InetAddress)priorSpecific)) {
                        if (addedRange == null) {
                            addedRange = new Range();
                            addedRange.setBegin(InetAddressUtils.toIpAddrString((InetAddress)priorSpecific));
                            rangesMap.put(priorSpecific, addedRange);
                            specificsMap.remove(priorSpecific);
                        }
                        addedRange.setEnd(InetAddressUtils.toIpAddrString((InetAddress)specific3));
                        specificsMap.remove(specific3);
                    } else {
                        addedRange = null;
                    }
                    priorSpecific = specific3;
                }
                block10: for (InetAddress specific3 : new ArrayList(specificsMap.keySet())) {
                    for (InetAddress begin : new ArrayList(rangesMap.keySet())) {
                        Range range;
                        InetAddress end;
                        if (!InetAddressUtils.inSameScope((InetAddress)begin, (InetAddress)specific3) || InetAddressUtils.toInteger((InetAddress)begin).subtract(BigInteger.ONE).compareTo(InetAddressUtils.toInteger((InetAddress)specific3)) > 0 || InetAddressUtils.toInteger((InetAddress)(end = InetAddressUtils.getInetAddress((String)(range = (Range)rangesMap.get(begin)).getEnd()))).add(BigInteger.ONE).compareTo(InetAddressUtils.toInteger((InetAddress)specific3)) < 0) continue;
                        if (InetAddressUtils.toInteger((InetAddress)specific3).compareTo(InetAddressUtils.toInteger((InetAddress)begin)) >= 0 && InetAddressUtils.toInteger((InetAddress)specific3).compareTo(InetAddressUtils.toInteger((InetAddress)end)) <= 0) {
                            specificsMap.remove(specific3);
                            continue block10;
                        }
                        if (InetAddressUtils.toInteger((InetAddress)begin).subtract(BigInteger.ONE).equals(InetAddressUtils.toInteger((InetAddress)specific3))) {
                            rangesMap.remove(begin);
                            rangesMap.put(specific3, range);
                            range.setBegin(InetAddressUtils.toIpAddrString((InetAddress)specific3));
                            specificsMap.remove(specific3);
                            continue block10;
                        }
                        if (!InetAddressUtils.toInteger((InetAddress)end).add(BigInteger.ONE).equals(InetAddressUtils.toInteger((InetAddress)specific3))) continue;
                        range.setEnd(InetAddressUtils.toIpAddrString((InetAddress)specific3));
                        specificsMap.remove(specific3);
                        continue block10;
                    }
                }
                Range priorRange = null;
                InetAddress priorBegin = null;
                InetAddress priorEnd = null;
                Iterator rangesIterator = rangesMap.keySet().iterator();
                while (rangesIterator.hasNext()) {
                    InetAddress beginAddress = (InetAddress)rangesIterator.next();
                    Range range = (Range)rangesMap.get(beginAddress);
                    InetAddress endAddress = InetAddressUtils.getInetAddress((String)range.getEnd());
                    if (priorRange != null && InetAddressUtils.inSameScope((InetAddress)beginAddress, priorEnd) && InetAddressUtils.difference((InetAddress)beginAddress, (InetAddress)priorEnd).compareTo(BigInteger.ONE) <= 0) {
                        priorBegin = new InetAddressComparator().compare(priorBegin, beginAddress) < 0 ? priorBegin : beginAddress;
                        priorRange.setBegin(InetAddressUtils.toIpAddrString((InetAddress)priorBegin));
                        priorEnd = new InetAddressComparator().compare(priorEnd, endAddress) > 0 ? priorEnd : endAddress;
                        priorRange.setEnd(InetAddressUtils.toIpAddrString((InetAddress)priorEnd));
                        rangesIterator.remove();
                        continue;
                    }
                    priorRange = range;
                    priorBegin = beginAddress;
                    priorEnd = endAddress;
                }
                definition.setSpecific(specificsMap.values().toArray(new String[0]));
                definition.setRange(rangesMap.values().toArray(new Range[0]));
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmiAgentConfig getAgentConfig(InetAddress agentInetAddress) {
        this.getReadLock().lock();
        try {
            if (m_config == null) {
                AmiAgentConfig amiAgentConfig = new AmiAgentConfig(agentInetAddress);
                return amiAgentConfig;
            }
            AmiAgentConfig agentConfig = new AmiAgentConfig(agentInetAddress);
            this.setAmiAgentConfig(agentConfig, new Definition());
            block4: for (Definition def : m_config.getDefinitionCollection()) {
                for (String saddr : def.getSpecificCollection()) {
                    InetAddress addr = InetAddressUtils.addr((String)(saddr = saddr.trim()));
                    if (!addr.equals(agentConfig.getAddress())) continue;
                    this.setAmiAgentConfig(agentConfig, def);
                    break block4;
                }
                for (Range rng : def.getRangeCollection()) {
                    if (!InetAddressUtils.isInetAddressInRange((String)InetAddressUtils.str((InetAddress)agentConfig.getAddress()), (String)rng.getBegin(), (String)rng.getEnd())) continue;
                    this.setAmiAgentConfig(agentConfig, def);
                    break block4;
                }
                for (String ipMatch : def.getIpMatchCollection()) {
                    if (!IPLike.matches((String)InetAddressUtils.str((InetAddress)agentInetAddress), (String)ipMatch)) continue;
                    this.setAmiAgentConfig(agentConfig, def);
                    break block4;
                }
            }
            if (agentConfig == null) {
                this.setAmiAgentConfig(agentConfig, new Definition());
            }
            AmiAgentConfig amiAgentConfig = agentConfig;
            return amiAgentConfig;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private void setAmiAgentConfig(AmiAgentConfig agentConfig, Definition def) {
        this.setCommonAttributes(agentConfig, def);
        agentConfig.setPassword(this.determinePassword(def));
    }

    private void setCommonAttributes(AmiAgentConfig agentConfig, Definition def) {
        agentConfig.setRetries(this.determineRetries(def));
        agentConfig.setTimeout((int)this.determineTimeout(def));
        agentConfig.setUsername(this.determineUsername(def));
        agentConfig.setPassword(this.determinePassword(def));
    }

    private String determineUsername(Definition def) {
        if (def.getUsername() != null) {
            return def.getUsername();
        }
        if (m_config.getUsername() != null) {
            return m_config.getUsername();
        }
        return "opennms";
    }

    private String determinePassword(Definition def) {
        if (def.getPassword() != null) {
            return def.getPassword();
        }
        if (m_config.getPassword() != null) {
            return def.getPassword();
        }
        return "";
    }

    private long determineTimeout(Definition def) {
        if (def.hasTimeout() && def.getTimeout() != 0) {
            return def.getTimeout().longValue();
        }
        if (m_config.getTimeout() != 0) {
            return m_config.getTimeout();
        }
        return 3000L;
    }

    private int determineRetries(Definition def) {
        if (def.hasRetry() && def.getRetry() != 0) {
            return def.getRetry();
        }
        if (m_config.getRetry() != 0) {
            return m_config.getRetry();
        }
        return 1;
    }

    public static AmiConfig getAmiConfig() {
        return m_config;
    }

    static {
        m_loaded = false;
    }
}

