/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.xml.eventconf.EventMatcher;
import org.opennms.netmgt.xml.eventconf.EventMatchers;

@XmlRootElement(name="maskelement")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="eventconf.xsd")
@XmlType(propOrder={"m_name", "m_values"})
public class Maskelement
implements Serializable {
    private static final long serialVersionUID = -3932312038903008806L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String TAG_UEI = "uei";
    public static final String TAG_SOURCE = "source";
    public static final String TAG_NODEID = "nodeid";
    public static final String TAG_HOST = "host";
    public static final String TAG_INTERFACE = "interface";
    public static final String TAG_SNMPHOST = "snmphost";
    public static final String TAG_SERVICE = "service";
    public static final String TAG_SNMP_EID = "id";
    public static final String TAG_SNMP_SPECIFIC = "specific";
    public static final String TAG_SNMP_GENERIC = "generic";
    public static final String TAG_SNMP_COMMUNITY = "community";
    @XmlElement(name="mename", required=true)
    private String m_name;
    @XmlElement(name="mevalue", required=true)
    private List<String> m_values = new ArrayList<String>();

    public void addMevalue(String value) throws IndexOutOfBoundsException {
        this.m_values.add(value.intern());
    }

    public void addMevalue(int index, String value) throws IndexOutOfBoundsException {
        this.m_values.add(index, value.intern());
    }

    public Enumeration<String> enumerateMevalue() {
        return Collections.enumeration(this.m_values);
    }

    public String getMename() {
        return this.m_name;
    }

    public String getMevalue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_values.size()) {
            throw new IndexOutOfBoundsException("getMevalue: Index value '" + index + "' not in range [0.." + (this.m_values.size() - 1) + "]");
        }
        return this.m_values.get(index);
    }

    public String[] getMevalue() {
        return this.m_values.toArray(EMPTY_STRING_ARRAY);
    }

    public List<String> getMevalueCollection() {
        return this.m_values;
    }

    public int getMevalueCount() {
        return this.m_values.size();
    }

    public Iterator<String> iterateMevalue() {
        return this.m_values.iterator();
    }

    public void removeAllMevalue() {
        this.m_values.clear();
    }

    public boolean removeMevalue(String value) {
        return this.m_values.remove(value);
    }

    public String removeMevalueAt(int index) {
        return this.m_values.remove(index);
    }

    public void setMename(String mename) {
        this.m_name = mename.intern();
    }

    public void setMevalue(int index, String value) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_values.size()) {
            throw new IndexOutOfBoundsException("setMevalue: Index value '" + index + "' not in range [0.." + (this.m_values.size() - 1) + "]");
        }
        this.m_values.set(index, value.intern());
    }

    public void setMevalue(String[] values) {
        this.m_values.clear();
        for (String value : values) {
            this.m_values.add(value.intern());
        }
    }

    public void setMevalue(List<String> values) {
        this.m_values.clear();
        for (String value : values) {
            this.m_values.add(value.intern());
        }
    }

    public void setMevalueCollection(List<String> values) {
        this.m_values.clear();
        for (String value : values) {
            this.m_values.add(value.intern());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_values == null ? 0 : this.m_values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Maskelement)) {
            return false;
        }
        Maskelement other = (Maskelement)obj;
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        return !(this.m_values == null ? other.m_values != null : !this.m_values.equals(other.m_values));
    }

    public EventMatcher constructMatcher() {
        ArrayList<EventMatcher> valueMatchers = new ArrayList<EventMatcher>(this.m_values.size());
        for (String value : this.m_values) {
            if (value == null) continue;
            if (value.startsWith("~")) {
                valueMatchers.add(EventMatchers.valueMatchesRegexMatcher(EventMatchers.field(this.m_name), value));
                continue;
            }
            if (value.endsWith("%")) {
                valueMatchers.add(EventMatchers.valueStartsWithMatcher(EventMatchers.field(this.m_name), value));
                continue;
            }
            valueMatchers.add(EventMatchers.valueEqualsMatcher(EventMatchers.field(this.m_name), value));
        }
        if (valueMatchers.size() == 1) {
            return (EventMatcher)valueMatchers.get(0);
        }
        EventMatcher[] matchers = valueMatchers.toArray(new EventMatcher[valueMatchers.size()]);
        return EventMatchers.or(matchers);
    }
}

