/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.viewsdisplay;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.viewsdisplay.Section;

@XmlRootElement(name="view")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class View
implements Serializable {
    @XmlElement(name="view-name", required=true)
    private String viewName;
    @XmlElement(name="section", required=true)
    private List<Section> sectionList = new ArrayList<Section>();

    public void addSection(Section vSection) throws IndexOutOfBoundsException {
        this.sectionList.add(vSection);
    }

    public void addSection(int index, Section vSection) throws IndexOutOfBoundsException {
        this.sectionList.add(index, vSection);
    }

    public Enumeration<Section> enumerateSection() {
        return Collections.enumeration(this.sectionList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof View) {
            View temp = (View)obj;
            boolean equals = Objects.equals(temp.viewName, this.viewName) && Objects.equals(temp.sectionList, this.sectionList);
            return equals;
        }
        return false;
    }

    public Section getSection(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.sectionList.size()) {
            throw new IndexOutOfBoundsException("getSection: Index value '" + index + "' not in range [0.." + (this.sectionList.size() - 1) + "]");
        }
        return this.sectionList.get(index);
    }

    public Section[] getSection() {
        Section[] array = new Section[]{};
        return this.sectionList.toArray(array);
    }

    public List<Section> getSectionCollection() {
        return this.sectionList;
    }

    public int getSectionCount() {
        return this.sectionList.size();
    }

    public String getViewName() {
        return this.viewName;
    }

    public int hashCode() {
        int hash = Objects.hash(this.viewName, this.sectionList);
        return hash;
    }

    public Iterator<Section> iterateSection() {
        return this.sectionList.iterator();
    }

    public void removeAllSection() {
        this.sectionList.clear();
    }

    public boolean removeSection(Section vSection) {
        boolean removed = this.sectionList.remove(vSection);
        return removed;
    }

    public Section removeSectionAt(int index) {
        Section obj = this.sectionList.remove(index);
        return obj;
    }

    public void setSection(int index, Section vSection) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.sectionList.size()) {
            throw new IndexOutOfBoundsException("setSection: Index value '" + index + "' not in range [0.." + (this.sectionList.size() - 1) + "]");
        }
        this.sectionList.set(index, vSection);
    }

    public void setSection(Section[] vSectionArray) {
        this.sectionList.clear();
        for (int i = 0; i < vSectionArray.length; ++i) {
            this.sectionList.add(vSectionArray[i]);
        }
    }

    public void setSection(List<Section> vSectionList) {
        this.sectionList.clear();
        this.sectionList.addAll(vSectionList);
    }

    public void setSectionCollection(List<Section> sectionList) {
        this.sectionList = sectionList;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }
}

