/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.viewsdisplay;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="section")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Section
implements Serializable {
    @XmlElement(name="section-name", required=true)
    private String sectionName;
    @XmlElement(name="category", required=true)
    private List<String> categoryList = new ArrayList<String>();

    public void addCategory(String vCategory) throws IndexOutOfBoundsException {
        this.categoryList.add(vCategory);
    }

    public void addCategory(int index, String vCategory) throws IndexOutOfBoundsException {
        this.categoryList.add(index, vCategory);
    }

    public Enumeration<String> enumerateCategory() {
        return Collections.enumeration(this.categoryList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Section) {
            Section temp = (Section)obj;
            boolean equals = Objects.equals(temp.sectionName, this.sectionName) && Objects.equals(temp.categoryList, this.categoryList);
            return equals;
        }
        return false;
    }

    public String getCategory(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.categoryList.size()) {
            throw new IndexOutOfBoundsException("getCategory: Index value '" + index + "' not in range [0.." + (this.categoryList.size() - 1) + "]");
        }
        return this.categoryList.get(index);
    }

    public String[] getCategory() {
        String[] array = new String[]{};
        return this.categoryList.toArray(array);
    }

    public List<String> getCategoryCollection() {
        return this.categoryList;
    }

    public int getCategoryCount() {
        return this.categoryList.size();
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public int hashCode() {
        int hash = Objects.hash(this.sectionName, this.categoryList);
        return hash;
    }

    public Iterator<String> iterateCategory() {
        return this.categoryList.iterator();
    }

    public void removeAllCategory() {
        this.categoryList.clear();
    }

    public boolean removeCategory(String vCategory) {
        boolean removed = this.categoryList.remove(vCategory);
        return removed;
    }

    public String removeCategoryAt(int index) {
        String obj = this.categoryList.remove(index);
        return obj;
    }

    public void setCategory(int index, String vCategory) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.categoryList.size()) {
            throw new IndexOutOfBoundsException("setCategory: Index value '" + index + "' not in range [0.." + (this.categoryList.size() - 1) + "]");
        }
        this.categoryList.set(index, vCategory);
    }

    public void setCategory(String[] vCategoryArray) {
        this.categoryList.clear();
        for (int i = 0; i < vCategoryArray.length; ++i) {
            this.categoryList.add(vCategoryArray[i]);
        }
    }

    public void setCategory(List<String> vCategoryList) {
        this.categoryList.clear();
        this.categoryList.addAll(vCategoryList);
    }

    public void setCategoryCollection(List<String> categoryList) {
        this.categoryList = categoryList;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }
}

