/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.syslogd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.syslogd.Configuration;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;

@XmlRootElement(name="syslogd-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SyslogdConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="configuration", required=true)
    private Configuration configuration;
    @XmlElement(name="ueiList")
    private UeiList ueiList;
    @XmlElement(name="hideMessage")
    private HideMessage hideMessage;
    @XmlElement(name="import-file")
    private List<String> importFileList = new ArrayList<String>();

    public void addImportFile(String vImportFile) throws IndexOutOfBoundsException {
        this.importFileList.add(vImportFile);
    }

    public void addImportFile(int index, String vImportFile) throws IndexOutOfBoundsException {
        this.importFileList.add(index, vImportFile);
    }

    public Enumeration<String> enumerateImportFile() {
        return Collections.enumeration(this.importFileList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SyslogdConfiguration) {
            SyslogdConfiguration temp = (SyslogdConfiguration)obj;
            boolean equals = Objects.equals(temp.configuration, this.configuration) && Objects.equals(temp.ueiList, this.ueiList) && Objects.equals(temp.hideMessage, this.hideMessage) && Objects.equals(temp.importFileList, this.importFileList);
            return equals;
        }
        return false;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public HideMessage getHideMessage() {
        return this.hideMessage;
    }

    public String getImportFile(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.importFileList.size()) {
            throw new IndexOutOfBoundsException("getImportFile: Index value '" + index + "' not in range [0.." + (this.importFileList.size() - 1) + "]");
        }
        return this.importFileList.get(index);
    }

    public String[] getImportFile() {
        String[] array = new String[]{};
        return this.importFileList.toArray(array);
    }

    public List<String> getImportFileCollection() {
        return this.importFileList;
    }

    public int getImportFileCount() {
        return this.importFileList.size();
    }

    public UeiList getUeiList() {
        return this.ueiList;
    }

    public int hashCode() {
        int hash = Objects.hash(this.configuration, this.ueiList, this.hideMessage, this.importFileList);
        return hash;
    }

    public Iterator<String> iterateImportFile() {
        return this.importFileList.iterator();
    }

    public void removeAllImportFile() {
        this.importFileList.clear();
    }

    public boolean removeImportFile(String vImportFile) {
        boolean removed = this.importFileList.remove(vImportFile);
        return removed;
    }

    public String removeImportFileAt(int index) {
        String obj = this.importFileList.remove(index);
        return obj;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setHideMessage(HideMessage hideMessage) {
        this.hideMessage = hideMessage;
    }

    public void setImportFile(int index, String vImportFile) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.importFileList.size()) {
            throw new IndexOutOfBoundsException("setImportFile: Index value '" + index + "' not in range [0.." + (this.importFileList.size() - 1) + "]");
        }
        this.importFileList.set(index, vImportFile);
    }

    public void setImportFile(String[] vImportFileArray) {
        this.importFileList.clear();
        for (int i = 0; i < vImportFileArray.length; ++i) {
            this.importFileList.add(vImportFileArray[i]);
        }
    }

    public void setImportFile(List<String> vImportFileList) {
        this.importFileList.clear();
        this.importFileList.addAll(vImportFileList);
    }

    public void setImportFileCollection(List<String> importFileList) {
        this.importFileList = importFileList;
    }

    public void setUeiList(UeiList ueiList) {
        this.ueiList = ueiList;
    }
}

