/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmpAsset.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.snmpAsset.adapter.MibObj;

@XmlRootElement(name="mibObjs")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MibObjs
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="mibObj")
    private List<MibObj> mibObjList = new ArrayList<MibObj>();

    public void addMibObj(MibObj vMibObj) throws IndexOutOfBoundsException {
        this.mibObjList.add(vMibObj);
    }

    public void addMibObj(int index, MibObj vMibObj) throws IndexOutOfBoundsException {
        this.mibObjList.add(index, vMibObj);
    }

    public Enumeration<MibObj> enumerateMibObj() {
        return Collections.enumeration(this.mibObjList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MibObjs) {
            MibObjs temp = (MibObjs)obj;
            boolean equals = Objects.equals(temp.mibObjList, this.mibObjList);
            return equals;
        }
        return false;
    }

    public MibObj getMibObj(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.mibObjList.size()) {
            throw new IndexOutOfBoundsException("getMibObj: Index value '" + index + "' not in range [0.." + (this.mibObjList.size() - 1) + "]");
        }
        return this.mibObjList.get(index);
    }

    public MibObj[] getMibObj() {
        MibObj[] array = new MibObj[]{};
        return this.mibObjList.toArray(array);
    }

    public List<MibObj> getMibObjCollection() {
        return this.mibObjList;
    }

    public int getMibObjCount() {
        return this.mibObjList.size();
    }

    public int hashCode() {
        int hash = Objects.hash(this.mibObjList);
        return hash;
    }

    public Iterator<MibObj> iterateMibObj() {
        return this.mibObjList.iterator();
    }

    public void removeAllMibObj() {
        this.mibObjList.clear();
    }

    public boolean removeMibObj(MibObj vMibObj) {
        boolean removed = this.mibObjList.remove(vMibObj);
        return removed;
    }

    public MibObj removeMibObjAt(int index) {
        MibObj obj = this.mibObjList.remove(index);
        return obj;
    }

    public void setMibObj(int index, MibObj vMibObj) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.mibObjList.size()) {
            throw new IndexOutOfBoundsException("setMibObj: Index value '" + index + "' not in range [0.." + (this.mibObjList.size() - 1) + "]");
        }
        this.mibObjList.set(index, vMibObj);
    }

    public void setMibObj(MibObj[] vMibObjArray) {
        this.mibObjList.clear();
        for (int i = 0; i < vMibObjArray.length; ++i) {
            this.mibObjList.add(vMibObjArray[i]);
        }
    }

    public void setMibObj(List<MibObj> vMibObjList) {
        this.mibObjList.clear();
        this.mibObjList.addAll(vMibObjList);
    }

    public void setMibObjCollection(List<MibObj> mibObjList) {
        this.mibObjList = mibObjList;
    }
}

