/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.reporting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.reporting.Report;

@XmlRootElement(name="opennms-reports")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OpennmsReports
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="report")
    private List<Report> reportList = new ArrayList<Report>();

    public void addReport(Report vReport) throws IndexOutOfBoundsException {
        this.reportList.add(vReport);
    }

    public void addReport(int index, Report vReport) throws IndexOutOfBoundsException {
        this.reportList.add(index, vReport);
    }

    public Enumeration<Report> enumerateReport() {
        return Collections.enumeration(this.reportList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OpennmsReports) {
            OpennmsReports temp = (OpennmsReports)obj;
            boolean equals = Objects.equals(temp.reportList, this.reportList);
            return equals;
        }
        return false;
    }

    public Report getReport(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.reportList.size()) {
            throw new IndexOutOfBoundsException("getReport: Index value '" + index + "' not in range [0.." + (this.reportList.size() - 1) + "]");
        }
        return this.reportList.get(index);
    }

    public Report[] getReport() {
        Report[] array = new Report[]{};
        return this.reportList.toArray(array);
    }

    public List<Report> getReportCollection() {
        return this.reportList;
    }

    public int getReportCount() {
        return this.reportList.size();
    }

    public int hashCode() {
        int hash = Objects.hash(this.reportList);
        return hash;
    }

    public Iterator<Report> iterateReport() {
        return this.reportList.iterator();
    }

    public void removeAllReport() {
        this.reportList.clear();
    }

    public boolean removeReport(Report vReport) {
        boolean removed = this.reportList.remove(vReport);
        return removed;
    }

    public Report removeReportAt(int index) {
        Report obj = this.reportList.remove(index);
        return obj;
    }

    public void setReport(int index, Report vReport) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.reportList.size()) {
            throw new IndexOutOfBoundsException("setReport: Index value '" + index + "' not in range [0.." + (this.reportList.size() - 1) + "]");
        }
        this.reportList.set(index, vReport);
    }

    public void setReport(Report[] vReportArray) {
        this.reportList.clear();
        for (int i = 0; i < vReportArray.length; ++i) {
            this.reportList.add(vReportArray[i]);
        }
    }

    public void setReport(List<Report> vReportList) {
        this.reportList.clear();
        this.reportList.addAll(vReportList);
    }

    public void setReportCollection(List<Report> reportList) {
        this.reportList = reportList;
    }
}

