/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.activemq.auth;

import java.net.InetAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.jaas.GroupPrincipal;
import org.opennms.netmgt.activemq.auth.OpenNMSJaasAuthenticationBroker;

public class OpenNMSJaasBrokerPlugin
implements BrokerPlugin {
    private List<String> trustedHosts = new ArrayList<String>();
    private String usernameForTrustedHosts = "admin";
    private List<String> groupsForTrustedHosts = Arrays.asList("admin");

    public Broker installPlugin(Broker broker) throws Exception {
        HashSet<InetAddress> trustedHostAddresses = new HashSet<InetAddress>();
        for (String trustedHost : this.trustedHosts) {
            trustedHostAddresses.add(InetAddress.getByName(trustedHost));
        }
        Set<Principal> principalsForTrustedHosts = this.groupsForTrustedHosts.stream().map(g -> new GroupPrincipal(g)).collect(Collectors.toSet());
        return new OpenNMSJaasAuthenticationBroker(broker, trustedHostAddresses, this.usernameForTrustedHosts, principalsForTrustedHosts);
    }

    public List<String> getTrustedHosts() {
        return this.trustedHosts;
    }

    public void setTrustedHosts(List<String> trustedHosts) {
        this.trustedHosts = trustedHosts;
    }

    public String getUsernameForTrustedHosts() {
        return this.usernameForTrustedHosts;
    }

    public void setUsernameForTrustedHosts(String usernameForTrustedHosts) {
        this.usernameForTrustedHosts = usernameForTrustedHosts;
    }

    public List<String> getGroupsForTrustedHosts() {
        return this.groupsForTrustedHosts;
    }

    public void setGroupsForTrustedHosts(List<String> groupsForTrustedHosts) {
        this.groupsForTrustedHosts = groupsForTrustedHosts;
    }
}

