/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Encoder;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Object;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ASN1OctetString
extends ASN1Object {
    private byte[] content;
    public static final int TAG = 4;
    protected static final ASN1Identifier ID = new ASN1Identifier(0, false, 4);

    public ASN1OctetString(byte[] byArray) {
        super(ID);
        this.content = byArray;
    }

    public ASN1OctetString(String string) {
        super(ID);
        try {
            this.content = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public ASN1OctetString(ASN1Decoder aSN1Decoder, InputStream inputStream, int n) throws IOException {
        super(ID);
        this.content = n > 0 ? (byte[])aSN1Decoder.decodeOctetString(inputStream, n) : new byte[]{};
    }

    public final void encode(ASN1Encoder aSN1Encoder, OutputStream outputStream) throws IOException {
        aSN1Encoder.encode(this, outputStream);
    }

    public final byte[] byteValue() {
        return this.content;
    }

    public final String stringValue() {
        String string = null;
        try {
            string = new String(this.content, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
        return string;
    }

    public String toString() {
        return super.toString() + "OCTET STRING: " + this.stringValue();
    }
}

