/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmpAsset.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.snmpAsset.adapter.AssetField;

@XmlRootElement(name="package")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Package
implements Serializable {
    private static final long serialVersionUID = 3805218232933347563L;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlElement(name="sysoid")
    private String sysoid;
    @XmlElement(name="sysoidMask")
    private String sysoidMask;
    @XmlElement(name="assetField", required=true)
    private List<AssetField> assetFieldList = new ArrayList<AssetField>();

    public void addAssetField(AssetField vAssetField) throws IndexOutOfBoundsException {
        this.assetFieldList.add(vAssetField);
    }

    public void addAssetField(int index, AssetField vAssetField) throws IndexOutOfBoundsException {
        this.assetFieldList.add(index, vAssetField);
    }

    public Enumeration<AssetField> enumerateAssetField() {
        return Collections.enumeration(this.assetFieldList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Package) {
            Package temp = (Package)obj;
            boolean equals = Objects.equals(temp.name, this.name) && Objects.equals(temp.sysoid, this.sysoid) && Objects.equals(temp.sysoidMask, this.sysoidMask) && Objects.equals(temp.assetFieldList, this.assetFieldList);
            return equals;
        }
        return false;
    }

    public AssetField getAssetField(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.assetFieldList.size()) {
            throw new IndexOutOfBoundsException("getAssetField: Index value '" + index + "' not in range [0.." + (this.assetFieldList.size() - 1) + "]");
        }
        return this.assetFieldList.get(index);
    }

    public AssetField[] getAssetField() {
        AssetField[] array = new AssetField[]{};
        return this.assetFieldList.toArray(array);
    }

    public List<AssetField> getAssetFieldCollection() {
        return this.assetFieldList;
    }

    public int getAssetFieldCount() {
        return this.assetFieldList.size();
    }

    public String getName() {
        return this.name;
    }

    public String getSysoid() {
        return this.sysoid;
    }

    public String getSysoidMask() {
        return this.sysoidMask;
    }

    public int hashCode() {
        int hash = Objects.hash(this.name, this.sysoid, this.sysoidMask, this.assetFieldList);
        return hash;
    }

    public Iterator<AssetField> iterateAssetField() {
        return this.assetFieldList.iterator();
    }

    public void removeAllAssetField() {
        this.assetFieldList.clear();
    }

    public boolean removeAssetField(AssetField vAssetField) {
        boolean removed = this.assetFieldList.remove(vAssetField);
        return removed;
    }

    public AssetField removeAssetFieldAt(int index) {
        AssetField obj = this.assetFieldList.remove(index);
        return obj;
    }

    public void setAssetField(int index, AssetField vAssetField) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.assetFieldList.size()) {
            throw new IndexOutOfBoundsException("setAssetField: Index value '" + index + "' not in range [0.." + (this.assetFieldList.size() - 1) + "]");
        }
        this.assetFieldList.set(index, vAssetField);
    }

    public void setAssetField(AssetField[] vAssetFieldArray) {
        this.assetFieldList.clear();
        for (int i = 0; i < vAssetFieldArray.length; ++i) {
            this.assetFieldList.add(vAssetFieldArray[i]);
        }
    }

    public void setAssetField(List<AssetField> vAssetFieldList) {
        this.assetFieldList.clear();
        this.assetFieldList.addAll(vAssetFieldList);
    }

    public void setAssetFieldCollection(List<AssetField> assetFieldList) {
        this.assetFieldList = assetFieldList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSysoid(String sysoid) {
        this.sysoid = sysoid;
    }

    public void setSysoidMask(String sysoidMask) {
        this.sysoidMask = sysoidMask;
    }
}

