/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.ByteArrayWindow;
import org.snmp4j.smi.OctetString;

public abstract class AuthGeneric
implements AuthenticationProtocol {
    private static final LogAdapter logger = LogFactory.getLogger(AuthGeneric.class);
    public static int HMAC_BLOCK_SIZE = 64;
    private static int DEFAULT_AUTHENTICATION_CODE_LENGTH = 12;
    protected int hmacBlockSize = HMAC_BLOCK_SIZE;
    private int authenticationCodeLength = DEFAULT_AUTHENTICATION_CODE_LENGTH;
    private final int digestLength;
    private final String protoName;

    public AuthGeneric(String protoName, int digestLength) {
        this.protoName = protoName;
        this.digestLength = digestLength;
    }

    public AuthGeneric(String protoName, int digestLength, int authenticationCodeLength) {
        this(protoName, digestLength);
        this.authenticationCodeLength = authenticationCodeLength;
    }

    public AuthGeneric(String protoName, int digestLength, int authenticationCodeLength, int hmacBlockSize) {
        this(protoName, digestLength, authenticationCodeLength);
        this.hmacBlockSize = hmacBlockSize;
    }

    @Override
    public int getDigestLength() {
        return this.digestLength;
    }

    @Override
    public int getAuthenticationCodeLength() {
        return this.authenticationCodeLength;
    }

    protected MessageDigest getDigestObject() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(this.protoName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(this.protoName + " not supported in this VM.");
        }
        return md;
    }

    @Override
    public boolean isSupported() {
        try {
            MessageDigest.getInstance(this.protoName);
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    @Override
    public boolean authenticate(byte[] authenticationKey, byte[] message, int messageOffset, int messageLength, ByteArrayWindow digest) {
        int i;
        MessageDigest md = this.getDigestObject();
        byte[] authKey = authenticationKey;
        byte[] k_ipad = new byte[this.hmacBlockSize];
        byte[] k_opad = new byte[this.hmacBlockSize];
        for (i = 0; i < this.authenticationCodeLength; ++i) {
            digest.set(i, (byte)0);
        }
        if (authKey.length > this.hmacBlockSize) {
            authKey = md.digest(authenticationKey);
        }
        for (i = 0; i < authKey.length; ++i) {
            k_ipad[i] = (byte)(authKey[i] ^ 0x36);
            k_opad[i] = (byte)(authKey[i] ^ 0x5C);
        }
        for (i = authKey.length; i < this.hmacBlockSize; ++i) {
            k_ipad[i] = 54;
            k_opad[i] = 92;
        }
        md.update(k_ipad);
        md.update(message, messageOffset, messageLength);
        byte[] newDigest = md.digest();
        md.reset();
        md.update(k_opad);
        md.update(newDigest);
        newDigest = md.digest();
        for (i = 0; i < this.authenticationCodeLength; ++i) {
            digest.set(i, newDigest[i]);
        }
        return true;
    }

    @Override
    public boolean isAuthentic(byte[] authenticationKey, byte[] message, int messageOffset, int messageLength, ByteArrayWindow digest) {
        ByteArrayWindow origDigest = new ByteArrayWindow(new byte[this.authenticationCodeLength], 0, this.authenticationCodeLength);
        System.arraycopy(digest.getValue(), digest.getOffset(), origDigest.getValue(), 0, this.authenticationCodeLength);
        if (!this.authenticate(authenticationKey, message, messageOffset, messageLength, digest)) {
            return false;
        }
        return digest.equals(origDigest, this.authenticationCodeLength);
    }

    @Override
    public byte[] changeDelta(byte[] oldKey, byte[] newKey, byte[] random) {
        MessageDigest hash = this.getDigestObject();
        int digestLength = hash.getDigestLength();
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)(this.protoName + "oldKey: " + new OctetString(oldKey).toHexString())));
            logger.debug((Serializable)((Object)(this.protoName + "newKey: " + new OctetString(newKey).toHexString())));
            logger.debug((Serializable)((Object)(this.protoName + "random: " + new OctetString(random).toHexString())));
        }
        int iterations = (oldKey.length - 1) / hash.getDigestLength();
        OctetString tmp = new OctetString(oldKey);
        OctetString delta = new OctetString();
        for (int k = 0; k < iterations; ++k) {
            tmp.append(random);
            hash.update(tmp.getValue());
            tmp.setValue(hash.digest());
            delta.append(new byte[digestLength]);
            for (int kk = 0; kk < digestLength; ++kk) {
                delta.set(k * digestLength + kk, (byte)(tmp.get(kk) ^ newKey[k * digestLength + kk]));
            }
        }
        tmp.append(random);
        hash.update(tmp.getValue());
        tmp = new OctetString(hash.digest(), 0, oldKey.length - delta.length());
        for (int j = 0; j < tmp.length(); ++j) {
            tmp.set(j, (byte)(tmp.get(j) ^ newKey[iterations * digestLength + j]));
        }
        byte[] keyChange = new byte[random.length + delta.length() + tmp.length()];
        System.arraycopy(random, 0, keyChange, 0, random.length);
        System.arraycopy(delta.getValue(), 0, keyChange, random.length, delta.length());
        System.arraycopy(tmp.getValue(), 0, keyChange, random.length + delta.length(), tmp.length());
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)(this.protoName + "keyChange:" + new OctetString(keyChange).toHexString())));
        }
        return keyChange;
    }

    @Override
    public byte[] passwordToKey(OctetString passwordString, byte[] engineID) {
        MessageDigest md = this.getDigestObject();
        byte[] buf = new byte[this.hmacBlockSize];
        int password_index = 0;
        byte[] password = passwordString.getValue();
        for (int count = 0; count < 0x100000; count += this.hmacBlockSize) {
            for (int i = 0; i < this.hmacBlockSize; ++i) {
                buf[i] = password[password_index++ % password.length];
            }
            md.update(buf);
        }
        byte[] digest = md.digest();
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)(this.protoName + "First digest: " + new OctetString(digest).toHexString())));
        }
        md.reset();
        md.update(digest);
        md.update(engineID);
        md.update(digest);
        digest = md.digest();
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)(this.protoName + "localized key: " + new OctetString(digest).toHexString())));
        }
        return digest;
    }

    @Override
    public byte[] hash(byte[] data) {
        MessageDigest md = this.getDigestObject();
        md.update(data);
        return md.digest();
    }

    @Override
    public byte[] hash(byte[] data, int offset, int length) {
        MessageDigest md = this.getDigestObject();
        md.update(data, offset, length);
        return md.digest();
    }
}

