/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.vmmgr.InvalidDataSourceException;
import org.opennms.netmgt.vmmgr.MissingDataSourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseChecker {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseChecker.class);
    private static List<String> m_required = new ArrayList<String>();
    private static List<String> m_optional = new ArrayList<String>();
    private Map<String, JdbcDataSource> m_dataSources = new HashMap<String, JdbcDataSource>();

    protected DatabaseChecker(String configFile) throws IOException, MarshalException, ValidationException, ClassNotFoundException {
        DataSourceConfiguration database;
        try {
            database = (DataSourceConfiguration)JaxbUtils.unmarshal(DataSourceConfiguration.class, (File)new File(configFile));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to unmarshal: %s Cause: %s", configFile, e.getMessage()), e);
        }
        for (JdbcDataSource dataSource : database.getJdbcDataSourceCollection()) {
            this.m_dataSources.put(dataSource.getName(), dataSource);
        }
    }

    protected DatabaseChecker() throws IOException, MarshalException, ValidationException, ClassNotFoundException {
        this(ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME).getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws MissingDataSourceException, InvalidDataSourceException {
        boolean dataSourcesFound = true;
        for (String string : m_required) {
            if (this.m_dataSources.containsKey(string)) continue;
            LOG.error("Required data source '{}' is missing from opennms-datasources.xml", (Object)string);
            dataSourcesFound = false;
        }
        if (!dataSourcesFound) {
            throw new MissingDataSourceException("OpenNMS is missing one or more data sources required for startup.");
        }
        for (String string : m_optional) {
            if (this.m_dataSources.containsKey(string)) continue;
            LOG.info("Data source '{}' is missing from opennms-datasources.xml", (Object)string);
        }
        for (JdbcDataSource jdbcDataSource : this.m_dataSources.values()) {
            Connection connection = null;
            try {
                String name = jdbcDataSource.getName();
                if (!m_required.contains(name) && !m_optional.contains(name)) {
                    LOG.warn("Unknown datasource '{}' was found.", (Object)name);
                }
                try {
                    Class.forName(jdbcDataSource.getClassName());
                    connection = DriverManager.getConnection(jdbcDataSource.getUrl(), jdbcDataSource.getUserName(), jdbcDataSource.getPassword());
                }
                catch (Throwable t) {
                    String errorMessage = "Unable to connect to data source '{}' at URL '{}' with username '{}', check opennms-datasources.xml and your database permissions.";
                    if (m_required.contains(name)) {
                        LOG.error("Unable to connect to data source '{}' at URL '{}' with username '{}', check opennms-datasources.xml and your database permissions.", new Object[]{name, jdbcDataSource.getUrl(), jdbcDataSource.getUserName()});
                        throw new InvalidDataSourceException("Data source '" + name + "' failed.", t);
                    }
                    LOG.warn("Unable to connect to data source '{}' at URL '{}' with username '{}', check opennms-datasources.xml and your database permissions.", new Object[]{name, jdbcDataSource.getUrl(), jdbcDataSource.getUserName()});
                }
            }
            finally {
                if (connection == null) continue;
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        DatabaseChecker checker = new DatabaseChecker();
        checker.check();
    }

    static {
        m_required.add("opennms");
        m_optional.add("opennms-admin");
    }
}

