/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.common.LongRef;
import kafka.common.TopicAndPartition;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.message.BrokerCompressionCodec$;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.message.ValidationAndOffsetAssignResult;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.BrokerTopicStats$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.RecordBatchTooLargeException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r\rg\u0001B\u0001\u0003\u0001\u001d\u00111\u0001T8h\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0004\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u001diW\r\u001e:jGNL!!\u0007\f\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\r!\u0017N]\u000b\u0002;A\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0003S>T\u0011AI\u0001\u0005U\u00064\u0018-\u0003\u0002%?\t!a)\u001b7f\u0011!1\u0003A!A!\u0002\u0013i\u0012\u0001\u00023je\u0002B\u0001\u0002\u000b\u0001\u0003\u0002\u0004%\t!K\u0001\u0007G>tg-[4\u0016\u0003)\u0002\"a\u000b\u0017\u000e\u0003\tI!!\f\u0002\u0003\u00131{wmQ8oM&<\u0007\u0002C\u0018\u0001\u0005\u0003\u0007I\u0011\u0001\u0019\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u00022iA\u0011\u0011BM\u0005\u0003g)\u0011A!\u00168ji\"9QGLA\u0001\u0002\u0004Q\u0013a\u0001=%c!Aq\u0007\u0001B\u0001B\u0003&!&A\u0004d_:4\u0017n\u001a\u0011)\u0005YJ\u0004CA\u0005;\u0013\tY$B\u0001\u0005w_2\fG/\u001b7f\u0011!i\u0004A!a\u0001\n\u0003q\u0014!\u0004:fG>4XM]=Q_&tG/F\u0001@!\tI\u0001)\u0003\u0002B\u0015\t!Aj\u001c8h\u0011!\u0019\u0005A!a\u0001\n\u0003!\u0015!\u0005:fG>4XM]=Q_&tGo\u0018\u0013fcR\u0011\u0011'\u0012\u0005\bk\t\u000b\t\u00111\u0001@\u0011!9\u0005A!A!B\u0013y\u0014A\u0004:fG>4XM]=Q_&tG\u000f\t\u0015\u0003\rfB\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IaS\u0001\ng\u000eDW\rZ;mKJ\u0004\"a\u0004'\n\u00055\u0003\"!C*dQ\u0016$W\u000f\\3s\u0011!y\u0005A!A!\u0002\u0013\u0001\u0016\u0001\u0002;j[\u0016\u0004\"aD)\n\u0005I\u0003\"\u0001\u0002+j[\u0016DQ\u0001\u0016\u0001\u0005\u0002U\u000ba\u0001P5oSRtDC\u0002,X1fS6\f\u0005\u0002,\u0001!)1d\u0015a\u0001;!)\u0001f\u0015a\u0001U!9Qh\u0015I\u0001\u0002\u0004y\u0004\"\u0002&T\u0001\u0004Y\u0005bB(T!\u0003\u0005\r\u0001\u0015\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0003\u0011awnY6\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!AY\u0011\u0002\t1\fgnZ\u0005\u0003I\u0006\u0014aa\u00142kK\u000e$\bB\u00024\u0001A\u0003%q,A\u0003m_\u000e\\\u0007\u0005C\u0004i\u0001\t\u0007I\u0011B5\u0002\u001f1\f7\u000f\u001e4mkNDW\r\u001a+j[\u0016,\u0012A\u001b\t\u0003WJl\u0011\u0001\u001c\u0006\u0003[:\fa!\u0019;p[&\u001c'BA8q\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003c\u0006\nA!\u001e;jY&\u00111\u000f\u001c\u0002\u000b\u0003R|W.[2M_:<\u0007BB;\u0001A\u0003%!.\u0001\tmCN$h\r\\;tQ\u0016$G+[7fA!)q\u000f\u0001C\u0001q\u0006a\u0011N\\5u\r&dWmU5{KR\t\u0011\u0010\u0005\u0002\nu&\u00111P\u0003\u0002\u0004\u0013:$\bbB?\u0001\u0005\u0004%\tAP\u0001\u0002i\"1q\u0010\u0001Q\u0001\n}\n!\u0001\u001e\u0011\t\u0013\u0005\r\u0001A1A\u0005\n\u0005\u0015\u0011\u0001C:fO6,g\u000e^:\u0016\u0005\u0005\u001d\u0001\u0003CA\u0005\u0003\u0017\ty!a\u0005\u000e\u00039L1!!\u0004o\u0005Y\u0019uN\\2veJ,g\u000e\u001e(bm&<\u0017M\u00197f\u001b\u0006\u0004\bc\u00011\u0002\u0012%\u0011\u0011)\u0019\t\u0004W\u0005U\u0011bAA\f\u0005\tQAj\\4TK\u001elWM\u001c;\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u000f\t\u0011b]3h[\u0016tGo\u001d\u0011\t\u0013\u0005}\u0001\u00011A\u0005\u0002\u0005\u0005\u0012A\u00058fqR|eMZ:fi6+G/\u00193bi\u0006,\"!a\t\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b\u0005\u0003\u0019\u0019XM\u001d<fe&!\u0011QFA\u0014\u0005EaunZ(gMN,G/T3uC\u0012\fG/\u0019\u0005\n\u0003c\u0001\u0001\u0019!C\u0001\u0003g\taC\\3yi>3gm]3u\u001b\u0016$\u0018\rZ1uC~#S-\u001d\u000b\u0004c\u0005U\u0002\"C\u001b\u00020\u0005\u0005\t\u0019AA\u0012\u0011!\tI\u0004\u0001Q!\n\u0005\r\u0012a\u00058fqR|eMZ:fi6+G/\u00193bi\u0006\u0004\u0003fAA\u001cs!I\u0011q\b\u0001C\u0002\u0013\u0005\u0011\u0011I\u0001\u0012i>\u0004\u0018nY!oIB\u000b'\u000f^5uS>tWCAA\"!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%\t\u000511m\\7n_:LA!!\u0014\u0002H\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u0007\n!\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8oA!I\u0011Q\u000b\u0001C\u0002\u0013\u0005\u0011qK\u0001\u0005i\u0006<7/\u0006\u0002\u0002ZAA\u00111LA3\u0003S\nI'\u0004\u0002\u0002^)!\u0011qLA1\u0003%IW.\\;uC\ndWMC\u0002\u0002d)\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9'!\u0018\u0003\u00075\u000b\u0007\u000fE\u0002a\u0003WJ1!!\u001cb\u0005\u0019\u0019FO]5oO\"A\u0011\u0011\u000f\u0001!\u0002\u0013\tI&A\u0003uC\u001e\u001c\b\u0005C\u0004\u0002v\u0001!\t!a\u001e\u0002\t9\fW.Z\u000b\u0003\u0003SBq!a\u001f\u0001\t\u0013\ti(\u0001\u0007m_\u0006$7+Z4nK:$8\u000fF\u00012\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007\u000b!#\u001e9eCR,Gj\\4F]\u0012|eMZ:fiR\u0019\u0011'!\"\t\u000f\u0005\u001d\u0015q\u0010a\u0001\u007f\u0005iQ.Z:tC\u001e,wJ\u001a4tKRDq!a#\u0001\t\u0013\ti(\u0001\u0006sK\u000e|g/\u001a:M_\u001eDq!a$\u0001\t\u0013\t\t*\u0001\u000biCN\u001cE.Z1o'\",H\u000fZ8x]\u001aKG.\u001a\u000b\u0003\u0003'\u00032!CAK\u0013\r\t9J\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\tY\n\u0001C\u0001\u0003;\u000b\u0001C\\;nE\u0016\u0014xJZ*fO6,g\u000e^:\u0016\u0003eDq!!)\u0001\t\u0003\ti(A\u0003dY>\u001cX\rC\u0004\u0002&\u0002!\t!a*\u0002\r\u0005\u0004\b/\u001a8e)\u0019\tI+a,\u0002@B\u00191&a+\n\u0007\u00055&AA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\t\u0003c\u000b\u0019\u000b1\u0001\u00024\u0006AQ.Z:tC\u001e,7\u000f\u0005\u0003\u00026\u0006mVBAA\\\u0015\r\tI\fB\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\ti,a.\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3u\u0011)\t\t-a)\u0011\u0002\u0003\u0007\u00111S\u0001\u000eCN\u001c\u0018n\u001a8PM\u001a\u001cX\r^:\t\u000f\u0005\u0015\u0007\u0001\"\u0003\u0002H\u0006a\u0012M\\1msj,\u0017I\u001c3WC2LG-\u0019;f\u001b\u0016\u001c8/Y4f'\u0016$H\u0003BAU\u0003\u0013D\u0001\"!-\u0002D\u0002\u0007\u00111\u0017\u0005\b\u0003\u001b\u0004A\u0011BAh\u0003A!(/[7J]Z\fG.\u001b3CsR,7\u000f\u0006\u0004\u00024\u0006E\u00171\u001b\u0005\t\u0003c\u000bY\r1\u0001\u00024\"A\u0011Q[Af\u0001\u0004\tI+\u0001\u0003j]\u001a|\u0007bBAm\u0001\u0011\u0005\u00111\\\u0001\u0005e\u0016\fG\r\u0006\u0006\u0002^\u0006\r\u0018q]Av\u0003k\u0004B!!\n\u0002`&!\u0011\u0011]A\u0014\u000551U\r^2i\t\u0006$\u0018-\u00138g_\"9\u0011Q]Al\u0001\u0004y\u0014aC:uCJ$xJ\u001a4tKRDq!!;\u0002X\u0002\u0007\u00110A\u0005nCbdUM\\4uQ\"Q\u0011Q^Al!\u0003\u0005\r!a<\u0002\u00135\f\u0007p\u00144gg\u0016$\b\u0003B\u0005\u0002r~J1!a=\u000b\u0005\u0019y\u0005\u000f^5p]\"Q\u0011q_Al!\u0003\u0005\r!a%\u0002\u001b5Lgn\u00148f\u001b\u0016\u001c8/Y4f\u0011\u001d\tY\u0010\u0001C\u0001\u0003{\fqCZ3uG\"|eMZ:fiN\u0014\u0015\u0010V5nKN$\u0018-\u001c9\u0015\t\u0005}(q\u0001\t\u0006\u0013\u0005E(\u0011\u0001\t\u0004W\t\r\u0011b\u0001B\u0003\u0005\tyA+[7fgR\fW\u000e](gMN,G\u000fC\u0004\u0003\n\u0005e\b\u0019A \u0002\u001fQ\f'oZ3u)&lWm\u001d;b[BDqA!\u0004\u0001\t\u0003\u0011y!A\fd_:4XM\u001d;U_>3gm]3u\u001b\u0016$\u0018\rZ1uCR!\u00111\u0005B\t\u0011\u001d\u0011\u0019Ba\u0003A\u0002}\naa\u001c4gg\u0016$\bb\u0002B\f\u0001\u0011%!\u0011D\u0001\u0012I\u0016dW\r^3PY\u0012\u001cVmZ7f]R\u001cHcA=\u0003\u001c!A!Q\u0004B\u000b\u0001\u0004\u0011y\"A\u0005qe\u0016$\u0017nY1uKB9\u0011B!\t\u0002\u0014\u0005M\u0015b\u0001B\u0012\u0015\tIa)\u001e8di&|g.\r\u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0003E!W\r\\3uC\ndWmU3h[\u0016tGo\u001d\u000b\u0005\u0005W\u0011\u0019\u0004\u0005\u0004\u0003.\t=\u00121C\u0007\u0003\u0003CJAA!\r\u0002b\tA\u0011\n^3sC\ndW\r\u0003\u0005\u0003\u001e\t\u0015\u0002\u0019\u0001B\u0010\u0011\u0019\u00119\u0002\u0001C\u0001q\"1!\u0011\b\u0001\u0005\na\f\u0001\u0005Z3mKR,'+\u001a;f]&|g.T:Ce\u0016\f7\r[3e'\u0016<W.\u001a8ug\"1!Q\b\u0001\u0005\na\f1\u0005Z3mKR,'+\u001a;f]RLwN\\*ju\u0016\u0014%/Z1dQ\u0016$7+Z4nK:$8\u000f\u0003\u0004\u0003B\u0001!\tAP\u0001\u0005g&TX\r\u0003\u0004\u0003F\u0001!\tAP\u0001\u000fY><7\u000b^1si>3gm]3u\u0011\u001d\u0011I\u0005\u0001C\u0001\u0003C\tA\u0003\\8h\u000b:$wJ\u001a4tKRlU\r^1eCR\f\u0007B\u0002B'\u0001\u0011\u0005a(\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000fC\u0004\u0003R\u0001!IAa\u0015\u0002\u00135\f\u0017PY3S_2dGCBA\n\u0005+\u0012I\u0006C\u0004\u0003X\t=\u0003\u0019A=\u0002\u00195,7o]1hKN\u001c\u0016N_3\t\u000f\tm#q\na\u0001\u007f\u00051R.\u0019=US6,7\u000f^1na&sW*Z:tC\u001e,7\u000fC\u0004\u0003`\u0001!\tA!\u0019\u0002\tI|G\u000e\u001c\u000b\u0003\u0003'AqA!\u001a\u0001\t\u0003\u00119'A\tv]\u001adWo\u001d5fI6+7o]1hKN$\u0012a\u0010\u0005\b\u0005W\u0002A\u0011AA?\u0003\u00151G.^:i\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005_\"2!\rB9\u0011\u001d\u0011\u0019B!\u001cA\u0002}B\u0001B!\u001e\u0001\t\u0003\u0011\u0011QP\u0001\u0007I\u0016dW\r^3\t\u0011\te\u0004\u0001\"\u0001\u0003\u0005w\n!\u0002\u001e:v]\u000e\fG/\u001a+p)\r\t$Q\u0010\u0005\b\u0005\u007f\u00129\b1\u0001@\u00031!\u0018M]4fi>3gm]3u\u0011!\u0011\u0019\t\u0001C\u0001\u0005\t\u0015\u0015a\u0006;sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!u)\r\t$q\u0011\u0005\b\u0005\u0013\u0013\t\t1\u0001@\u0003%qWm^(gMN,G\u000fC\u0004\u0003\u000e\u0002!\tAa\u001a\u0002\u001b1\f7\u000f\u001e$mkNDG+[7f\u0011\u001d\u0011\t\n\u0001C\u0001\u0005'\u000bQ\"Y2uSZ,7+Z4nK:$XCAA\n\u0011\u001d\u00119\n\u0001C\u0001\u00053\u000b1\u0002\\8h'\u0016<W.\u001a8ugV\u0011!1\u0014\t\u0007\u0005;\u0013i+a\u0005\u000f\t\t}%\u0011\u0016\b\u0005\u0005C\u00139+\u0004\u0002\u0003$*\u0019!Q\u0015\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011b\u0001BV\u0015\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0019\u0005_S1Aa+\u000b\u0011\u001d\u00119\n\u0001C\u0001\u0005g#bAa'\u00036\ne\u0006b\u0002B\\\u0005c\u0003\raP\u0001\u0005MJ|W\u000eC\u0004\u0003<\nE\u0006\u0019A \u0002\u0005Q|\u0007b\u0002B`\u0001\u0011\u0005#\u0011Y\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u000e\u0005\b\u0005\u000b\u0004A\u0011\u0002Bd\u00035!W\r\\3uKN+w-\\3oiR\u0019\u0011G!3\t\u0011\t-'1\u0019a\u0001\u0003'\tqa]3h[\u0016tG\u000fC\u0004\u0003P\u0002!IA!5\u0002%\u0005\u001c\u0018P\\2EK2,G/Z*fO6,g\u000e\u001e\u000b\u0004c\tM\u0007\u0002\u0003Bf\u0005\u001b\u0004\r!a\u0005\t\u0011\t]\u0007\u0001\"\u0001\u0003\u00053\fqB]3qY\u0006\u001cWmU3h[\u0016tGo\u001d\u000b\bc\tm'q\u001cBu\u0011!\u0011iN!6A\u0002\u0005M\u0011A\u00038foN+w-\\3oi\"A!\u0011\u001dBk\u0001\u0004\u0011\u0019/A\u0006pY\u0012\u001cVmZ7f]R\u001c\bC\u0002B\u0017\u0005K\f\u0019\"\u0003\u0003\u0003h\u0006\u0005$aA*fc\"Q!1\u001eBk!\u0003\u0005\r!a%\u0002'%\u001c(+Z2pm\u0016\u0014X\rZ*xCB4\u0015\u000e\\3\t\u0011\t=\b\u0001\"\u0001\u0003\u0003{\n\u0001C]3n_Z,Gj\\4NKR\u0014\u0018nY:\t\u000f\tM\b\u0001\"\u0001\u0003v\u0006Q\u0011\r\u001a3TK\u001elWM\u001c;\u0015\t\u0005M!q\u001f\u0005\t\u0005\u0017\u0014\t\u00101\u0001\u0002\u0014!I!1 \u0001\u0012\u0002\u0013\u0005!Q`\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uII*\"Aa@+\t\u0005M5\u0011A\u0016\u0003\u0007\u0007\u0001Ba!\u0002\u0004\u00105\u00111q\u0001\u0006\u0005\u0007\u0013\u0019Y!A\u0005v]\u000eDWmY6fI*\u00191Q\u0002\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\u0012\r\u001d!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I1Q\u0003\u0001\u0012\u0002\u0013\u00051qC\u0001\u000fe\u0016\fG\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019IB\u000b\u0003\u0002p\u000e\u0005\u0001\"CB\u000f\u0001E\u0005I\u0011\u0001B\u007f\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIQB\u0011b!\t\u0001#\u0003%\tA!@\u00023I,\u0007\u000f\\1dKN+w-\\3oiN$C-\u001a4bk2$He\r\u0015\u0004\u0001\r\u0015\u0002cA\b\u0004(%\u00191\u0011\u0006\t\u0003\u0015QD'/Z1eg\u00064WmB\u0004\u0004.\tA\taa\f\u0002\u00071{w\rE\u0002,\u0007c1a!\u0001\u0002\t\u0002\rM2cAB\u0019\u0011!9Ak!\r\u0005\u0002\r]BCAB\u0018\u0011)\u0019Yd!\rC\u0002\u0013\u0005\u0011qO\u0001\u000e\u0019><g)\u001b7f'V4g-\u001b=\t\u0013\r}2\u0011\u0007Q\u0001\n\u0005%\u0014A\u0004'pO\u001aKG.Z*vM\u001aL\u0007\u0010\t\u0005\u000b\u0007\u0007\u001a\tD1A\u0005\u0002\u0005]\u0014aD%oI\u0016Dh)\u001b7f'V4g-\u001b=\t\u0013\r\u001d3\u0011\u0007Q\u0001\n\u0005%\u0014\u0001E%oI\u0016Dh)\u001b7f'V4g-\u001b=!\u0011)\u0019Ye!\rC\u0002\u0013\u0005\u0011qO\u0001\u0014)&lW-\u00138eKb4\u0015\u000e\\3Tk\u001a4\u0017\u000e\u001f\u0005\n\u0007\u001f\u001a\t\u0004)A\u0005\u0003S\nA\u0003V5nK&sG-\u001a=GS2,7+\u001e4gSb\u0004\u0003BCB*\u0007c\u0011\r\u0011\"\u0001\u0002x\u0005\tB)\u001a7fi\u0016$g)\u001b7f'V4g-\u001b=\t\u0013\r]3\u0011\u0007Q\u0001\n\u0005%\u0014A\u0005#fY\u0016$X\r\u001a$jY\u0016\u001cVO\u001a4jq\u0002B!ba\u0017\u00042\t\u0007I\u0011AA<\u0003E\u0019E.Z1oK\u00124\u0015\u000e\\3Tk\u001a4\u0017\u000e\u001f\u0005\n\u0007?\u001a\t\u0004)A\u0005\u0003S\n!c\u00117fC:,GMR5mKN+hMZ5yA!Q11MB\u0019\u0005\u0004%\t!a\u001e\u0002\u001dM;\u0018\r\u001d$jY\u0016\u001cVO\u001a4jq\"I1qMB\u0019A\u0003%\u0011\u0011N\u0001\u0010'^\f\u0007OR5mKN+hMZ5yA!Q11NB\u0019\u0005\u0004%\t!a\u001e\u0002#\rcW-\u00198TQV$Hm\\<o\r&dW\rC\u0005\u0004p\rE\u0002\u0015!\u0003\u0002j\u0005\u00112\t\\3b]NCW\u000f\u001e3po:4\u0015\u000e\\3!\u0011!\u0019\u0019h!\r\u0005\u0002\rU\u0014\u0001\u00074jY\u0016t\u0017-\\3Qe\u00164\u0017\u000e\u001f$s_6|eMZ:fiR!1qOBB!\u0011\u0019Iha \u000f\u0007%\u0019Y(C\u0002\u0004~)\ta\u0001\u0015:fI\u00164\u0017\u0002BA7\u0007\u0003S1a! \u000b\u0011\u001d\u0011\u0019b!\u001dA\u0002}B\u0001ba\"\u00042\u0011\u00051\u0011R\u0001\fY><g)\u001b7f]\u0006lW\rF\u0003\u001e\u0007\u0017\u001bi\t\u0003\u0004\u001c\u0007\u000b\u0003\r!\b\u0005\b\u0005'\u0019)\t1\u0001@\u0011!\u0019\tj!\r\u0005\u0002\rM\u0015!D5oI\u0016Dh)\u001b7f]\u0006lW\rF\u0003\u001e\u0007+\u001b9\n\u0003\u0004\u001c\u0007\u001f\u0003\r!\b\u0005\b\u0005'\u0019y\t1\u0001@\u0011!\u0019Yj!\r\u0005\u0002\ru\u0015!\u0005;j[\u0016Le\u000eZ3y\r&dWM\\1nKR)Qda(\u0004\"\"11d!'A\u0002uAqAa\u0005\u0004\u001a\u0002\u0007q\b\u0003\u0005\u0004&\u000eEB\u0011ABT\u0003]\u0001\u0018M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lW\r\u0006\u0003\u0002D\r%\u0006BB\u000e\u0004$\u0002\u0007Q\u0004\u0003\u0005\u0004.\u000eEB\u0011ABX\u00039!\bN]8x\u000bb\u001cW\r\u001d;j_:$2!MBY\u0011\u0019Y21\u0016a\u0001;!Q1QWB\u0019#\u0003%\taa.\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019ILK\u0002@\u0007\u0003A!b!0\u00042E\u0005I\u0011AB`\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u00111\u0011\u0019\u0016\u0004!\u000e\u0005\u0001")
public class Log
implements KafkaMetricsGroup {
    private final File dir;
    private volatile LogConfig config;
    private volatile long recoveryPoint;
    private final Scheduler scheduler;
    public final Time kafka$log$Log$$time;
    private final Object lock;
    private final AtomicLong lastflushedTime;
    private final long t;
    private final ConcurrentNavigableMap<Long, LogSegment> kafka$log$Log$$segments;
    private volatile LogOffsetMetadata nextOffsetMetadata;
    private final TopicAndPartition topicAndPartition;
    private final scala.collection.immutable.Map<String, String> tags;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return Log$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$3() {
        return Log$.MODULE$.$lessinit$greater$default$3();
    }

    public static void throwException(File file) {
        Log$.MODULE$.throwException(file);
    }

    public static TopicAndPartition parseTopicPartitionName(File file) {
        return Log$.MODULE$.parseTopicPartitionName(file);
    }

    public static File timeIndexFilename(File file, long l) {
        return Log$.MODULE$.timeIndexFilename(file, l);
    }

    public static File indexFilename(File file, long l) {
        return Log$.MODULE$.indexFilename(file, l);
    }

    public static File logFilename(File file, long l) {
        return Log$.MODULE$.logFilename(file, l);
    }

    public static String filenamePrefixFromOffset(long l) {
        return Log$.MODULE$.filenamePrefixFromOffset(l);
    }

    public static String CleanShutdownFile() {
        return Log$.MODULE$.CleanShutdownFile();
    }

    public static String SwapFileSuffix() {
        return Log$.MODULE$.SwapFileSuffix();
    }

    public static String CleanedFileSuffix() {
        return Log$.MODULE$.CleanedFileSuffix();
    }

    public static String DeletedFileSuffix() {
        return Log$.MODULE$.DeletedFileSuffix();
    }

    public static String TimeIndexFileSuffix() {
        return Log$.MODULE$.TimeIndexFileSuffix();
    }

    public static String IndexFileSuffix() {
        return Log$.MODULE$.IndexFileSuffix();
    }

    public static String LogFileSuffix() {
        return Log$.MODULE$.LogFileSuffix();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Log log = this;
        synchronized (log) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File dir() {
        return this.dir;
    }

    public LogConfig config() {
        return this.config;
    }

    public void config_$eq(LogConfig x$1) {
        this.config = x$1;
    }

    public long recoveryPoint() {
        return this.recoveryPoint;
    }

    public void recoveryPoint_$eq(long x$1) {
        this.recoveryPoint = x$1;
    }

    private Object lock() {
        return this.lock;
    }

    private AtomicLong lastflushedTime() {
        return this.lastflushedTime;
    }

    public int initFileSize() {
        return Predef$.MODULE$.Boolean2boolean(this.config().preallocate()) ? Predef$.MODULE$.Integer2int(this.config().segmentSize()) : 0;
    }

    public long t() {
        return this.t;
    }

    public ConcurrentNavigableMap<Long, LogSegment> kafka$log$Log$$segments() {
        return this.kafka$log$Log$$segments;
    }

    public LogOffsetMetadata nextOffsetMetadata() {
        return this.nextOffsetMetadata;
    }

    public void nextOffsetMetadata_$eq(LogOffsetMetadata x$1) {
        this.nextOffsetMetadata = x$1;
    }

    public TopicAndPartition topicAndPartition() {
        return this.topicAndPartition;
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    public String name() {
        return this.dir().getName();
    }

    private void loadSegments() {
        this.dir().mkdirs();
        ObjectRef swapFiles = new ObjectRef((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.isFile();
            }
        }).foreach((Function1)new Serializable(this, swapFiles){
            public static final long serialVersionUID = 0L;
            private final ObjectRef swapFiles$1;

            public final Object apply(File file) {
                if (file.canRead()) {
                    Boolean bl;
                    String filename = file.getName();
                    if (filename.endsWith(Log$.MODULE$.DeletedFileSuffix()) || filename.endsWith(Log$.MODULE$.CleanedFileSuffix())) {
                        bl = BoxesRunTime.boxToBoolean((boolean)file.delete());
                    } else if (filename.endsWith(Log$.MODULE$.SwapFileSuffix())) {
                        File baseName = new File(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.SwapFileSuffix(), ""));
                        if (baseName.getPath().endsWith(Log$.MODULE$.IndexFileSuffix())) {
                            bl = BoxesRunTime.boxToBoolean((boolean)file.delete());
                        } else if (baseName.getPath().endsWith(Log$.MODULE$.LogFileSuffix())) {
                            File index = new File(CoreUtils$.MODULE$.replaceSuffix(baseName.getPath(), Log$.MODULE$.LogFileSuffix(), Log$.MODULE$.IndexFileSuffix()));
                            index.delete();
                            this.swapFiles$1.elem = (Set)((Set)this.swapFiles$1.elem).$plus((Object)file);
                            bl = BoxedUnit.UNIT;
                        } else {
                            bl = BoxedUnit.UNIT;
                        }
                    } else {
                        bl = BoxedUnit.UNIT;
                    }
                    return bl;
                }
                throw new IOException(new StringBuilder().append((Object)"Could not read file ").append((Object)file).toString());
            }
            {
                this.swapFiles$1 = swapFiles$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.isFile();
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(File file) {
                Object object;
                Object object2;
                String filename = file.getName();
                if (filename.endsWith(Log$.MODULE$.IndexFileSuffix()) || filename.endsWith(Log$.MODULE$.TimeIndexFileSuffix())) {
                    File logFile;
                    File file2 = logFile = filename.endsWith(Log$.MODULE$.TimeIndexFileSuffix()) ? new File(file.getAbsolutePath().replace(Log$.MODULE$.TimeIndexFileSuffix(), Log$.MODULE$.LogFileSuffix())) : new File(file.getAbsolutePath().replace(Log$.MODULE$.IndexFileSuffix(), Log$.MODULE$.LogFileSuffix()));
                    if (logFile.exists()) {
                        object2 = BoxedUnit.UNIT;
                        return object2;
                    }
                    this.$outer.warn((Function0<String>)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final File file$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Found an orphaned index file, %s, with no corresponding log file.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1.getAbsolutePath()}));
                        }
                        {
                            this.file$1 = file$1;
                        }
                    });
                    object2 = BoxesRunTime.boxToBoolean((boolean)file.delete());
                    return object2;
                }
                if (!filename.endsWith(Log$.MODULE$.LogFileSuffix())) {
                    object2 = BoxedUnit.UNIT;
                    return object2;
                }
                long start = new StringOps(Predef$.MODULE$.augmentString(filename.substring(0, filename.length() - Log$.MODULE$.LogFileSuffix().length()))).toLong();
                File indexFile = Log$.MODULE$.indexFilename(this.$outer.dir(), start);
                File timeIndexFile = Log$.MODULE$.timeIndexFilename(this.$outer.dir(), start);
                boolean indexFileExists = indexFile.exists();
                LogSegment segment = new LogSegment(this.$outer.dir(), start, Predef$.MODULE$.Integer2int(this.$outer.config().indexInterval()), Predef$.MODULE$.Integer2int(this.$outer.config().maxIndexSize()), this.$outer.config().randomSegmentJitter(), this.$outer.kafka$log$Log$$time, true, LogSegment$.MODULE$.$lessinit$greater$default$8(), LogSegment$.MODULE$.$lessinit$greater$default$9());
                if (indexFileExists) {
                    try {
                        segment.index().sanityCheck();
                        segment.timeIndex().sanityCheck();
                        object = BoxedUnit.UNIT;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.$outer.warn((Function0<String>)new Serializable(this, indexFile, timeIndexFile, illegalArgumentException){
                            public static final long serialVersionUID = 0L;
                            private final File indexFile$1;
                            private final File timeIndexFile$1;
                            private final IllegalArgumentException e$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found a corrupted index file due to ", "}. deleting ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.getMessage(), this.timeIndexFile$1.getAbsolutePath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " and rebuilding index..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.indexFile$1.getAbsolutePath()}))).toString();
                            }
                            {
                                this.indexFile$1 = indexFile$1;
                                this.timeIndexFile$1 = timeIndexFile$1;
                                this.e$1 = e$1;
                            }
                        });
                        indexFile.delete();
                        timeIndexFile.delete();
                        object = BoxesRunTime.boxToInteger((int)segment.recover(Predef$.MODULE$.Integer2int(this.$outer.config().maxMessageSize())));
                    }
                } else {
                    this.$outer.error((Function0<String>)new Serializable(this, segment){
                        public static final long serialVersionUID = 0L;
                        private final LogSegment segment$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Could not find index file corresponding to log file %s, rebuilding index...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.segment$1.log().file().getAbsolutePath()}));
                        }
                        {
                            this.segment$1 = segment$1;
                        }
                    });
                    object = BoxesRunTime.boxToInteger((int)segment.recover(Predef$.MODULE$.Integer2int(this.$outer.config().maxMessageSize())));
                }
                object2 = this.$outer.kafka$log$Log$$segments().put(Predef$.MODULE$.long2Long(start), segment);
                return object2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        ((Set)swapFiles.elem).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;

            public final void apply(File swapFile) {
                File logFile = new File(CoreUtils$.MODULE$.replaceSuffix(swapFile.getPath(), Log$.MODULE$.SwapFileSuffix(), ""));
                String fileName = logFile.getName();
                long startOffset = new StringOps(Predef$.MODULE$.augmentString(fileName.substring(0, fileName.length() - Log$.MODULE$.LogFileSuffix().length()))).toLong();
                File indexFile = new File(new StringBuilder().append((Object)CoreUtils$.MODULE$.replaceSuffix(logFile.getPath(), Log$.MODULE$.LogFileSuffix(), Log$.MODULE$.IndexFileSuffix())).append((Object)Log$.MODULE$.SwapFileSuffix()).toString());
                OffsetIndex index = new OffsetIndex(indexFile, startOffset, Predef$.MODULE$.Integer2int(this.$outer.config().maxIndexSize()));
                File timeIndexFile = new File(new StringBuilder().append((Object)CoreUtils$.MODULE$.replaceSuffix(logFile.getPath(), Log$.MODULE$.LogFileSuffix(), Log$.MODULE$.TimeIndexFileSuffix())).append((Object)Log$.MODULE$.SwapFileSuffix()).toString());
                TimeIndex timeIndex = new TimeIndex(timeIndexFile, startOffset, Predef$.MODULE$.Integer2int(this.$outer.config().maxIndexSize()));
                LogSegment swapSegment = new LogSegment(new FileMessageSet(swapFile), index, timeIndex, startOffset, Predef$.MODULE$.Integer2int(this.$outer.config().indexInterval()), this.$outer.config().randomSegmentJitter(), this.$outer.kafka$log$Log$$time);
                this.$outer.info((Function0<String>)new Serializable(this, swapFile){
                    public static final long serialVersionUID = 0L;
                    private final File swapFile$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Found log file %s from interrupted swap operation, repairing.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.swapFile$1.getPath()}));
                    }
                    {
                        this.swapFile$1 = swapFile$1;
                    }
                });
                swapSegment.recover(Predef$.MODULE$.Integer2int(this.$outer.config().maxMessageSize()));
                Iterable<LogSegment> oldSegments = this.$outer.logSegments(swapSegment.baseOffset(), swapSegment.nextOffset());
                this.$outer.replaceSegments(swapSegment, (Seq<LogSegment>)oldSegments.toSeq(), true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (this.logSegments().isEmpty()) {
            this.kafka$log$Log$$segments().put(Predef$.MODULE$.long2Long(0L), new LogSegment(this.dir(), 0L, Predef$.MODULE$.Integer2int(this.config().indexInterval()), Predef$.MODULE$.Integer2int(this.config().maxIndexSize()), this.config().randomSegmentJitter(), this.kafka$log$Log$$time, false, this.initFileSize(), Predef$.MODULE$.Boolean2boolean(this.config().preallocate())));
        } else {
            this.recoverLog();
            this.activeSegment().index().resize(Predef$.MODULE$.Integer2int(this.config().maxIndexSize()));
            this.activeSegment().timeIndex().resize(Predef$.MODULE$.Integer2int(this.config().maxIndexSize()));
        }
    }

    private void updateLogEndOffset(long messageOffset) {
        this.nextOffsetMetadata_$eq(new LogOffsetMetadata(messageOffset, this.activeSegment().baseOffset(), (int)this.activeSegment().size()));
    }

    /*
     * Exception decompiling
     */
    private void recoverLog() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 132->153)] kafka.common.InvalidOffsetException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean hasCleanShutdownFile() {
        return new File(this.dir().getParentFile(), Log$.MODULE$.CleanShutdownFile()).exists();
    }

    public int numberOfSegments() {
        return this.kafka$log$Log$$segments().size();
    }

    public void close() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Closing log ").append((Object)this.$outer.name()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Object object = this.lock();
        synchronized (object) {
            this.logSegments().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(LogSegment x$1) {
                    x$1.close();
                }
            });
            return;
        }
    }

    public LogAppendInfo append(ByteBufferMessageSet messages, boolean assignOffsets) {
        LogAppendInfo appendInfo = this.analyzeAndValidateMessageSet(messages);
        if (appendInfo.shallowCount() == 0) {
            return appendInfo;
        }
        ObjectRef validMessages = new ObjectRef((Object)this.trimInvalidBytes(messages, appendInfo));
        try {
            Object object = this.lock();
            synchronized (object) {
                block13: {
                    if (assignOffsets) {
                        LongRef offset = new LongRef(this.nextOffsetMetadata().messageOffset());
                        appendInfo.firstOffset_$eq(offset.value());
                        long now = this.kafka$log$Log$$time.milliseconds();
                        ValidationAndOffsetAssignResult validateAndOffsetAssignResult = this.liftedTree1$1(appendInfo, validMessages, offset, now);
                        validMessages.elem = validateAndOffsetAssignResult.validatedMessages();
                        appendInfo.maxTimestamp_$eq(validateAndOffsetAssignResult.maxTimestamp());
                        appendInfo.offsetOfMaxTimestamp_$eq(validateAndOffsetAssignResult.offsetOfMaxTimestamp());
                        appendInfo.lastOffset_$eq(offset.value() - 1L);
                        TimestampType timestampType2 = this.config().messageTimestampType();
                        TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
                        if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
                            appendInfo.logAppendTime_$eq(now);
                        }
                        if (validateAndOffsetAssignResult.messageSizeMaybeChanged()) {
                            ((ByteBufferMessageSet)validMessages.elem).shallowIterator().foreach((Function1)new Serializable(this, messages){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Log $outer;
                                private final ByteBufferMessageSet messages$1;

                                public final void apply(MessageAndOffset messageAndOffset) {
                                    if (MessageSet$.MODULE$.entrySize(messageAndOffset.message()) > Predef$.MODULE$.Integer2int(this.$outer.config().maxMessageSize())) {
                                        BrokerTopicStats$.MODULE$.getBrokerTopicStats(this.$outer.topicAndPartition().topic()).bytesRejectedRate().mark((long)this.messages$1.sizeInBytes());
                                        BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesRejectedRate().mark((long)this.messages$1.sizeInBytes());
                                        throw new RecordTooLargeException(new StringOps(Predef$.MODULE$.augmentString("Message size is %d bytes which exceeds the maximum configured message size of %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)MessageSet$.MODULE$.entrySize(messageAndOffset.message())), this.$outer.config().maxMessageSize()})));
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.messages$1 = messages$1;
                                }
                            });
                        }
                    } else if (!appendInfo.offsetsMonotonic() || appendInfo.firstOffset() < this.nextOffsetMetadata().messageOffset()) break block13;
                    if (((ByteBufferMessageSet)validMessages.elem).sizeInBytes() > Predef$.MODULE$.Integer2int(this.config().segmentSize())) {
                        throw new RecordBatchTooLargeException(new StringOps(Predef$.MODULE$.augmentString("Message set size is %d bytes which exceeds the maximum configured segment size of %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((ByteBufferMessageSet)validMessages.elem).sizeInBytes()), this.config().segmentSize()})));
                    }
                    LogSegment segment = this.maybeRoll(((ByteBufferMessageSet)validMessages.elem).sizeInBytes(), appendInfo.maxTimestamp());
                    segment.append(appendInfo.firstOffset(), appendInfo.maxTimestamp(), appendInfo.offsetOfMaxTimestamp(), (ByteBufferMessageSet)validMessages.elem);
                    this.updateLogEndOffset(appendInfo.lastOffset() + 1L);
                    this.trace((Function0<String>)new Serializable(this, appendInfo, validMessages){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Log $outer;
                        private final LogAppendInfo appendInfo$1;
                        private final ObjectRef validMessages$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Appended message set to log %s with first offset: %d, next offset: %d, and messages: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), BoxesRunTime.boxToLong((long)this.appendInfo$1.firstOffset()), BoxesRunTime.boxToLong((long)this.$outer.nextOffsetMetadata().messageOffset()), (ByteBufferMessageSet)this.validMessages$1.elem}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.appendInfo$1 = appendInfo$1;
                            this.validMessages$1 = validMessages$1;
                        }
                    });
                    if (this.unflushedMessages() >= Predef$.MODULE$.Long2long(this.config().flushInterval())) {
                        this.flush();
                    }
                    LogAppendInfo logAppendInfo = appendInfo;
                    return logAppendInfo;
                }
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Out of order offsets found in ").append((Object)messages).toString());
            }
        }
        catch (IOException iOException) {
            throw new KafkaStorageException(new StringOps(Predef$.MODULE$.augmentString("I/O exception in append to log '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})), iOException);
        }
    }

    public boolean append$default$2() {
        return true;
    }

    private LogAppendInfo analyzeAndValidateMessageSet(ByteBufferMessageSet messages) {
        IntRef shallowMessageCount = new IntRef(0);
        IntRef validBytesCount = new IntRef(0);
        scala.runtime.LongRef firstOffset = new scala.runtime.LongRef(-1L);
        scala.runtime.LongRef lastOffset = new scala.runtime.LongRef(-1L);
        ObjectRef sourceCodec = new ObjectRef((Object)NoCompressionCodec$.MODULE$);
        BooleanRef monotonic = new BooleanRef(true);
        scala.runtime.LongRef maxTimestamp = new scala.runtime.LongRef(Message$.MODULE$.NoTimestamp());
        scala.runtime.LongRef offsetOfMaxTimestamp = new scala.runtime.LongRef(-1L);
        messages.shallowIterator().foreach((Function1)new Serializable(this, messages, shallowMessageCount, validBytesCount, firstOffset, lastOffset, sourceCodec, monotonic, maxTimestamp, offsetOfMaxTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final ByteBufferMessageSet messages$2;
            private final IntRef shallowMessageCount$1;
            private final IntRef validBytesCount$1;
            private final scala.runtime.LongRef firstOffset$1;
            private final scala.runtime.LongRef lastOffset$1;
            private final ObjectRef sourceCodec$1;
            private final BooleanRef monotonic$1;
            private final scala.runtime.LongRef maxTimestamp$1;
            private final scala.runtime.LongRef offsetOfMaxTimestamp$1;

            public final void apply(MessageAndOffset messageAndOffset) {
                CompressionCodec messageCodec;
                if (this.firstOffset$1.elem < 0L) {
                    this.firstOffset$1.elem = messageAndOffset.offset();
                }
                if (this.lastOffset$1.elem >= messageAndOffset.offset()) {
                    this.monotonic$1.elem = false;
                }
                this.lastOffset$1.elem = messageAndOffset.offset();
                Message m = messageAndOffset.message();
                int messageSize = MessageSet$.MODULE$.entrySize(m);
                if (messageSize > Predef$.MODULE$.Integer2int(this.$outer.config().maxMessageSize())) {
                    BrokerTopicStats$.MODULE$.getBrokerTopicStats(this.$outer.topicAndPartition().topic()).bytesRejectedRate().mark((long)this.messages$2.sizeInBytes());
                    BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesRejectedRate().mark((long)this.messages$2.sizeInBytes());
                    throw new RecordTooLargeException(new StringOps(Predef$.MODULE$.augmentString("Message size is %d bytes which exceeds the maximum configured message size of %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messageSize), this.$outer.config().maxMessageSize()})));
                }
                m.ensureValid();
                if (m.timestamp() > this.maxTimestamp$1.elem) {
                    this.maxTimestamp$1.elem = m.timestamp();
                    this.offsetOfMaxTimestamp$1.elem = this.lastOffset$1.elem;
                }
                ++this.shallowMessageCount$1.elem;
                this.validBytesCount$1.elem += messageSize;
                CompressionCodec compressionCodec = messageCodec = m.compressionCodec();
                NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                if (compressionCodec == null ? noCompressionCodec$ != null : !compressionCodec.equals(noCompressionCodec$)) {
                    this.sourceCodec$1.elem = messageCodec;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messages$2 = messages$2;
                this.shallowMessageCount$1 = shallowMessageCount$1;
                this.validBytesCount$1 = validBytesCount$1;
                this.firstOffset$1 = firstOffset$1;
                this.lastOffset$1 = lastOffset$1;
                this.sourceCodec$1 = sourceCodec$1;
                this.monotonic$1 = monotonic$1;
                this.maxTimestamp$1 = maxTimestamp$1;
                this.offsetOfMaxTimestamp$1 = offsetOfMaxTimestamp$1;
            }
        });
        CompressionCodec targetCodec = BrokerCompressionCodec$.MODULE$.getTargetCompressionCodec(this.config().compressionType(), (CompressionCodec)sourceCodec.elem);
        return new LogAppendInfo(firstOffset.elem, lastOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, Message$.MODULE$.NoTimestamp(), (CompressionCodec)sourceCodec.elem, targetCodec, shallowMessageCount.elem, validBytesCount.elem, monotonic.elem);
    }

    private ByteBufferMessageSet trimInvalidBytes(ByteBufferMessageSet messages, LogAppendInfo info) {
        ByteBufferMessageSet byteBufferMessageSet;
        int messageSetValidBytes = info.validBytes();
        if (messageSetValidBytes < 0) {
            throw new CorruptRecordException(new StringBuilder().append((Object)"Illegal length of message set ").append((Object)BoxesRunTime.boxToInteger((int)messageSetValidBytes)).append((Object)" Message set cannot be appended to log. Possible causes are corrupted produce requests").toString());
        }
        if (messageSetValidBytes == messages.sizeInBytes()) {
            byteBufferMessageSet = messages;
        } else {
            ByteBuffer validByteBuffer = messages.buffer().duplicate();
            validByteBuffer.limit(messageSetValidBytes);
            byteBufferMessageSet = new ByteBufferMessageSet(validByteBuffer);
        }
        return byteBufferMessageSet;
    }

    public FetchDataInfo read(long startOffset, int maxLength, Option<Object> maxOffset, boolean minOneMessage) {
        FetchDataInfo fetchInfo;
        this.trace((Function0<String>)new Serializable(this, startOffset, maxLength){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final long startOffset$1;
            private final int maxLength$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Reading %d bytes from offset %d in log %s of length %d bytes")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxLength$1), BoxesRunTime.boxToLong((long)this.startOffset$1), this.$outer.name(), BoxesRunTime.boxToLong((long)this.$outer.size())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.startOffset$1 = startOffset$1;
                this.maxLength$1 = maxLength$1;
            }
        });
        LogOffsetMetadata currentNextOffsetMetadata = this.nextOffsetMetadata();
        long next2 = currentNextOffsetMetadata.messageOffset();
        if (startOffset == next2) {
            return new FetchDataInfo(currentNextOffsetMetadata, MessageSet$.MODULE$.Empty(), FetchDataInfo$.MODULE$.apply$default$3());
        }
        Map.Entry entry2 = this.kafka$log$Log$$segments().floorEntry(Predef$.MODULE$.long2Long(startOffset));
        if (startOffset > next2 || entry2 == null) {
            throw new OffsetOutOfRangeException(new StringOps(Predef$.MODULE$.augmentString("Request for offset %d but we only have log segments in the range %d to %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startOffset), this.kafka$log$Log$$segments().firstKey(), BoxesRunTime.boxToLong((long)next2)})));
        }
        while (true) {
            long l;
            Map.Entry entry3;
            if (entry2 == null) {
                return new FetchDataInfo(this.nextOffsetMetadata(), MessageSet$.MODULE$.Empty(), FetchDataInfo$.MODULE$.apply$default$3());
            }
            void v0 = entry3;
            Map.Entry entry4 = this.kafka$log$Log$$segments().lastEntry();
            if (!(v0 != null ? !v0.equals(entry4) : entry4 != null)) {
                long exposedPos = this.nextOffsetMetadata().relativePositionInSegment();
                void v1 = entry3;
                Map.Entry entry5 = this.kafka$log$Log$$segments().lastEntry();
                l = !(v1 != null ? !v1.equals(entry5) : entry5 != null) ? exposedPos : ((LogSegment)entry3.getValue()).size();
            } else {
                l = ((LogSegment)entry3.getValue()).size();
            }
            long maxPosition = l;
            fetchInfo = ((LogSegment)entry3.getValue()).read(startOffset, maxOffset, maxLength, maxPosition, minOneMessage);
            if (fetchInfo != null) break;
            entry3 = this.kafka$log$Log$$segments().higherEntry((Long)entry3.getKey());
        }
        return fetchInfo;
    }

    public Option<Object> read$default$3() {
        return None$.MODULE$;
    }

    public boolean read$default$4() {
        return false;
    }

    public Option<TimestampOffset> fetchOffsetsByTimestamp(long targetTimestamp) {
        this.debug((Function0<String>)new Serializable(this, targetTimestamp){
            public static final long serialVersionUID = 0L;
            private final long targetTimestamp$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching offset for timestamp ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.targetTimestamp$1)}));
            }
            {
                this.targetTimestamp$1 = targetTimestamp$1;
            }
        });
        if (this.config().messageFormatVersion().$less(KAFKA_0_10_0_IV0$.MODULE$) && targetTimestamp != -2L && targetTimestamp != -1L) {
            throw new UnsupportedForMessageFormatException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot search offsets based on timestamp because message format version "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for partition ", " is ", " which is earlier than the minimum "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition(), this.config().messageFormatVersion()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"required version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KAFKA_0_10_0_IV0$.MODULE$}))).toString());
        }
        Buffer segmentsCopy = this.logSegments().toBuffer();
        if (targetTimestamp == -2L) {
            return new Some((Object)new TimestampOffset(Message$.MODULE$.NoTimestamp(), ((LogSegment)segmentsCopy.head()).baseOffset()));
        }
        if (targetTimestamp == -1L) {
            return new Some((Object)new TimestampOffset(Message$.MODULE$.NoTimestamp(), this.logEndOffset()));
        }
        Buffer earlierSegs = (Buffer)segmentsCopy.takeWhile((Function1)new Serializable(this, targetTimestamp){
            public static final long serialVersionUID = 0L;
            private final long targetTimestamp$1;

            public final boolean apply(LogSegment x$2) {
                return x$2.largestTimestamp() < this.targetTimestamp$1;
            }
            {
                this.targetTimestamp$1 = targetTimestamp$1;
            }
        });
        None$ targetSeg = earlierSegs.length() < segmentsCopy.length() ? new Some(segmentsCopy.apply(earlierSegs.length())) : None$.MODULE$;
        return targetSeg.flatMap((Function1)new Serializable(this, targetTimestamp){
            public static final long serialVersionUID = 0L;
            private final long targetTimestamp$1;

            public final Option<TimestampOffset> apply(LogSegment x$3) {
                return x$3.findOffsetByTimestamp(this.targetTimestamp$1);
            }
            {
                this.targetTimestamp$1 = targetTimestamp$1;
            }
        });
    }

    public LogOffsetMetadata convertToOffsetMetadata(long offset) {
        LogOffsetMetadata logOffsetMetadata;
        try {
            FetchDataInfo fetchDataInfo = this.read(offset, 1, this.read$default$3(), this.read$default$4());
            logOffsetMetadata = fetchDataInfo.fetchOffsetMetadata();
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            logOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        }
        return logOffsetMetadata;
    }

    private int deleteOldSegments(Function1<LogSegment, Object> predicate) {
        Object object = this.lock();
        synchronized (object) {
            Iterable<LogSegment> deletable = this.deletableSegments(predicate);
            int numToDelete = deletable.size();
            if (numToDelete > 0) {
                Object object2 = this.kafka$log$Log$$segments().size() == numToDelete ? this.roll() : BoxedUnit.UNIT;
                deletable.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Log $outer;

                    public final void apply(LogSegment x$4) {
                        this.$outer.kafka$log$Log$$deleteSegment(x$4);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            Integer n = BoxesRunTime.boxToInteger((int)numToDelete);
            return BoxesRunTime.unboxToInt((Object)n);
        }
    }

    private Iterable<LogSegment> deletableSegments(Function1<LogSegment, Object> predicate) {
        Map.Entry lastEntry2 = this.kafka$log$Log$$segments().lastEntry();
        return lastEntry2 == null ? (Iterable)Seq$.MODULE$.empty() : (Iterable)this.logSegments().takeWhile((Function1)new Serializable(this, predicate, lastEntry2){
            public static final long serialVersionUID = 0L;
            private final Function1 predicate$1;
            private final Map.Entry lastEntry$1;

            public final boolean apply(LogSegment s) {
                return BoxesRunTime.unboxToBoolean((Object)this.predicate$1.apply((Object)s)) && (s.baseOffset() != ((LogSegment)this.lastEntry$1.getValue()).baseOffset() || s.size() > 0L);
            }
            {
                this.predicate$1 = predicate$1;
                this.lastEntry$1 = lastEntry$1;
            }
        });
    }

    public int deleteOldSegments() {
        if (this.config().delete()) {
            return this.deleteRetenionMsBreachedSegments() + this.deleteRetentionSizeBreachedSegments();
        }
        return 0;
    }

    private int deleteRetenionMsBreachedSegments() {
        if (Predef$.MODULE$.Long2long(this.config().retentionMs()) < 0L) {
            return 0;
        }
        long startMs = this.kafka$log$Log$$time.milliseconds();
        return this.deleteOldSegments((Function1<LogSegment, Object>)new Serializable(this, startMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final long startMs$1;

            public final boolean apply(LogSegment x$5) {
                return this.startMs$1 - x$5.largestTimestamp() > Predef$.MODULE$.Long2long(this.$outer.config().retentionMs());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.startMs$1 = startMs$1;
            }
        });
    }

    private int deleteRetentionSizeBreachedSegments() {
        if (Predef$.MODULE$.Long2long(this.config().retentionSize()) < 0L || this.size() < Predef$.MODULE$.Long2long(this.config().retentionSize())) {
            return 0;
        }
        scala.runtime.LongRef diff = new scala.runtime.LongRef(this.size() - Predef$.MODULE$.Long2long(this.config().retentionSize()));
        return this.deleteOldSegments((Function1<LogSegment, Object>)new Serializable(this, diff){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final scala.runtime.LongRef diff$1;

            public final boolean apply(LogSegment segment) {
                return this.$outer.kafka$log$Log$$shouldDelete$1(segment, this.diff$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.diff$1 = diff$1;
            }
        });
    }

    public long size() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$6) {
                return x$6.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long logStartOffset() {
        return ((LogSegment)this.logSegments().head()).baseOffset();
    }

    public LogOffsetMetadata logEndOffsetMetadata() {
        return this.nextOffsetMetadata();
    }

    public long logEndOffset() {
        return this.nextOffsetMetadata().messageOffset();
    }

    private LogSegment maybeRoll(int messagesSize, long maxTimestampInMessages) {
        LogSegment logSegment;
        long now;
        boolean reachedRollMs;
        LogSegment segment = this.activeSegment();
        boolean bl = reachedRollMs = segment.timeWaitedForRoll(now = this.kafka$log$Log$$time.milliseconds(), maxTimestampInMessages) > Predef$.MODULE$.Long2long(this.config().segmentMs()) - segment.rollJitterMs();
        if (segment.size() > (long)(Predef$.MODULE$.Integer2int(this.config().segmentSize()) - messagesSize) || segment.size() > 0L && reachedRollMs || segment.index().isFull() || segment.timeIndex().isFull()) {
            this.debug((Function0<String>)new Serializable(this, maxTimestampInMessages, segment, now){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Log $outer;
                private final long maxTimestampInMessages$1;
                private final LogSegment segment$3;
                private final long now$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling new log segment in ", " (log_size = ", "/", "}, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), BoxesRunTime.boxToLong((long)this.segment$3.size()), this.$outer.config().segmentSize()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"index_size = ", "/", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.segment$3.index().entries()), BoxesRunTime.boxToInteger((int)this.segment$3.index().maxEntries())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time_index_size = ", "/", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.segment$3.timeIndex().entries()), BoxesRunTime.boxToInteger((int)this.segment$3.timeIndex().maxEntries())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"inactive_time_ms = ", "/", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.segment$3.timeWaitedForRoll(this.now$2, this.maxTimestampInMessages$1)), BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(this.$outer.config().segmentMs()) - this.segment$3.rollJitterMs()))}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.maxTimestampInMessages$1 = maxTimestampInMessages$1;
                    this.segment$3 = segment$3;
                    this.now$2 = now$2;
                }
            });
            logSegment = this.roll();
        } else {
            logSegment = segment;
        }
        return logSegment;
    }

    /*
     * WARNING - void declaration
     */
    public LogSegment roll() {
        long start = this.kafka$log$Log$$time.nanoseconds();
        Object object = this.lock();
        synchronized (object) {
            void var5_3;
            block6: {
                long newOffset = this.logEndOffset();
                File logFile = Log$.MODULE$.logFilename(this.dir(), newOffset);
                File indexFile = Log$.MODULE$.indexFilename(this.dir(), newOffset);
                File timeIndexFile = Log$.MODULE$.timeIndexFilename(this.dir(), newOffset);
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{logFile, indexFile, timeIndexFile})).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File file) {
                        return file.exists();
                    }
                }).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Log $outer;

                    public final boolean apply(File file) {
                        this.$outer.warn((Function0<String>)new Serializable(this, file){
                            public static final long serialVersionUID = 0L;
                            private final File file$2;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Newly rolled segment file ").append((Object)this.file$2.getName()).append((Object)" already exists; deleting it first").toString();
                            }
                            {
                                this.file$2 = file$2;
                            }
                        });
                        return file.delete();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Map.Entry entry2 = this.kafka$log$Log$$segments().lastEntry();
                if (entry2 == null) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    LogSegment seg = (LogSegment)entry2.getValue();
                    seg.onBecomeInactiveSegment();
                    seg.index().trimToValidSize();
                    seg.timeIndex().trimToValidSize();
                    seg.log().trim();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                LogSegment segment = new LogSegment(this.dir(), newOffset, Predef$.MODULE$.Integer2int(this.config().indexInterval()), Predef$.MODULE$.Integer2int(this.config().maxIndexSize()), this.config().randomSegmentJitter(), this.kafka$log$Log$$time, false, this.initFileSize(), Predef$.MODULE$.Boolean2boolean(this.config().preallocate()));
                LogSegment prev = this.addSegment(segment);
                if (prev != null) break block6;
                this.updateLogEndOffset(this.nextOffsetMetadata().messageOffset());
                this.scheduler.schedule("flush-log", (Function0<BoxedUnit>)new Serializable(this, newOffset){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Log $outer;
                    private final long newOffset$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.flush(this.newOffset$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.newOffset$1 = newOffset$1;
                    }
                }, 0L, this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
                this.info((Function0<String>)new Serializable(this, start){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Log $outer;
                    private final long start$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Rolled new log segment for '").append((Object)this.$outer.name()).append((Object)new StringOps(Predef$.MODULE$.augmentString("' in %.0f ms.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)(System.nanoTime() - this.start$1) / 1000000.0))}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.start$1 = start$1;
                    }
                });
                LogSegment logSegment = segment;
                return logSegment;
            }
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Trying to roll a new log segment for topic partition %s with start offset %d while it already exists.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToLong((long)var5_3)})));
        }
    }

    public long unflushedMessages() {
        return this.logEndOffset() - this.recoveryPoint();
    }

    public void flush() {
        this.flush(this.logEndOffset());
    }

    public void flush(long offset) {
        if (offset <= this.recoveryPoint()) {
            return;
        }
        this.debug((Function0<String>)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final long offset$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Flushing log '").append((Object)this.$outer.name()).append((Object)" up to offset ").append((Object)BoxesRunTime.boxToLong((long)this.offset$2)).append((Object)", last flushed: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.lastFlushTime())).append((Object)" current time: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$log$Log$$time.milliseconds())).append((Object)" unflushed = ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.unflushedMessages())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
            }
        });
        this.logSegments(this.recoveryPoint(), offset).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogSegment segment) {
                segment.flush();
            }
        });
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            if (offset > this.recoveryPoint()) {
                this.recoveryPoint_$eq(offset);
                this.lastflushedTime().set(this.kafka$log$Log$$time.milliseconds());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void delete() {
        Object object = this.lock();
        synchronized (object) {
            this.removeLogMetrics();
            this.logSegments().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(LogSegment x$7) {
                    x$7.delete();
                }
            });
            this.kafka$log$Log$$segments().clear();
            Utils.delete((File)this.dir());
            return;
        }
    }

    public void truncateTo(long targetOffset) {
        this.info((Function0<String>)new Serializable(this, targetOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final long targetOffset$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Truncating log %s to offset %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), BoxesRunTime.boxToLong((long)this.targetOffset$1)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.targetOffset$1 = targetOffset$1;
            }
        });
        if (targetOffset < 0L) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Cannot truncate to a negative offset (%d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)targetOffset)})));
        }
        if (targetOffset > this.logEndOffset()) {
            this.info((Function0<String>)new Serializable(this, targetOffset){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Log $outer;
                private final long targetOffset$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Truncating %s to %d has no effect as the largest offset in the log is %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), BoxesRunTime.boxToLong((long)this.targetOffset$1), BoxesRunTime.boxToLong((long)(this.$outer.logEndOffset() - 1L))}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.targetOffset$1 = targetOffset$1;
                }
            });
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            if (((LogSegment)this.kafka$log$Log$$segments().firstEntry().getValue()).baseOffset() > targetOffset) {
                this.truncateFullyAndStartAt(targetOffset);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Iterable deletable = (Iterable)this.logSegments().filter((Function1)new Serializable(this, targetOffset){
                    public static final long serialVersionUID = 0L;
                    private final long targetOffset$1;

                    public final boolean apply(LogSegment segment) {
                        return segment.baseOffset() > this.targetOffset$1;
                    }
                    {
                        this.targetOffset$1 = targetOffset$1;
                    }
                });
                deletable.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Log $outer;

                    public final void apply(LogSegment x$8) {
                        this.$outer.kafka$log$Log$$deleteSegment(x$8);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.activeSegment().truncateTo(targetOffset);
                this.updateLogEndOffset(targetOffset);
                this.recoveryPoint_$eq(package$.MODULE$.min(targetOffset, this.recoveryPoint()));
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void truncateFullyAndStartAt(long newOffset) {
        this.debug((Function0<String>)new Serializable(this, newOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final long newOffset$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Truncate and start log '").append((Object)this.$outer.name()).append((Object)"' to ").append((Object)BoxesRunTime.boxToLong((long)this.newOffset$2)).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newOffset$2 = newOffset$2;
            }
        });
        Object object = this.lock();
        synchronized (object) {
            List segmentsToDelete = this.logSegments().toList();
            segmentsToDelete.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Log $outer;

                public final void apply(LogSegment x$9) {
                    this.$outer.kafka$log$Log$$deleteSegment(x$9);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.addSegment(new LogSegment(this.dir(), newOffset, Predef$.MODULE$.Integer2int(this.config().indexInterval()), Predef$.MODULE$.Integer2int(this.config().maxIndexSize()), this.config().randomSegmentJitter(), this.kafka$log$Log$$time, false, this.initFileSize(), Predef$.MODULE$.Boolean2boolean(this.config().preallocate())));
            this.updateLogEndOffset(newOffset);
            this.recoveryPoint_$eq(package$.MODULE$.min(newOffset, this.recoveryPoint()));
            return;
        }
    }

    public long lastFlushTime() {
        return this.lastflushedTime().get();
    }

    public LogSegment activeSegment() {
        return (LogSegment)this.kafka$log$Log$$segments().lastEntry().getValue();
    }

    public Iterable<LogSegment> logSegments() {
        return JavaConversions$.MODULE$.collectionAsScalaIterable(this.kafka$log$Log$$segments().values());
    }

    public Iterable<LogSegment> logSegments(long from, long to) {
        Object object = this.lock();
        synchronized (object) {
            Long floor = this.kafka$log$Log$$segments().floorKey(Predef$.MODULE$.long2Long(from));
            Iterable iterable = floor == null ? JavaConversions$.MODULE$.collectionAsScalaIterable(this.kafka$log$Log$$segments().headMap((Object)Predef$.MODULE$.long2Long(to)).values()) : JavaConversions$.MODULE$.collectionAsScalaIterable(this.kafka$log$Log$$segments().subMap((Object)floor, true, (Object)Predef$.MODULE$.long2Long(to), false).values());
            return iterable;
        }
    }

    public String toString() {
        return new StringBuilder().append((Object)"Log(").append((Object)this.dir()).append((Object)")").toString();
    }

    public void kafka$log$Log$$deleteSegment(LogSegment segment) {
        this.info((Function0<String>)new Serializable(this, segment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final LogSegment segment$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Scheduling log segment %d for log %s for deletion.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.segment$2.baseOffset()), this.$outer.name()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.segment$2 = segment$2;
            }
        });
        Object object = this.lock();
        synchronized (object) {
            this.kafka$log$Log$$segments().remove(BoxesRunTime.boxToLong((long)segment.baseOffset()));
            this.kafka$log$Log$$asyncDeleteSegment(segment);
            return;
        }
    }

    public void kafka$log$Log$$asyncDeleteSegment(LogSegment segment) {
        segment.changeFileSuffixes("", Log$.MODULE$.DeletedFileSuffix());
        this.scheduler.schedule("delete-file", (Function0<BoxedUnit>)new Serializable(this, segment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final LogSegment segment$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$Log$$deleteSeg$1(this.segment$4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.segment$4 = segment$4;
            }
        }, Predef$.MODULE$.Long2long(this.config().fileDeleteDelayMs()), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void replaceSegments(LogSegment newSegment, Seq<LogSegment> oldSegments, boolean isRecoveredSwapFile) {
        Object object = this.lock();
        synchronized (object) {
            if (!isRecoveredSwapFile) {
                newSegment.changeFileSuffixes(Log$.MODULE$.CleanedFileSuffix(), Log$.MODULE$.SwapFileSuffix());
            }
            this.addSegment(newSegment);
            oldSegments.foreach((Function1)new Serializable(this, newSegment){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Log $outer;
                private final LogSegment newSegment$1;

                public final void apply(LogSegment seg) {
                    Object object = seg.baseOffset() != this.newSegment$1.baseOffset() ? this.$outer.kafka$log$Log$$segments().remove(BoxesRunTime.boxToLong((long)seg.baseOffset())) : BoxedUnit.UNIT;
                    this.$outer.kafka$log$Log$$asyncDeleteSegment(seg);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.newSegment$1 = newSegment$1;
                }
            });
            newSegment.changeFileSuffixes(Log$.MODULE$.SwapFileSuffix(), "");
            return;
        }
    }

    public boolean replaceSegments$default$3() {
        return false;
    }

    public void removeLogMetrics() {
        this.removeMetric("NumLogSegments", (Map<String, String>)this.tags());
        this.removeMetric("LogStartOffset", (Map<String, String>)this.tags());
        this.removeMetric("LogEndOffset", (Map<String, String>)this.tags());
        this.removeMetric("Size", (Map<String, String>)this.tags());
    }

    public LogSegment addSegment(LogSegment segment) {
        return this.kafka$log$Log$$segments().put(Predef$.MODULE$.long2Long(segment.baseOffset()), segment);
    }

    private final ValidationAndOffsetAssignResult liftedTree1$1(LogAppendInfo appendInfo$1, ObjectRef validMessages$1, LongRef offset$1, long now$1) {
        try {
            return ((ByteBufferMessageSet)validMessages$1.elem).validateMessagesAndAssignOffsets(offset$1, now$1, appendInfo$1.sourceCodec(), appendInfo$1.targetCodec(), this.config().compact(), this.config().messageFormatVersion().messageFormatVersion(), this.config().messageTimestampType(), this.config().messageTimestampDifferenceMaxMs());
        }
        catch (IOException iOException) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Error in validating messages while appending to log '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})), iOException);
        }
    }

    public final boolean kafka$log$Log$$shouldDelete$1(LogSegment segment, scala.runtime.LongRef diff$1) {
        boolean bl;
        if (diff$1.elem - segment.size() >= 0L) {
            diff$1.elem -= segment.size();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void kafka$log$Log$$deleteSeg$1(LogSegment segment$4) {
        this.info((Function0<String>)new Serializable(this, segment$4){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final LogSegment segment$4;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Deleting segment %d from log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.segment$4.baseOffset()), this.$outer.name()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.segment$4 = segment$4;
            }
        });
        segment$4.delete();
    }

    public Log(File dir, LogConfig config, long recoveryPoint, Scheduler scheduler, Time time) {
        this.dir = dir;
        this.config = config;
        this.recoveryPoint = recoveryPoint;
        this.scheduler = scheduler;
        this.kafka$log$Log$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.lock = new Object();
        this.lastflushedTime = new AtomicLong(time.milliseconds());
        this.t = time.milliseconds();
        this.kafka$log$Log$$segments = new ConcurrentSkipListMap<Long, LogSegment>();
        this.loadSegments();
        this.nextOffsetMetadata = new LogOffsetMetadata(this.activeSegment().nextOffset(), this.activeSegment().baseOffset(), (int)this.activeSegment().size());
        this.topicAndPartition = Log$.MODULE$.parseTopicPartitionName(dir);
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Completed load of log %s with %d log segments and log end offset %d in %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$Log$$segments().size()), BoxesRunTime.boxToLong((long)this.$outer.logEndOffset()), BoxesRunTime.boxToLong((long)(this.$outer.kafka$log$Log$$time.milliseconds() - this.$outer.t()))}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic"), (Object)this.topicAndPartition().topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partition"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.topicAndPartition().partition())).toString())}));
        this.newGauge("NumLogSegments", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Log $outer;

            public int value() {
                return this.$outer.numberOfSegments();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
        this.newGauge("LogStartOffset", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Log $outer;

            public long value() {
                return this.$outer.logStartOffset();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
        this.newGauge("LogEndOffset", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Log $outer;

            public long value() {
                return this.$outer.logEndOffset();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
        this.newGauge("Size", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Log $outer;

            public long value() {
                return this.$outer.size();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
    }
}

