/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.common;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Objects;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.MessageConsumerManager;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.logging.Logging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageConsumerManager
implements MessageConsumerManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMessageConsumerManager.class);
    private final Multimap<SinkModule<?, Message>, MessageConsumer<?, Message>> consumersByModule = LinkedListMultimap.create();

    public abstract void startConsumingForModule(SinkModule<?, Message> var1) throws Exception;

    public abstract void stopConsumingForModule(SinkModule<?, Message> var1) throws Exception;

    public <S extends Message, T extends Message> void dispatch(SinkModule<S, T> module, T message) {
        this.consumersByModule.get(module).forEach(c -> c.handleMessage(message));
    }

    public synchronized <S extends Message, T extends Message> void registerConsumer(MessageConsumer<S, T> consumer) throws Exception {
        if (consumer == null) {
            return;
        }
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            LOG.info("Registering consumer: {}", consumer);
            SinkModule module = consumer.getModule();
            int numConsumersBefore = this.consumersByModule.get((Object)module).size();
            this.consumersByModule.put((Object)module, consumer);
            if (numConsumersBefore < 1) {
                LOG.info("Starting consuming messages for module: {}", (Object)module);
                this.startConsumingForModule(module);
            }
        }
    }

    public synchronized <S extends Message, T extends Message> void unregisterConsumer(MessageConsumer<S, T> consumer) throws Exception {
        if (consumer == null) {
            return;
        }
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            LOG.info("Unregistering consumer: {}", consumer);
            SinkModule module = consumer.getModule();
            this.consumersByModule.remove((Object)module, consumer);
            if (this.consumersByModule.get((Object)module).size() < 1) {
                LOG.info("Stopping consuming messages for module: {}", (Object)module);
                this.stopConsumingForModule(module);
            }
        }
    }

    public synchronized void unregisterAllConsumers() throws Exception {
        ArrayList consumers = Lists.newArrayList((Iterable)this.consumersByModule.values());
        for (MessageConsumer consumer : consumers) {
            this.unregisterConsumer(consumer);
        }
    }

    public static int getNumConsumerThreads(SinkModule<?, ?> module) {
        Objects.requireNonNull(module);
        int defaultValue = Runtime.getRuntime().availableProcessors() * 2;
        int configured = module.getNumConsumerThreads();
        if (configured <= 0) {
            LOG.warn("Number of consumer threads for module {} was {}. Value must be > 0. Falling back to {}", new Object[]{module.getId(), configured, defaultValue});
            return defaultValue;
        }
        return configured;
    }
}

