/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.ops4j.util.xml.ElementHelper;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class JspConfig {
    private static final Log log = LogFactory.getLog(JspConfig.class);
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private Vector<JspPropertyGroup> jspProperties = null;
    private final ServletContext ctxt;
    private volatile boolean initialized = false;
    private static final String defaultIsXml = null;
    private String defaultIsELIgnored = null;
    private static final String defaultIsScriptingInvalid = null;
    private String defaultDeferedSyntaxAllowedAsLiteral = null;
    private static final String defaultTrimDirectiveWhitespaces = null;
    private static final String defaultDefaultContentType = null;
    private static final String defaultBuffer = null;
    private static final String defaultErrorOnUndeclaredNamespace = "false";
    private JspProperty defaultJspProperty;

    public JspConfig(ServletContext ctxt) {
        this.ctxt = ctxt;
    }

    private void processWebDotXml() {
        JspConfigDescriptor jspConfig;
        if (this.ctxt.getEffectiveMajorVersion() < 2) {
            this.defaultIsELIgnored = "true";
            this.defaultDeferedSyntaxAllowedAsLiteral = "true";
            return;
        }
        if (this.ctxt.getEffectiveMajorVersion() == 2) {
            if (this.ctxt.getEffectiveMinorVersion() < 5) {
                this.defaultDeferedSyntaxAllowedAsLiteral = "true";
            }
            if (this.ctxt.getEffectiveMinorVersion() < 4) {
                this.defaultIsELIgnored = "true";
                return;
            }
        }
        if ((jspConfig = this.ctxt.getJspConfigDescriptor()) == null) {
            try {
                this.parseWebDotXml(this.ctxt);
            }
            catch (JasperException e) {
                log.error("error when parse the web.xml", (Throwable)((Object)e));
            }
            return;
        }
        this.jspProperties = new Vector();
        Collection jspPropertyGroups = jspConfig.getJspPropertyGroups();
        for (JspPropertyGroupDescriptor jspPropertyGroup : jspPropertyGroups) {
            Collection urlPatterns = jspPropertyGroup.getUrlPatterns();
            if (urlPatterns.size() == 0) continue;
            JspProperty property = new JspProperty(jspPropertyGroup.getIsXml(), jspPropertyGroup.getElIgnored(), jspPropertyGroup.getScriptingInvalid(), jspPropertyGroup.getPageEncoding(), jspPropertyGroup.getIncludePreludes(), jspPropertyGroup.getIncludeCodas(), jspPropertyGroup.getDeferredSyntaxAllowedAsLiteral(), jspPropertyGroup.getTrimDirectiveWhitespaces(), jspPropertyGroup.getDefaultContentType(), jspPropertyGroup.getBuffer(), jspPropertyGroup.getErrorOnUndeclaredNamespace());
            for (String urlPattern : urlPatterns) {
                String path = null;
                String extension = null;
                if (urlPattern.indexOf(42) < 0) {
                    path = urlPattern;
                } else {
                    String file;
                    int i = urlPattern.lastIndexOf(47);
                    if (i >= 0) {
                        path = urlPattern.substring(0, i + 1);
                        file = urlPattern.substring(i + 1);
                    } else {
                        file = urlPattern;
                    }
                    if (file.equals("*")) {
                        extension = "*";
                    } else if (file.startsWith("*.")) {
                        extension = file.substring(file.indexOf(46) + 1);
                    }
                    boolean isStar = "*".equals(extension);
                    if (path == null && (extension == null || isStar) || path != null && !isStar) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn(Localizer.getMessage("jsp.warning.bad.urlpattern.propertygroup", urlPattern));
                        continue;
                    }
                }
                JspPropertyGroup propertyGroup = new JspPropertyGroup(path, extension, property);
                this.jspProperties.addElement(propertyGroup);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseWebDotXml(ServletContext ctxt) throws JasperException {
        InputStream is = null;
        try {
            Element[] jspPropertyList;
            URL uri = ctxt.getResource(WEB_XML);
            if (uri == null) {
                return;
            }
            is = uri.openStream();
            InputSource ip = new InputSource(is);
            ip.setSystemId(uri.toExternalForm());
            Element webApp = ElementHelper.getRootElement(is);
            if (webApp == null || ElementHelper.getAttribute(webApp, "version") == null || Double.valueOf(ElementHelper.getAttribute(webApp, "version")) < 2.4) {
                this.defaultIsELIgnored = "true";
                return;
            }
            Element jspConfig = ElementHelper.getChild(webApp, "jsp-config");
            if (jspConfig == null) {
                return;
            }
            this.jspProperties = new Vector();
            Element[] elementArray = jspPropertyList = ElementHelper.getChildren(jspConfig, "jsp-property-group");
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element element = elementArray[n2];
                Element[] list = ElementHelper.getChildren(element);
                Vector<String> urlPatterns = new Vector<String>();
                String pageEncoding = null;
                String scriptingInvalid = null;
                String elIgnored = null;
                String isXml = null;
                Vector<String> includePrelude = new Vector<String>();
                Vector<String> includeCoda = new Vector<String>();
                String trimSpaces = null;
                String poundAllowed = null;
                for (Element innerElement : list) {
                    String tname = innerElement.getNodeName();
                    if ("url-pattern".equals(tname)) {
                        urlPatterns.addElement(JspConfig.getTextContent(innerElement));
                        continue;
                    }
                    if ("page-encoding".equals(tname)) {
                        pageEncoding = JspConfig.getTextContent(innerElement);
                        continue;
                    }
                    if ("is-xml".equals(tname)) {
                        isXml = JspConfig.getTextContent(innerElement);
                        continue;
                    }
                    if ("el-ignored".equals(tname)) {
                        elIgnored = JspConfig.getTextContent(innerElement);
                        continue;
                    }
                    if ("scripting-invalid".equals(tname)) {
                        scriptingInvalid = JspConfig.getTextContent(innerElement);
                        continue;
                    }
                    if ("include-prelude".equals(tname)) {
                        includePrelude.addElement(JspConfig.getTextContent(innerElement));
                        continue;
                    }
                    if ("include-coda".equals(tname)) {
                        includeCoda.addElement(JspConfig.getTextContent(innerElement));
                        continue;
                    }
                    if ("trim-directive-whitespaces".equals(tname)) {
                        trimSpaces = JspConfig.getTextContent(innerElement);
                        continue;
                    }
                    if (!"deferred-syntax-allowed-as-literal".equals(tname)) continue;
                    poundAllowed = JspConfig.getTextContent(innerElement);
                }
                if (urlPatterns.size() != 0) {
                    JspConfig.makeJspPropertyGroups(this.jspProperties, urlPatterns, isXml, elIgnored, scriptingInvalid, trimSpaces, poundAllowed, pageEncoding, includePrelude, includeCoda);
                }
                ++n2;
            }
            return;
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static String getTextContent(Element element) {
        if (element != null) {
            String content = element.getTextContent();
            if (content != null) {
                content = content.trim();
            }
            return content;
        }
        return null;
    }

    public static void makeJspPropertyGroups(Vector<JspPropertyGroup> jspProperties, Vector<String> urlPatterns, String isXml, String elIgnored, String scriptingInvalid, String trimSpaces, String poundAllowed, String pageEncoding, Vector<String> includePrelude, Vector<String> includeCoda) {
        if (urlPatterns == null || urlPatterns.size() == 0) {
            return;
        }
        for (int p = 0; p < urlPatterns.size(); ++p) {
            String urlPattern = urlPatterns.elementAt(p);
            String path = null;
            String extension = null;
            if (urlPattern.indexOf(42) < 0) {
                path = urlPattern;
            } else {
                String file;
                int i = urlPattern.lastIndexOf(47);
                if (i >= 0) {
                    path = urlPattern.substring(0, i + 1);
                    file = urlPattern.substring(i + 1);
                } else {
                    file = urlPattern;
                }
                if (file.equals("*")) {
                    extension = "*";
                } else if (file.startsWith("*.")) {
                    extension = file.substring(file.indexOf(46) + 1);
                }
                boolean isStar = "*".equals(extension);
                if (path == null && (extension == null || isStar) || path != null && !isStar) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn(Localizer.getMessage("jsp.warning.bad.urlpattern.propertygroup", urlPattern));
                    continue;
                }
            }
            JspProperty property = new JspProperty(isXml, elIgnored, scriptingInvalid, pageEncoding, includePrelude, includeCoda, poundAllowed, trimSpaces, null, null, null);
            JspPropertyGroup propertyGroup = new JspPropertyGroup(path, extension, property);
            jspProperties.addElement(propertyGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (!this.initialized) {
            JspConfig jspConfig = this;
            synchronized (jspConfig) {
                if (!this.initialized) {
                    this.processWebDotXml();
                    this.defaultJspProperty = new JspProperty(defaultIsXml, this.defaultIsELIgnored, defaultIsScriptingInvalid, null, null, null, this.defaultDeferedSyntaxAllowedAsLiteral, defaultTrimDirectiveWhitespaces, defaultDefaultContentType, defaultBuffer, defaultErrorOnUndeclaredNamespace);
                    this.initialized = true;
                }
            }
        }
    }

    private JspPropertyGroup selectProperty(JspPropertyGroup prev, JspPropertyGroup curr) {
        if (prev == null) {
            return curr;
        }
        if (prev.getExtension() == null) {
            return prev;
        }
        if (curr.getExtension() == null) {
            return curr;
        }
        String prevPath = prev.getPath();
        String currPath = curr.getPath();
        if (prevPath == null && currPath == null) {
            return prev;
        }
        if (prevPath == null && currPath != null) {
            return curr;
        }
        if (prevPath != null && currPath == null) {
            return prev;
        }
        if (prevPath.length() >= currPath.length()) {
            return prev;
        }
        return curr;
    }

    public JspProperty findJspProperty(String uri) {
        this.init();
        if (this.jspProperties == null || uri.endsWith(".tag") || uri.endsWith(".tagx")) {
            return this.defaultJspProperty;
        }
        String uriPath = null;
        int index = uri.lastIndexOf(47);
        if (index >= 0) {
            uriPath = uri.substring(0, index + 1);
        }
        String uriExtension = null;
        index = uri.lastIndexOf(46);
        if (index >= 0) {
            uriExtension = uri.substring(index + 1);
        }
        ArrayList<String> includePreludes = new ArrayList<String>();
        ArrayList<String> includeCodas = new ArrayList<String>();
        JspPropertyGroup isXmlMatch = null;
        JspPropertyGroup elIgnoredMatch = null;
        JspPropertyGroup scriptingInvalidMatch = null;
        JspPropertyGroup pageEncodingMatch = null;
        JspPropertyGroup deferedSyntaxAllowedAsLiteralMatch = null;
        JspPropertyGroup trimDirectiveWhitespacesMatch = null;
        JspPropertyGroup defaultContentTypeMatch = null;
        JspPropertyGroup bufferMatch = null;
        JspPropertyGroup errorOnUndeclaredNamespaceMatch = null;
        for (JspPropertyGroup jpg : this.jspProperties) {
            JspProperty jp = jpg.getJspProperty();
            String extension = jpg.getExtension();
            String path = jpg.getPath();
            if (extension != null ? path != null && uriPath != null && !uriPath.startsWith(path) || !extension.equals("*") && !extension.equals(uriExtension) : !uri.equals(path)) continue;
            if (jp.getIncludePrelude() != null) {
                includePreludes.addAll(jp.getIncludePrelude());
            }
            if (jp.getIncludeCoda() != null) {
                includeCodas.addAll(jp.getIncludeCoda());
            }
            if (jp.isXml() != null) {
                isXmlMatch = this.selectProperty(isXmlMatch, jpg);
            }
            if (jp.isELIgnored() != null) {
                elIgnoredMatch = this.selectProperty(elIgnoredMatch, jpg);
            }
            if (jp.isScriptingInvalid() != null) {
                scriptingInvalidMatch = this.selectProperty(scriptingInvalidMatch, jpg);
            }
            if (jp.getPageEncoding() != null) {
                pageEncodingMatch = this.selectProperty(pageEncodingMatch, jpg);
            }
            if (jp.isDeferedSyntaxAllowedAsLiteral() != null) {
                deferedSyntaxAllowedAsLiteralMatch = this.selectProperty(deferedSyntaxAllowedAsLiteralMatch, jpg);
            }
            if (jp.isTrimDirectiveWhitespaces() != null) {
                trimDirectiveWhitespacesMatch = this.selectProperty(trimDirectiveWhitespacesMatch, jpg);
            }
            if (jp.getDefaultContentType() != null) {
                defaultContentTypeMatch = this.selectProperty(defaultContentTypeMatch, jpg);
            }
            if (jp.getBuffer() != null) {
                bufferMatch = this.selectProperty(bufferMatch, jpg);
            }
            if (jp.isErrorOnUndeclaredNamespace() == null) continue;
            errorOnUndeclaredNamespaceMatch = this.selectProperty(errorOnUndeclaredNamespaceMatch, jpg);
        }
        String isXml = defaultIsXml;
        String isELIgnored = this.defaultIsELIgnored;
        String isScriptingInvalid = defaultIsScriptingInvalid;
        String pageEncoding = null;
        String isDeferedSyntaxAllowedAsLiteral = this.defaultDeferedSyntaxAllowedAsLiteral;
        String isTrimDirectiveWhitespaces = defaultTrimDirectiveWhitespaces;
        String defaultContentType = defaultDefaultContentType;
        String buffer = defaultBuffer;
        String errorOnUndelcaredNamespace = defaultErrorOnUndeclaredNamespace;
        if (isXmlMatch != null) {
            isXml = isXmlMatch.getJspProperty().isXml();
        }
        if (elIgnoredMatch != null) {
            isELIgnored = elIgnoredMatch.getJspProperty().isELIgnored();
        }
        if (scriptingInvalidMatch != null) {
            isScriptingInvalid = scriptingInvalidMatch.getJspProperty().isScriptingInvalid();
        }
        if (pageEncodingMatch != null) {
            pageEncoding = pageEncodingMatch.getJspProperty().getPageEncoding();
        }
        if (deferedSyntaxAllowedAsLiteralMatch != null) {
            isDeferedSyntaxAllowedAsLiteral = deferedSyntaxAllowedAsLiteralMatch.getJspProperty().isDeferedSyntaxAllowedAsLiteral();
        }
        if (trimDirectiveWhitespacesMatch != null) {
            isTrimDirectiveWhitespaces = trimDirectiveWhitespacesMatch.getJspProperty().isTrimDirectiveWhitespaces();
        }
        if (defaultContentTypeMatch != null) {
            defaultContentType = defaultContentTypeMatch.getJspProperty().getDefaultContentType();
        }
        if (bufferMatch != null) {
            buffer = bufferMatch.getJspProperty().getBuffer();
        }
        if (errorOnUndeclaredNamespaceMatch != null) {
            errorOnUndelcaredNamespace = errorOnUndeclaredNamespaceMatch.getJspProperty().isErrorOnUndeclaredNamespace();
        }
        return new JspProperty(isXml, isELIgnored, isScriptingInvalid, pageEncoding, includePreludes, includeCodas, isDeferedSyntaxAllowedAsLiteral, isTrimDirectiveWhitespaces, defaultContentType, buffer, errorOnUndelcaredNamespace);
    }

    public boolean isJspPage(String uri) {
        this.init();
        if (this.jspProperties == null) {
            return false;
        }
        String uriPath = null;
        int index = uri.lastIndexOf(47);
        if (index >= 0) {
            uriPath = uri.substring(0, index + 1);
        }
        String uriExtension = null;
        index = uri.lastIndexOf(46);
        if (index >= 0) {
            uriExtension = uri.substring(index + 1);
        }
        for (JspPropertyGroup jpg : this.jspProperties) {
            String extension = jpg.getExtension();
            String path = jpg.getPath();
            if (!(extension == null ? uri.equals(path) : !(path != null && !path.equals(uriPath) || !extension.equals("*") && !extension.equals(uriExtension)))) continue;
            return true;
        }
        return false;
    }

    public static class JspProperty {
        private final String isXml;
        private final String elIgnored;
        private final String scriptingInvalid;
        private final String pageEncoding;
        private final Collection<String> includePrelude;
        private final Collection<String> includeCoda;
        private final String deferedSyntaxAllowedAsLiteral;
        private final String trimDirectiveWhitespaces;
        private final String defaultContentType;
        private final String buffer;
        private final String errorOnUndeclaredNamespace;

        public JspProperty(String isXml, String elIgnored, String scriptingInvalid, String pageEncoding, Collection<String> includePrelude, Collection<String> includeCoda, String deferedSyntaxAllowedAsLiteral, String trimDirectiveWhitespaces, String defaultContentType, String buffer, String errorOnUndeclaredNamespace) {
            this.isXml = isXml;
            this.elIgnored = elIgnored;
            this.scriptingInvalid = scriptingInvalid;
            this.pageEncoding = pageEncoding;
            this.includePrelude = includePrelude;
            this.includeCoda = includeCoda;
            this.deferedSyntaxAllowedAsLiteral = deferedSyntaxAllowedAsLiteral;
            this.trimDirectiveWhitespaces = trimDirectiveWhitespaces;
            this.defaultContentType = defaultContentType;
            this.buffer = buffer;
            this.errorOnUndeclaredNamespace = errorOnUndeclaredNamespace;
        }

        public String isXml() {
            return this.isXml;
        }

        public String isELIgnored() {
            return this.elIgnored;
        }

        public String isScriptingInvalid() {
            return this.scriptingInvalid;
        }

        public String getPageEncoding() {
            return this.pageEncoding;
        }

        public Collection<String> getIncludePrelude() {
            return this.includePrelude;
        }

        public Collection<String> getIncludeCoda() {
            return this.includeCoda;
        }

        public String isDeferedSyntaxAllowedAsLiteral() {
            return this.deferedSyntaxAllowedAsLiteral;
        }

        public String isTrimDirectiveWhitespaces() {
            return this.trimDirectiveWhitespaces;
        }

        public String getDefaultContentType() {
            return this.defaultContentType;
        }

        public String getBuffer() {
            return this.buffer;
        }

        public String isErrorOnUndeclaredNamespace() {
            return this.errorOnUndeclaredNamespace;
        }
    }

    public static class JspPropertyGroup {
        private final String path;
        private final String extension;
        private final JspProperty jspProperty;

        JspPropertyGroup(String path, String extension, JspProperty jspProperty) {
            this.path = path;
            this.extension = extension;
            this.jspProperty = jspProperty;
        }

        public String getPath() {
            return this.path;
        }

        public String getExtension() {
            return this.extension;
        }

        public JspProperty getJspProperty() {
            return this.jspProperty;
        }
    }
}

