/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction {
    private ZooKeeper zk;
    private List<Op> ops = new ArrayList<Op>();

    protected Transaction(ZooKeeper zk) {
        this.zk = zk;
    }

    public Transaction create(String path, byte[] data, List<ACL> acl, CreateMode createMode) {
        this.ops.add(Op.create(path, data, acl, createMode.toFlag()));
        return this;
    }

    public Transaction delete(String path, int version) {
        this.ops.add(Op.delete(path, version));
        return this;
    }

    public Transaction check(String path, int version) {
        this.ops.add(Op.check(path, version));
        return this;
    }

    public Transaction setData(String path, byte[] data, int version) {
        this.ops.add(Op.setData(path, data, version));
        return this;
    }

    public List<OpResult> commit() throws InterruptedException, KeeperException {
        return this.zk.multi(this.ops);
    }

    public void commit(AsyncCallback.MultiCallback cb, Object ctx) {
        this.zk.multi(this.ops, cb, ctx);
    }
}

