/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.ArrayElement;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class StringElement
extends AtomicElement<String> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final String _value;

    StringElement(Element parent, Element prev, String s) {
        super(parent, prev);
        this._value = s;
    }

    @Override
    public int size() {
        int length = this._value.getBytes(UTF_8).length;
        return this.size(length);
    }

    private int size(int length) {
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (length > 255) {
                    parent.setConstructorType(ArrayElement.LARGE);
                    return 4 + length;
                }
                return 1 + length;
            }
            return 4 + length;
        }
        if (length > 255) {
            return 5 + length;
        }
        return 2 + length;
    }

    @Override
    public String getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.STRING;
    }

    @Override
    public int encode(ByteBuffer b) {
        byte[] bytes = this._value.getBytes(UTF_8);
        int length = bytes.length;
        int size2 = this.size(length);
        if (b.remaining() < size2) {
            return 0;
        }
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                b.put((byte)length);
            } else {
                b.putInt(length);
            }
        } else if (length <= 255) {
            b.put((byte)-95);
            b.put((byte)length);
        } else {
            b.put((byte)-79);
            b.put((byte)length);
        }
        b.put(bytes);
        return size2;
    }
}

