/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import antlr.StringUtils;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public class HostResourceSwRunMonitor
extends SnmpMonitorStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(HostResourceSwRunMonitor.class);
    private static final String HOSTRESOURCE_SW_NAME_OID = ".1.3.6.1.2.1.25.4.2.1.2";
    private static final String HOSTRESOURCE_SW_STATUS_OID = ".1.3.6.1.2.1.25.4.2.1.7";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        String reason;
        boolean maxOk;
        boolean minOk;
        String reason2;
        InetAddress ipaddr = svc.getAddress();
        SnmpAgentConfig agentConfig = this.getAgentConfig(svc, parameters);
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        LOG.debug("poll: setting SNMP peer attribute for interface {}", (Object)hostAddress);
        String serviceNameOid = ParameterMap.getKeyedString(parameters, (String)"service-name-oid", (String)HOSTRESOURCE_SW_NAME_OID);
        String serviceStatusOid = ParameterMap.getKeyedString(parameters, (String)"service-status-oid", (String)HOSTRESOURCE_SW_STATUS_OID);
        String serviceName = ParameterMap.getKeyedString(parameters, (String)"service-name", null);
        String matchAll = ParameterMap.getKeyedString(parameters, (String)"match-all", (String)"false");
        String runLevel = ParameterMap.getKeyedString(parameters, (String)"run-level", (String)"2");
        int minServices = ParameterMap.getKeyedInteger(parameters, (String)"min-services", (int)-1);
        int maxServices = ParameterMap.getKeyedInteger(parameters, (String)"max-services", (int)-1);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        LOG.debug("poll: service= SNMP address= {}", (Object)agentConfig);
        PollStatus status = PollStatus.unavailable((String)("HostResourceSwRunMonitor service not found, addr=" + hostAddress + ", service-name=" + serviceName));
        int matches = 0;
        try {
            LOG.debug("HostResourceSwRunMonitor.poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            if (serviceName == null) {
                status.setReason("HostResourceSwRunMonitor no service-name defined, addr=" + hostAddress);
                LOG.warn("HostResourceSwRunMonitor.poll: No Service Name Defined! ");
                return status;
            }
            if (minServices > 0 && maxServices > 0 && minServices >= maxServices) {
                String reason3 = "min-services(" + minServices + ") should be less than max-services(" + maxServices + ")";
                status.setReason("HostResourceSwRunMonitor " + reason3 + ", addr=" + hostAddress + ", service-name=" + serviceName);
                LOG.warn("HostResourceSwRunMonitor.poll: {}.", (Object)reason3);
                return status;
            }
            final SnmpObjId serviceNameOidId = SnmpObjId.get((String)serviceNameOid);
            final SnmpObjId serviceStatusOidId = SnmpObjId.get((String)serviceStatusOid);
            final HashMap nameResults = new HashMap();
            final HashMap statusResults = new HashMap();
            RowCallback callback = new RowCallback(){

                public void rowCompleted(SnmpRowResult result) {
                    nameResults.put(result.getInstance(), result.getValue(serviceNameOidId));
                    statusResults.put(result.getInstance(), result.getValue(serviceStatusOidId));
                }
            };
            TimeoutTracker tracker = new TimeoutTracker(parameters, agentConfig.getRetries(), agentConfig.getTimeout());
            tracker.reset();
            tracker.startAttempt();
            TableTracker tableTracker = new TableTracker(callback, new SnmpObjId[]{serviceNameOidId, serviceStatusOidId});
            try (SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"HostResourceSwRunMonitor", (CollectionTracker)tableTracker);){
                walker.start();
                walker.waitFor();
                String error = walker.getErrorMessage();
                if (error != null && !error.trim().equals("")) {
                    LOG.warn(error);
                    PollStatus pollStatus = PollStatus.unavailable((String)error);
                    return pollStatus;
                }
            }
            for (SnmpInstId nameInstance : nameResults.keySet()) {
                SnmpValue name = (SnmpValue)nameResults.get(nameInstance);
                SnmpValue value = (SnmpValue)statusResults.get(nameInstance);
                if (name == null || value == null || !this.match(serviceName, HostResourceSwRunMonitor.stripExtraQuotes(name.toString()))) continue;
                ++matches;
                LOG.debug("poll: HostResourceSwRunMonitor poll succeeded, addr={}, service-name={}, value={}", new Object[]{hostAddress, serviceName, nameResults.get(nameInstance)});
                if (!this.meetsCriteria(value, "<=", runLevel)) {
                    String reason4 = "HostResourceSwRunMonitor poll failed, addr=" + hostAddress + ", service-name=" + serviceName + ", status=" + statusResults.get(nameInstance);
                    LOG.debug(reason4);
                    return PollStatus.unavailable((String)reason4);
                }
                status = PollStatus.available((Double)tracker.elapsedTimeInMillis());
                if (!"false".equals(matchAll)) continue;
                return status;
            }
            LOG.debug("poll: HostResourceSwRunMonitor the number of matches found for {} was {}", (Object)serviceName, (Object)matches);
        }
        catch (NumberFormatException e) {
            reason2 = "Number operator used on a non-number " + e.getMessage();
            LOG.debug(reason2);
            status = PollStatus.unavailable((String)reason2);
        }
        catch (IllegalArgumentException e) {
            reason2 = "Invalid SNMP Criteria: " + e.getMessage();
            LOG.debug(reason2);
            status = PollStatus.unavailable((String)reason2);
        }
        catch (Throwable t) {
            String reason22 = "Unexpected exception during SNMP poll of interface " + hostAddress;
            LOG.debug(reason22, t);
            status = PollStatus.unavailable((String)reason22);
        }
        boolean bl = minServices > 0 ? matches >= minServices : (minOk = true);
        boolean bl2 = maxServices > 0 ? matches <= maxServices : (maxOk = true);
        if (!minOk && maxServices < 0) {
            reason = "HostResourceSwRunMonitor poll failed: service-count(" + matches + ") >= min-services(" + minServices + "), addr=" + hostAddress + ", service-name=" + serviceName;
            LOG.debug(reason);
            status = PollStatus.unavailable((String)reason);
        }
        if (!maxOk && minServices < 0) {
            reason = "HostResourceSwRunMonitor poll failed: service-count(" + matches + ") <= max-services(" + maxServices + "), addr=" + hostAddress + ", service-name=" + serviceName;
            LOG.debug(reason);
            status = PollStatus.unavailable((String)reason);
        }
        if (minOk) {
            if (maxOk) return status;
        }
        if (minServices <= 0) return status;
        if (maxServices <= 0) return status;
        reason = "HostResourceSwRunMonitor poll failed: min-services(" + minServices + ") >= service-count(" + matches + ") <= max-services(" + maxServices + "), addr=" + hostAddress + ", service-name=" + serviceName;
        LOG.debug(reason);
        return PollStatus.unavailable((String)reason);
    }

    private boolean match(String expectedText, String currentText) {
        if (expectedText.startsWith("~")) {
            return currentText.matches(expectedText.replaceFirst("~", ""));
        }
        return currentText.equalsIgnoreCase(expectedText);
    }

    private static String stripExtraQuotes(String string) {
        String stripped;
        try {
            stripped = StringUtils.stripFrontBack((String)string, (String)"\"", (String)"\"");
        }
        catch (StringIndexOutOfBoundsException e) {
            stripped = string;
        }
        return stripped;
    }
}

