/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.SnmpInterfacePollerConfig;
import org.opennms.netmgt.config.SnmpInterfacePollerConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnmpInterfacePollerConfigFactory
extends SnmpInterfacePollerConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpInterfacePollerConfigFactory.class);
    private static SnmpInterfacePollerConfig m_singleton = null;
    private static boolean m_loaded = false;
    private long m_currentVersion = -1L;

    public SnmpInterfacePollerConfigFactory(long currentVersion, InputStream stream, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        super(stream, localServer, verifyServer);
        this.m_currentVersion = currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        OpennmsServerConfigFactory.init();
        OpennmsServerConfigFactory onmsSvrConfig = OpennmsServerConfigFactory.getInstance();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_INTERFACE_POLLER_CONFIG_FILE_NAME);
        LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(cfgFile);
            SnmpInterfacePollerConfigFactory config = new SnmpInterfacePollerConfigFactory(cfgFile.lastModified(), stream, onmsSvrConfig.getServerName(), onmsSvrConfig.verifyServer());
            SnmpInterfacePollerConfigFactory.setInstance(config);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        SnmpInterfacePollerConfigFactory.init();
        SnmpInterfacePollerConfigFactory.getInstance().update();
    }

    @Override
    protected synchronized void saveXml(String xml) throws IOException {
        if (xml != null) {
            long timestamp = System.currentTimeMillis();
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_INTERFACE_POLLER_CONFIG_FILE_NAME);
            LOG.debug("saveXml: saving config file at {}: {}", (Object)timestamp, (Object)cfgFile.getPath());
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
            fileWriter.write(xml);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
            LOG.debug("saveXml: finished saving config file: {}", (Object)cfgFile.getPath());
        }
    }

    public static synchronized SnmpInterfacePollerConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(SnmpInterfacePollerConfig instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    @Override
    public synchronized void update() throws IOException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_INTERFACE_POLLER_CONFIG_FILE_NAME);
        if (cfgFile.lastModified() > this.m_currentVersion) {
            this.m_currentVersion = cfgFile.lastModified();
            LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(cfgFile);
                this.reloadXML(stream);
            }
            finally {
                if (stream != null) {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
            LOG.debug("init: finished loading config file: {}", (Object)cfgFile.getPath());
        }
    }
}

