/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.web;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProxySelector;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.opennms.core.web.HttpRequestRetryOnExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientWrapper
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientWrapper.class);
    private CloseableHttpClient m_httpClient;
    private CookieStore m_cookieStore;
    private boolean m_useLaxRedirect = false;
    private boolean m_reuseConnections = true;
    private boolean m_usePreemptiveAuth = false;
    private boolean m_useSystemProxySettings;
    private String m_cookieSpec;
    private String m_username;
    private String m_password;
    private Integer m_socketTimeout;
    private Integer m_connectionTimeout;
    private Integer m_retries;
    private Map<String, SSLContext> m_sslContext = new HashMap<String, SSLContext>();
    private Set<HttpRequestInterceptor> m_requestInterceptors = new LinkedHashSet<HttpRequestInterceptor>();
    private Set<HttpResponseInterceptor> m_responseInterceptors = new LinkedHashSet<HttpResponseInterceptor>();
    private String m_userAgent;
    private String m_virtualHost;
    private HttpVersion m_version;

    protected HttpClientWrapper() {
        this.m_cookieStore = new BasicCookieStore();
        this.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                Header host = request.getFirstHeader("Host");
                if (host != null && (host.getValue().endsWith(":80") || host.getValue().endsWith(":443"))) {
                    request.setHeader("Host", host.getValue().replaceFirst(":\\d+", ""));
                    LOG.info("httpRequestInterceptor: removing default port from host header");
                }
            }
        });
    }

    public static HttpClientWrapper create() {
        return new HttpClientWrapper();
    }

    public HttpClientWrapper addBasicCredentials(String username, String password) {
        LOG.debug("addBasicCredentials: username={}", (Object)username);
        this.assertNotInitialized();
        this.m_username = username;
        this.m_password = password;
        return this;
    }

    public HttpClientWrapper addRequestInterceptor(HttpRequestInterceptor interceptor) {
        LOG.debug("addRequestInterceptor: {}", (Object)interceptor);
        this.assertNotInitialized();
        this.m_requestInterceptors.add(interceptor);
        return this;
    }

    public HttpClientWrapper addResponseInterceptor(HttpResponseInterceptor interceptor) {
        LOG.debug("addResponseInterceptor: {}", (Object)interceptor);
        this.assertNotInitialized();
        this.m_responseInterceptors.add(interceptor);
        return this;
    }

    public HttpClientWrapper dontReuseConnections() {
        LOG.debug("dontReuseConnections()");
        this.assertNotInitialized();
        this.m_reuseConnections = false;
        return this;
    }

    public HttpClientWrapper useSystemProxySettings() {
        LOG.debug("useSystemProxySettings()");
        this.assertNotInitialized();
        this.m_useSystemProxySettings = true;
        return this;
    }

    public HttpClientWrapper useBrowserCompatibleCookies() {
        LOG.debug("useBrowserCompatibleCookies()");
        this.assertNotInitialized();
        this.m_cookieSpec = "compatibility";
        return this;
    }

    public HttpClientWrapper useRelaxedSSL(String scheme) throws GeneralSecurityException {
        LOG.debug("useRelaxedSSL: scheme={}", (Object)scheme);
        this.assertNotInitialized();
        this.m_sslContext.put(scheme, SSLContext.getInstance("EmptyKeyRelaxedTrust"));
        return this;
    }

    public HttpClientWrapper trustSelfSigned(String scheme) throws GeneralSecurityException {
        LOG.debug("trustSelfSigned: scheme={}", (Object)scheme);
        this.assertNotInitialized();
        this.m_sslContext.put(scheme, SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).useTLS().build());
        return this;
    }

    public HttpClientWrapper usePreemptiveAuth() {
        LOG.debug("usePreemptiveAuth()");
        this.assertNotInitialized();
        this.m_usePreemptiveAuth = true;
        return this;
    }

    public HttpClientWrapper useLaxRedirect() {
        LOG.debug("useLaxRedirect()");
        this.assertNotInitialized();
        this.m_useLaxRedirect = true;
        return this;
    }

    public HttpClientWrapper setSocketTimeout(Integer socketTimeout) {
        LOG.debug("setSocketTimeout: timeout={}", (Object)socketTimeout);
        this.assertNotInitialized();
        this.m_socketTimeout = socketTimeout;
        return this;
    }

    public HttpClientWrapper setConnectionTimeout(Integer connectionTimeout) {
        LOG.debug("setConnectionTimeout: timeout={}", (Object)connectionTimeout);
        this.assertNotInitialized();
        this.m_connectionTimeout = connectionTimeout;
        return this;
    }

    public HttpClientWrapper setRetries(Integer retries) {
        LOG.debug("setRetries: retries={}", (Object)retries);
        this.assertNotInitialized();
        this.m_retries = retries;
        return this;
    }

    public HttpClientWrapper setUserAgent(String userAgent) {
        LOG.debug("setUserAgent: userAgent={}", (Object)userAgent);
        this.assertNotInitialized();
        this.m_userAgent = userAgent;
        return this;
    }

    public HttpClientWrapper setVirtualHost(String host) {
        LOG.debug("setVirtualHost: host={}", (Object)host);
        this.assertNotInitialized();
        this.m_virtualHost = host;
        return this;
    }

    public HttpClientWrapper setVersion(HttpVersion httpVersion) {
        LOG.debug("setVersion: version={}", (Object)httpVersion);
        this.assertNotInitialized();
        this.m_version = httpVersion;
        return this;
    }

    public void close(CloseableHttpResponse response) {
        if (response != null) {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            IOUtils.closeQuietly((Closeable)response);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.m_httpClient != null) {
            this.m_httpClient.close();
        }
    }

    public CloseableHttpResponse execute(HttpUriRequest method) throws ClientProtocolException, IOException {
        LOG.debug("execute: " + this.toString() + "; method: " + method.toString());
        HttpRequestWrapper requestWrapper = HttpRequestWrapper.wrap((HttpRequest)method);
        if (!HttpClientWrapper.isEmpty(this.m_userAgent)) {
            requestWrapper.setHeader("User-Agent", this.m_userAgent);
        }
        if (!HttpClientWrapper.isEmpty(this.m_virtualHost)) {
            requestWrapper.setHeader("Host", this.m_virtualHost);
        }
        if (this.m_version != null) {
            if (HttpVersion.HTTP_1_1.equals((Object)this.m_version) && HttpClientWrapper.isEmpty(this.m_virtualHost)) {
                requestWrapper.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
            } else {
                requestWrapper.setProtocolVersion((ProtocolVersion)this.m_version);
            }
        }
        return this.getClient().execute((HttpUriRequest)requestWrapper);
    }

    public HttpClientWrapper duplicate() {
        HttpClientWrapper ret = HttpClientWrapper.create();
        ret.m_cookieStore = this.m_cookieStore;
        ret.m_reuseConnections = this.m_reuseConnections;
        ret.m_usePreemptiveAuth = this.m_usePreemptiveAuth;
        ret.m_useSystemProxySettings = this.m_useSystemProxySettings;
        ret.m_cookieSpec = this.m_cookieSpec;
        ret.m_username = this.m_username;
        ret.m_password = this.m_password;
        ret.m_socketTimeout = this.m_socketTimeout;
        ret.m_connectionTimeout = this.m_connectionTimeout;
        ret.m_retries = this.m_retries;
        for (Map.Entry<String, SSLContext> entry : ret.m_sslContext.entrySet()) {
            ret.m_sslContext.put(entry.getKey(), entry.getValue());
        }
        for (HttpRequestInterceptor httpRequestInterceptor : this.m_requestInterceptors) {
            ret.m_requestInterceptors.add(httpRequestInterceptor);
        }
        for (HttpResponseInterceptor httpResponseInterceptor : this.m_responseInterceptors) {
            ret.m_responseInterceptors.add(httpResponseInterceptor);
        }
        ret.m_userAgent = this.m_userAgent;
        ret.m_virtualHost = this.m_virtualHost;
        ret.m_version = this.m_version;
        return ret;
    }

    public CloseableHttpClient getClient() {
        if (this.m_httpClient == null) {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            if (!this.m_reuseConnections) {
                httpClientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
            }
            if (this.m_usePreemptiveAuth) {
                this.enablePreemptiveAuth(httpClientBuilder);
            }
            if (this.m_useSystemProxySettings) {
                httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
            }
            if (!HttpClientWrapper.isEmpty(this.m_cookieSpec)) {
                requestConfigBuilder.setCookieSpec(this.m_cookieSpec);
            }
            if (this.m_cookieStore != null) {
                httpClientBuilder.setDefaultCookieStore(this.m_cookieStore);
            }
            if (this.m_username != null) {
                this.setCredentials(httpClientBuilder, this.m_username, this.m_password);
            }
            if (this.m_socketTimeout != null) {
                requestConfigBuilder.setSocketTimeout(this.m_socketTimeout.intValue());
            }
            if (this.m_connectionTimeout != null) {
                requestConfigBuilder.setConnectTimeout(this.m_connectionTimeout.intValue());
            }
            if (this.m_retries != null) {
                httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new HttpRequestRetryOnExceptionHandler(this.m_retries, false));
            }
            if (this.m_sslContext.size() != 0) {
                this.configureSSLContext(httpClientBuilder);
            }
            for (HttpRequestInterceptor httpRequestInterceptor : this.m_requestInterceptors) {
                httpClientBuilder.addInterceptorLast(httpRequestInterceptor);
            }
            for (HttpResponseInterceptor httpResponseInterceptor : this.m_responseInterceptors) {
                httpClientBuilder.addInterceptorLast(httpResponseInterceptor);
            }
            if (this.m_useLaxRedirect) {
                httpClientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
            }
            httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            this.m_httpClient = httpClientBuilder.build();
        }
        return this.m_httpClient;
    }

    protected void assertNotInitialized() {
        if (this.m_httpClient != null) {
            throw new IllegalStateException("HttpClientWrapper has already created an HttpClient!  You cannot change configuration any more.");
        }
    }

    protected void setCredentials(HttpClientBuilder httpClientBuilder, String username, String password) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    protected void enablePreemptiveAuth(HttpClientBuilder builder) {
        HttpRequestInterceptor preemptiveAuth = new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws IOException {
                if (context instanceof HttpClientContext) {
                    AuthScope authScope;
                    Credentials creds;
                    HttpClientContext clientContext = (HttpClientContext)context;
                    AuthState authState = clientContext.getTargetAuthState();
                    CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
                    HttpHost targetHost = clientContext.getTargetHost();
                    if (authState.getAuthScheme() == null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                        authState.update((AuthScheme)new BasicScheme(), creds);
                    }
                } else {
                    throw new IllegalArgumentException("Not sure how to handle a non-HttpClientContext context.");
                }
            }
        };
        builder.addInterceptorFirst(preemptiveAuth);
    }

    protected void configureSSLContext(HttpClientBuilder builder) {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        for (Map.Entry<String, SSLContext> entry : this.m_sslContext.entrySet()) {
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(entry.getValue(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            registryBuilder.register(entry.getKey(), (Object)sslConnectionFactory);
        }
        if (!this.m_sslContext.containsKey("http")) {
            registryBuilder.register("http", (Object)PlainConnectionSocketFactory.INSTANCE);
        }
        if (!this.m_sslContext.containsKey("https")) {
            registryBuilder.register("https", (Object)SSLConnectionSocketFactory.getSystemSocketFactory());
        }
        BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager((Lookup)registryBuilder.build());
        builder.setConnectionManager((HttpClientConnectionManager)ccm);
    }

    public String toString() {
        return "HttpClientWrapper [reuseConnections=" + this.m_reuseConnections + ", usePreemptiveAuth=" + this.m_usePreemptiveAuth + ", useSystemProxySettings=" + this.m_useSystemProxySettings + ", cookieSpec=" + this.m_cookieSpec + ", username=" + this.m_username + ", password=" + this.m_password + ", socketTimeout=" + this.m_socketTimeout + ", connectionTimeout=" + this.m_connectionTimeout + ", retries=" + this.m_retries + ", sslContext=" + this.m_sslContext + ", requestInterceptors=" + this.m_requestInterceptors + ", responseInterceptors=" + this.m_responseInterceptors + ", userAgent=" + this.m_userAgent + ", virtualHost=" + this.m_virtualHost + ", version=" + this.m_version + "]";
    }

    private static boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }
}

