/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.topology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.SharedSegment;

public class BroadcastDomain {
    volatile Set<Bridge> m_bridges = new HashSet<Bridge>();
    volatile List<SharedSegment> m_topology = new ArrayList<SharedSegment>();
    boolean m_lock = false;
    Object m_locker;

    public Set<String> getBridgeMacAddresses(Integer bridgeid) {
        HashSet<String> bridgemacaddresses = new HashSet<String>();
        Bridge bridge = this.getBridge(bridgeid);
        if (bridge != null) {
            for (BridgeElement element : bridge.getBridgeElements()) {
                if (!InetAddressUtils.isValidBridgeAddress((String)element.getBaseBridgeAddress())) continue;
                bridgemacaddresses.add(element.getBaseBridgeAddress());
            }
        }
        return bridgemacaddresses;
    }

    public List<BridgeElement> getBridgeElements() {
        ArrayList<BridgeElement> elements = new ArrayList<BridgeElement>();
        for (Bridge bridge : this.m_bridges) {
            for (BridgeElement element : bridge.getBridgeElements()) {
                elements.add(element);
            }
        }
        return elements;
    }

    public void setBridgeElements(List<BridgeElement> bridgeelements) {
        for (Bridge bridge : this.m_bridges) {
            bridge.clearBridgeElement();
        }
        for (BridgeElement element : bridgeelements) {
            for (Bridge bridge : this.m_bridges) {
                if (bridge.addBridgeElement(element)) break;
            }
        }
    }

    public void clearTopology() {
        this.m_topology.clear();
    }

    public boolean isEmpty() {
        return this.m_bridges.isEmpty();
    }

    public Set<Integer> getBridgeNodesOnDomain() {
        HashSet<Integer> bridgeIds = new HashSet<Integer>();
        for (Bridge bridge : this.m_bridges) {
            bridgeIds.add(bridge.getId());
        }
        return bridgeIds;
    }

    public synchronized boolean getLock(Object locker) {
        if (this.m_lock) {
            return false;
        }
        if (locker == null) {
            return false;
        }
        this.m_lock = true;
        this.m_locker = locker;
        return true;
    }

    public synchronized boolean releaseLock(Object locker) {
        if (locker == null) {
            return false;
        }
        if (!this.m_lock) {
            return false;
        }
        if (!this.m_locker.equals(locker)) {
            return false;
        }
        this.m_locker = null;
        this.m_lock = false;
        return true;
    }

    public Set<Bridge> getBridges() {
        return this.m_bridges;
    }

    public List<SharedSegment> getTopology() {
        return this.m_topology;
    }

    public boolean hasRootBridge() {
        for (Bridge bridge : this.m_bridges) {
            if (!bridge.isRootBridge()) continue;
            return true;
        }
        return false;
    }

    public Integer getRootBridgeId() {
        for (Bridge bridge : this.m_bridges) {
            if (!bridge.isRootBridge()) continue;
            return bridge.getId();
        }
        return null;
    }

    public Bridge getRootBridge() {
        for (Bridge bridge : this.m_bridges) {
            if (!bridge.isRootBridge()) continue;
            return bridge;
        }
        return null;
    }

    public void addBridge(Bridge bridge) {
        if (this.m_bridges.contains(bridge)) {
            return;
        }
        this.m_bridges.add(bridge);
    }

    public Bridge getBridge(int bridgeId) {
        for (Bridge bridge : this.m_bridges) {
            if (bridge.getId() != bridgeId) continue;
            return bridge;
        }
        return null;
    }

    public Set<String> getMacsOnDomain() {
        HashSet<String> macs = new HashSet<String>();
        for (SharedSegment segment : this.m_topology) {
            macs.addAll(segment.getMacsOnSegment());
        }
        return macs;
    }

    public void add(SharedSegment segment) {
        this.m_topology.add(segment);
    }

    public void loadTopologyEntry(SharedSegment segment) {
        segment.setBroadcastDomain(this);
        this.m_topology.add(segment);
    }

    public boolean containsAtleastOne(Set<Integer> nodeids) {
        for (Bridge bridge : this.m_bridges) {
            for (Integer nodeid : nodeids) {
                if (bridge.getId().intValue() != nodeid.intValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containBridgeId(int nodeid) {
        for (Bridge bridge : this.m_bridges) {
            if (bridge.getId() != nodeid) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeBridge(int bridgeId) {
        Bridge bridge = null;
        for (Bridge curbridge : this.m_bridges) {
            if (curbridge.getId() != bridgeId) continue;
            bridge = curbridge;
            break;
        }
        if (bridge == null) {
            return;
        }
        if (this.m_bridges.size() == 1) {
            this.m_topology.clear();
            this.m_bridges.clear();
            return;
        }
        HashSet<Bridge> bridges = new HashSet<Bridge>();
        for (Bridge cur : this.m_bridges) {
            if (cur.getId() == bridgeId) continue;
            bridges.add(cur);
        }
        this.m_bridges = bridges;
    }

    public List<SharedSegment> getSharedSegmentOnTopologyForBridge(Integer bridgeId) {
        ArrayList<SharedSegment> segmentsOnBridge = new ArrayList<SharedSegment>();
        for (SharedSegment segment : this.m_topology) {
            if (!segment.getBridgeIdsOnSegment().contains(bridgeId)) continue;
            segmentsOnBridge.add(segment);
        }
        return segmentsOnBridge;
    }

    public List<SharedSegment> removeSharedSegmentOnTopologyForBridge(Integer bridgeId) {
        ArrayList<SharedSegment> segmentsOnBridge = new ArrayList<SharedSegment>();
        ArrayList<SharedSegment> topology = new ArrayList<SharedSegment>();
        for (SharedSegment segment : this.m_topology) {
            if (segment.getBridgeIdsOnSegment().contains(bridgeId)) {
                segmentsOnBridge.add(segment);
                continue;
            }
            topology.add(segment);
        }
        this.m_topology = topology;
        return segmentsOnBridge;
    }

    public Set<Bridge> getBridgeOnSharedSegment(SharedSegment segment) {
        HashSet<Integer> nodeidsOnSegment = new HashSet<Integer>(segment.getBridgeIdsOnSegment());
        HashSet<Bridge> bridgesOn = new HashSet<Bridge>();
        for (Bridge bridge : this.m_bridges) {
            if (!nodeidsOnSegment.contains(bridge.getId())) continue;
            bridgesOn.add(bridge);
        }
        return bridgesOn;
    }

    public SharedSegment getSharedSegment(Integer bridgeId, Integer bridgePort) {
        if (bridgeId == null || bridgePort == null) {
            return null;
        }
        for (SharedSegment segment : this.m_topology) {
            if (!segment.containsPort(bridgeId, bridgePort)) continue;
            return segment;
        }
        return null;
    }

    public void hierarchySetUp(Bridge root) {
        if (root.isRootBridge()) {
            return;
        }
        root.setRootBridge(true);
        root.setRootPort(null);
        if (this.m_bridges.size() == 1) {
            return;
        }
        for (SharedSegment segment : this.getSharedSegmentOnTopologyForBridge(root.getId())) {
            segment.setDesignatedBridge(root.getId());
            this.tier(segment, root.getId());
        }
    }

    private void tier(SharedSegment segment, Integer rootid) {
        for (Integer bridgeid : segment.getBridgeIdsOnSegment()) {
            if (bridgeid.intValue() == rootid.intValue()) continue;
            Bridge bridge = this.getBridge(bridgeid);
            bridge.setRootPort(segment.getPortForBridge(bridgeid));
            bridge.setRootBridge(false);
            for (SharedSegment s2 : this.getSharedSegmentOnTopologyForBridge(bridgeid)) {
                if (s2.getDesignatedBridge() != null && s2.getDesignatedBridge().intValue() == rootid.intValue()) continue;
                s2.setDesignatedBridge(bridgeid);
                this.tier(s2, bridgeid);
            }
        }
    }

    public void clearTopologyForBridge(Integer bridgeId) {
        Bridge bridge = this.getBridge(bridgeId);
        if (bridge == null) {
            return;
        }
        SharedSegment topsegment = this.getSharedSegment(bridge.getId(), bridge.getRootPort());
        if (bridge.isRootBridge()) {
            for (SharedSegment segment : this.getSharedSegmentOnTopologyForBridge(bridgeId)) {
                Integer newRootId = segment.getFirstNoDesignatedBridge();
                if (newRootId == null) continue;
                Bridge newRootBridge = null;
                for (Bridge curBridge : this.getBridges()) {
                    if (curBridge.getId().intValue() != newRootId.intValue()) continue;
                    newRootBridge = curBridge;
                    System.out.println("root bridge" + newRootBridge.getId());
                    break;
                }
                if (newRootBridge == null) continue;
                topsegment = this.getSharedSegment(newRootId, newRootBridge.getRootPort());
                this.hierarchySetUp(newRootBridge);
                break;
            }
        }
        if (topsegment != null) {
            topsegment.removeBridge(bridge.getId());
        }
        for (SharedSegment segment : this.removeSharedSegmentOnTopologyForBridge(bridge.getId())) {
            if (topsegment == null) continue;
            topsegment.mergeBridge(segment, bridge.getId());
        }
    }

    public List<BridgeMacLink> calculateRootBFT() {
        Bridge root = this.getRootBridge();
        if (root == null) {
            return null;
        }
        return this.calculateBFT(root);
    }

    public List<BridgeMacLink> calculateBFT(Bridge bridge) {
        HashMap bft = new HashMap();
        Integer bridgeId = bridge.getId();
        ArrayList<BridgeMacLink> links = new ArrayList<BridgeMacLink>();
        OnmsNode node = new OnmsNode();
        node.setId(bridgeId);
        for (SharedSegment segment : this.getTopology()) {
            Set<String> macs = segment.getMacsOnSegment();
            if (macs == null || macs.isEmpty()) continue;
            Integer bridgeport = this.goUp(segment, bridge, 0);
            if (!bft.containsKey(bridgeport)) {
                bft.put(bridgeport, new HashSet());
            }
            ((Set)bft.get(bridgeport)).addAll(macs);
        }
        for (Integer bridgePort : bft.keySet()) {
            for (String mac : (Set)bft.get(bridgePort)) {
                BridgeMacLink link = new BridgeMacLink();
                link.setNode(node);
                link.setBridgePort(bridgePort);
                link.setMacAddress(mac);
                link.setBridgeDot1qTpFdbStatus(BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
                links.add(link);
            }
        }
        return links;
    }

    private Integer goUp(SharedSegment down, Bridge bridge, int level) {
        if (level == 30) {
            this.clearTopology();
            return -1;
        }
        Integer upBridgeId = down.getDesignatedBridge();
        if (upBridgeId.intValue() == bridge.getId().intValue()) {
            return down.getDesignatedPort();
        }
        if (upBridgeId.intValue() == this.getRootBridgeId().intValue()) {
            return bridge.getRootPort();
        }
        Bridge upBridge = null;
        for (Bridge cbridge : this.getBridges()) {
            if (cbridge.getId().intValue() == bridge.getId().intValue() || cbridge.getId().intValue() != upBridgeId.intValue()) continue;
            upBridge = cbridge;
            break;
        }
        if (upBridge == null) {
            return null;
        }
        SharedSegment up = this.getSharedSegment(upBridge.getId(), upBridge.getRootPort());
        if (up == null) {
            return null;
        }
        return this.goUp(up, bridge, ++level);
    }

    public void clear() {
        this.m_topology.clear();
        this.m_bridges.clear();
    }

    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("\n------broadcast domain-----\n");
        strbfr.append("domain bridges:");
        strbfr.append(this.getBridgeNodesOnDomain());
        strbfr.append("\n");
        strbfr.append("domain macs: ");
        strbfr.append(this.getMacsOnDomain());
        strbfr.append("\n");
        if (this.hasRootBridge()) {
            HashSet<Integer> rootids = new HashSet<Integer>();
            rootids.add(this.getRootBridgeId());
            strbfr.append("rootbridge: ");
            strbfr.append(this.getRootBridgeId());
            strbfr.append("\n");
            strbfr.append(this.printTopologyFromLevel(rootids, 0));
        } else {
            for (SharedSegment shared : this.getTopology()) {
                strbfr.append(shared.printTopology());
            }
        }
        strbfr.append("------broadcast domain-----");
        return strbfr.toString();
    }

    public String printTopologyFromLevel(Set<Integer> bridgeIds, int level) {
        HashSet<Integer> bridgesDownLevel = new HashSet<Integer>();
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("------level ");
        strbfr.append(level);
        strbfr.append(" -----\n");
        strbfr.append("bridges on level:");
        strbfr.append(bridgeIds);
        strbfr.append("\n");
        for (Integer bridgeid : bridgeIds) {
            strbfr.append(this.getBridge(bridgeid).printTopology());
            for (SharedSegment segment : this.getSharedSegmentOnTopologyForBridge(bridgeid)) {
                if (segment.getDesignatedBridge().intValue() != bridgeid.intValue()) continue;
                strbfr.append(segment.printTopology());
                bridgesDownLevel.addAll(segment.getBridgeIdsOnSegment());
            }
        }
        strbfr.append("------level ");
        strbfr.append(level);
        strbfr.append(" -----\n");
        bridgesDownLevel.removeAll(bridgeIds);
        if (!bridgesDownLevel.isEmpty()) {
            strbfr.append(this.printTopologyFromLevel(bridgesDownLevel, level + 1));
        }
        return strbfr.toString();
    }

    public static String printTopologyBFT(List<BridgeMacLink> bft) {
        StringBuffer strbfr = new StringBuffer();
        for (BridgeMacLink link : bft) {
            strbfr.append("nodeid:[");
            strbfr.append(link.getNode().getId());
            strbfr.append("]:");
            strbfr.append(link.getMacAddress());
            strbfr.append(":bridgeport:");
            strbfr.append(link.getBridgePort());
            strbfr.append("\n");
        }
        return strbfr.toString();
    }

    public Bridge electRootBridge() {
        if (this.getBridges().size() == 1) {
            return this.getBridges().iterator().next();
        }
        HashSet<String> rootBridgeIds = new HashSet<String>();
        for (Bridge bridge : this.m_bridges) {
            for (BridgeElement element : bridge.getBridgeElements()) {
                if (!InetAddressUtils.isValidStpBridgeId((String)element.getStpDesignatedRoot()) || element.getBaseBridgeAddress().equals(InetAddressUtils.getBridgeAddressFromStpBridgeId((String)element.getStpDesignatedRoot()))) continue;
                rootBridgeIds.add(InetAddressUtils.getBridgeAddressFromStpBridgeId((String)element.getStpDesignatedRoot()));
            }
        }
        for (String rootBridgeId : rootBridgeIds) {
            for (Bridge bridge : this.m_bridges) {
                for (BridgeElement element : bridge.getBridgeElements()) {
                    if (!element.getBaseBridgeAddress().equals(rootBridgeId)) continue;
                    return bridge;
                }
            }
        }
        return null;
    }
}

