/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.CamelContext;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.language.NamespaceAwareExpression;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public final class RouteContextRefDefinitionHelper {
    private static JAXBContext jaxbContext;

    private RouteContextRefDefinitionHelper() {
    }

    public static synchronized List<RouteDefinition> lookupRoutes(CamelContext camelContext, String ref) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(ref, "ref");
        List answer = CamelContextHelper.lookup(camelContext, ref, List.class);
        if (answer == null) {
            throw new IllegalArgumentException("Cannot find RouteContext with id " + ref);
        }
        ArrayList<RouteDefinition> clones = new ArrayList<RouteDefinition>(answer.size());
        try {
            JAXBContext jaxb = RouteContextRefDefinitionHelper.getOrCreateJAXBContext();
            for (RouteDefinition def : answer) {
                RouteDefinition clone = RouteContextRefDefinitionHelper.cloneRouteDefinition(jaxb, def);
                if (clone == null) continue;
                clones.add(clone);
            }
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return clones;
    }

    private static synchronized JAXBContext getOrCreateJAXBContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.model.rest", (ClassLoader)CamelContext.class.getClassLoader());
        }
        return jaxbContext;
    }

    private static RouteDefinition cloneRouteDefinition(JAXBContext jaxbContext, RouteDefinition def) throws JAXBException {
        Marshaller marshal = jaxbContext.createMarshaller();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        marshal.marshal((Object)def, (OutputStream)bos);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Object clone = unmarshaller.unmarshal((InputStream)bis);
        if (clone != null && clone instanceof RouteDefinition) {
            RouteDefinition def2 = (RouteDefinition)clone;
            Iterator<ExpressionNode> it = ProcessorDefinitionHelper.filterTypeInOutputs(def.getOutputs(), ExpressionNode.class);
            Iterator<ExpressionNode> it2 = ProcessorDefinitionHelper.filterTypeInOutputs(def2.getOutputs(), ExpressionNode.class);
            while (it.hasNext() && it2.hasNext()) {
                ExpressionNode node = it.next();
                ExpressionNode node2 = it2.next();
                NamespaceAwareExpression name = null;
                NamespaceAwareExpression name2 = null;
                if (node.getExpression() instanceof NamespaceAwareExpression) {
                    name = (NamespaceAwareExpression)node.getExpression();
                }
                if (node2.getExpression() instanceof NamespaceAwareExpression) {
                    name2 = (NamespaceAwareExpression)node2.getExpression();
                }
                if (name == null || name2 == null || name.getNamespaces() == null || name.getNamespaces().isEmpty()) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.putAll(name.getNamespaces());
                name2.setNamespaces(map);
            }
            return def2;
        }
        return null;
    }
}

