/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.LogProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="log")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LogDefinition
extends NoOutputDefinition<LogDefinition> {
    @XmlTransient
    private static final Logger LOG = LoggerFactory.getLogger(LogDefinition.class);
    @XmlAttribute(required=true)
    private String message;
    @XmlAttribute
    private LoggingLevel loggingLevel;
    @XmlAttribute
    private String logName;
    @XmlAttribute
    private String marker;
    @XmlAttribute
    private String loggerRef;
    @XmlTransient
    private Logger logger;

    public LogDefinition() {
    }

    public LogDefinition(String message) {
        this.message = message;
    }

    public String toString() {
        return "Log[" + this.message + "]";
    }

    @Override
    public String getLabel() {
        return "log";
    }

    @Override
    public String getShortName() {
        return "log";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ObjectHelper.notEmpty(this.message, "message", this);
        Expression exp = routeContext.getCamelContext().resolveLanguage("simple").createExpression(this.message);
        Logger logger = this.getLogger();
        if (logger == null && ObjectHelper.isNotEmpty(this.loggerRef)) {
            logger = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.loggerRef, Logger.class);
        }
        if (logger == null) {
            Map<String, Logger> availableLoggers = routeContext.lookupByType(Logger.class);
            if (availableLoggers.size() == 1) {
                logger = availableLoggers.values().iterator().next();
                LOG.debug("Using custom Logger: {}", (Object)logger);
            } else if (availableLoggers.size() > 1) {
                LOG.debug("More than one {} instance found in the registry. Falling back to create logger by name.", (Object)Logger.class.getName());
            }
        }
        if (logger == null) {
            String name = this.getLogName();
            if (name == null) {
                name = routeContext.getRoute().getId();
                LOG.debug("The LogName is null. Falling back to create logger by using the route id {}.", (Object)name);
            }
            logger = LoggerFactory.getLogger((String)name);
        }
        LoggingLevel level = this.getLoggingLevel() != null ? this.getLoggingLevel() : LoggingLevel.INFO;
        CamelLogger camelLogger = new CamelLogger(logger, level, this.getMarker());
        return new LogProcessor(exp, camelLogger);
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        this.getParent().addOutput(output);
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getLoggerRef() {
        return this.loggerRef;
    }

    public void setLoggerRef(String loggerRef) {
        this.loggerRef = loggerRef;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

