/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.api;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.users.User;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.netmgt.model.OnmsUserList;

public interface UserConfig {
    public void parseXML(InputStream var1) throws MarshalException, ValidationException;

    public void saveUser(String var1, User var2) throws Exception;

    public void save(OnmsUser var1) throws Exception;

    public boolean isUserOnDuty(String var1, Calendar var2) throws IOException, MarshalException, ValidationException;

    public Map<String, User> getUsers() throws IOException, MarshalException, ValidationException;

    public OnmsUserList getOnmsUserList() throws MarshalException, ValidationException, IOException;

    public OnmsUser getOnmsUser(String var1) throws MarshalException, ValidationException, IOException;

    public boolean hasUser(String var1) throws IOException, MarshalException, ValidationException;

    public List<String> getUserNames() throws IOException, MarshalException, ValidationException;

    public User getUser(String var1) throws IOException, MarshalException, ValidationException;

    public String getTuiPin(String var1) throws IOException, MarshalException, ValidationException;

    public String getTuiPin(User var1) throws IOException, MarshalException, ValidationException;

    public String getMicroblogName(String var1) throws MarshalException, ValidationException, FileNotFoundException, IOException;

    public void setContactInfo(String var1, ContactType var2, String var3) throws Exception;

    public String getContactInfo(String var1, ContactType var2) throws MarshalException, ValidationException, IOException;

    public String getContactInfo(String var1, String var2) throws IOException, MarshalException, ValidationException;

    public String getContactInfo(User var1, String var2) throws IOException, MarshalException, ValidationException;

    public String getContactServiceProvider(String var1, String var2) throws IOException, MarshalException, ValidationException;

    public String getContactServiceProvider(User var1, String var2) throws IOException, MarshalException, ValidationException;

    public String getEmail(String var1) throws IOException, MarshalException, ValidationException;

    public String getEmail(User var1) throws IOException, MarshalException, ValidationException;

    public String getPagerEmail(String var1) throws IOException, MarshalException, ValidationException;

    public String getPagerEmail(User var1) throws IOException, MarshalException, ValidationException;

    public String getNumericPin(String var1) throws IOException, MarshalException, ValidationException;

    public String getNumericPin(User var1) throws IOException, MarshalException, ValidationException;

    public String getXMPPAddress(String var1) throws IOException, MarshalException, ValidationException;

    public String getXMPPAddress(User var1) throws IOException, MarshalException, ValidationException;

    public String getNumericPage(String var1) throws IOException, MarshalException, ValidationException;

    public String getNumericPage(User var1) throws IOException, MarshalException, ValidationException;

    public String getTextPin(String var1) throws IOException, MarshalException, ValidationException;

    public String getTextPin(User var1) throws IOException, MarshalException, ValidationException;

    public String getTextPage(String var1) throws IOException, MarshalException, ValidationException;

    public String getTextPage(User var1) throws IOException, MarshalException, ValidationException;

    public String getWorkPhone(String var1) throws MarshalException, ValidationException, IOException;

    public String getWorkPhone(User var1) throws MarshalException, ValidationException, IOException;

    public String getMobilePhone(String var1) throws MarshalException, ValidationException, IOException;

    public String getMobilePhone(User var1) throws MarshalException, ValidationException, IOException;

    public String getHomePhone(String var1) throws MarshalException, ValidationException, IOException;

    public String getHomePhone(User var1) throws MarshalException, ValidationException, IOException;

    public void saveUsers(Collection<User> var1) throws Exception;

    public void deleteUser(String var1) throws Exception;

    public void renameUser(String var1, String var2) throws Exception;

    public void setEncryptedPassword(String var1, String var2, boolean var3) throws Exception;

    public void setUnencryptedPassword(String var1, String var2) throws Exception;

    public String encryptedPassword(String var1, boolean var2);

    public boolean comparePasswords(String var1, String var2);

    public boolean checkSaltedPassword(String var1, String var2);

    public void update() throws IOException, FileNotFoundException, MarshalException, ValidationException;

    public String[] getUsersWithRole(String var1) throws IOException, MarshalException, ValidationException;

    public boolean userHasRole(User var1, String var2) throws FileNotFoundException, MarshalException, ValidationException, IOException;

    public boolean isUserScheduledForRole(User var1, String var2, Date var3) throws FileNotFoundException, MarshalException, ValidationException, IOException;

    public String[] getUsersScheduledForRole(String var1, Date var2) throws MarshalException, ValidationException, IOException;

    public boolean hasOnCallRole(String var1) throws MarshalException, ValidationException, IOException;

    public int countUsersWithRole(String var1) throws MarshalException, ValidationException, IOException;

    public static enum ContactType {
        email,
        pagerEmail,
        xmppAddress,
        microblog,
        numericPage,
        textPage,
        workPhone,
        mobilePhone,
        homePhone;

    }
}

