/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.translator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.translator.Mapping;

@XmlRootElement(name="mappings")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Mappings
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="mapping")
    private List<Mapping> mappingList = new ArrayList<Mapping>();

    public void addMapping(Mapping vMapping) throws IndexOutOfBoundsException {
        this.mappingList.add(vMapping);
    }

    public void addMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        this.mappingList.add(index, vMapping);
    }

    public Enumeration<Mapping> enumerateMapping() {
        return Collections.enumeration(this.mappingList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Mappings) {
            Mappings temp = (Mappings)obj;
            boolean equals = Objects.equals(temp.mappingList, this.mappingList);
            return equals;
        }
        return false;
    }

    public Mapping getMapping(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.mappingList.size()) {
            throw new IndexOutOfBoundsException("getMapping: Index value '" + index + "' not in range [0.." + (this.mappingList.size() - 1) + "]");
        }
        return this.mappingList.get(index);
    }

    public Mapping[] getMapping() {
        Mapping[] array = new Mapping[]{};
        return this.mappingList.toArray(array);
    }

    public List<Mapping> getMappingCollection() {
        return this.mappingList;
    }

    public int getMappingCount() {
        return this.mappingList.size();
    }

    public int hashCode() {
        int hash = Objects.hash(this.mappingList);
        return hash;
    }

    public Iterator<Mapping> iterateMapping() {
        return this.mappingList.iterator();
    }

    public void removeAllMapping() {
        this.mappingList.clear();
    }

    public boolean removeMapping(Mapping vMapping) {
        boolean removed = this.mappingList.remove(vMapping);
        return removed;
    }

    public Mapping removeMappingAt(int index) {
        Mapping obj = this.mappingList.remove(index);
        return obj;
    }

    public void setMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.mappingList.size()) {
            throw new IndexOutOfBoundsException("setMapping: Index value '" + index + "' not in range [0.." + (this.mappingList.size() - 1) + "]");
        }
        this.mappingList.set(index, vMapping);
    }

    public void setMapping(Mapping[] vMappingArray) {
        this.mappingList.clear();
        for (int i = 0; i < vMappingArray.length; ++i) {
            this.mappingList.add(vMappingArray[i]);
        }
    }

    public void setMapping(List<Mapping> vMappingList) {
        this.mappingList.clear();
        this.mappingList.addAll(vMappingList);
    }

    public void setMappingCollection(List<Mapping> mappingList) {
        this.mappingList = mappingList;
    }
}

