/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifications;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.notifications.Header;
import org.opennms.netmgt.config.notifications.Notification;

@XmlRootElement(name="notifications")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Notifications
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="header", required=true)
    private Header header;
    @XmlElement(name="notification", required=true)
    private List<Notification> notificationList = new ArrayList<Notification>();

    public void addNotification(Notification vNotification) throws IndexOutOfBoundsException {
        this.notificationList.add(vNotification);
    }

    public void addNotification(int index, Notification vNotification) throws IndexOutOfBoundsException {
        this.notificationList.add(index, vNotification);
    }

    public Enumeration<Notification> enumerateNotification() {
        return Collections.enumeration(this.notificationList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Notifications) {
            Notifications temp = (Notifications)obj;
            boolean equals = Objects.equals(temp.header, this.header) && Objects.equals(temp.notificationList, this.notificationList);
            return equals;
        }
        return false;
    }

    public Header getHeader() {
        return this.header;
    }

    public Notification getNotification(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.notificationList.size()) {
            throw new IndexOutOfBoundsException("getNotification: Index value '" + index + "' not in range [0.." + (this.notificationList.size() - 1) + "]");
        }
        return this.notificationList.get(index);
    }

    public Notification[] getNotification() {
        Notification[] array = new Notification[]{};
        return this.notificationList.toArray(array);
    }

    public List<Notification> getNotificationCollection() {
        return this.notificationList;
    }

    public int getNotificationCount() {
        return this.notificationList.size();
    }

    public int hashCode() {
        int hash = Objects.hash(this.header, this.notificationList);
        return hash;
    }

    public Iterator<Notification> iterateNotification() {
        return this.notificationList.iterator();
    }

    public void removeAllNotification() {
        this.notificationList.clear();
    }

    public boolean removeNotification(Notification vNotification) {
        boolean removed = this.notificationList.remove(vNotification);
        return removed;
    }

    public Notification removeNotificationAt(int index) {
        Notification obj = this.notificationList.remove(index);
        return obj;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public void setNotification(int index, Notification vNotification) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.notificationList.size()) {
            throw new IndexOutOfBoundsException("setNotification: Index value '" + index + "' not in range [0.." + (this.notificationList.size() - 1) + "]");
        }
        this.notificationList.set(index, vNotification);
    }

    public void setNotification(Notification[] vNotificationArray) {
        this.notificationList.clear();
        for (int i = 0; i < vNotificationArray.length; ++i) {
            this.notificationList.add(vNotificationArray[i]);
        }
    }

    public void setNotification(List<Notification> vNotificationList) {
        this.notificationList.clear();
        this.notificationList.addAll(vNotificationList);
    }

    public void setNotificationCollection(List<Notification> notificationList) {
        this.notificationList = notificationList;
    }
}

